/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.lbs.policy.counters;

import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.DefaultInstrumentFactory;
import com.bigdata.counters.ICounterNode;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.sail.webapp.client.EntityContentProvider;
import com.bigdata.rdf.sail.webapp.client.JettyResponseListener;
import com.bigdata.rdf.sail.webapp.client.RemoteRepository;
import com.bigdata.rdf.sail.webapp.lbs.AbstractHostLBSPolicy;
import com.bigdata.rdf.sail.webapp.lbs.IHostMetrics;
import com.bigdata.rdf.sail.webapp.lbs.IHostScoringRule;
import com.bigdata.rdf.sail.webapp.lbs.ServiceScore;
import com.bigdata.rdf.sail.webapp.lbs.policy.counters.CounterSetHostMetricsWrapper;
import com.bigdata.rdf.sail.webapp.lbs.policy.counters.DefaultHostScoringRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpMethod;

public class CountersLBSPolicy
extends AbstractHostLBSPolicy {
    private static final Logger log = Logger.getLogger(CountersLBSPolicy.class);
    private static final long serialVersionUID = 1L;
    private final ConcurrentHashMap<String, IHostMetrics> hostMetricsMap = new ConcurrentHashMap();
    private final AtomicInteger nextValue = new AtomicInteger();

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
    }

    @Override
    public void init(ServletConfig servletConfig, IIndexManager indexManager) throws ServletException {
        super.init(servletConfig, indexManager);
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected Map<String, IHostMetrics> getHostReportForKnownServices(IHostScoringRule scoringRule, ServiceScore[] serviceScores) {
        LinkedList<String> tmp = new LinkedList<String>();
        for (ServiceScore serviceScore : serviceScores) {
            String hostname;
            if (serviceScore == null || (hostname = serviceScore.getHostname()) == null) continue;
            tmp.add(hostname);
        }
        String[] hosts = tmp.toArray(new String[tmp.size()]);
        HttpClient cm = this.getClientConnectionManager();
        for (String hostname : hosts) {
            CounterSet counterSet;
            String baseRequestURI = this.getServiceScoreForHostname(hostname).getRequestURI();
            try {
                counterSet = CountersLBSPolicy.doCountersQuery(cm, hostname, baseRequestURI, this.nextValue.incrementAndGet());
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                continue;
            }
            if (counterSet.isRoot() && counterSet.isLeaf()) {
                log.warn((Object)("No data: hostname=" + (String)hostname));
                continue;
            }
            ICounterNode childNode = counterSet.getPath(hostname);
            if (childNode == null) {
                log.warn((Object)("No data: hostname=" + (String)hostname));
                continue;
            }
            this.hostMetricsMap.put(hostname, new CounterSetHostMetricsWrapper((CounterSet)childNode));
        }
        return this.hostMetricsMap;
    }

    private HttpClient getClientConnectionManager() {
        Journal journal = (Journal)((Object)this.getJournal());
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getExistingQueryController(journal);
        if (queryEngine == null) {
            queryEngine = QueryEngineFactory.getInstance().getQueryController(journal);
        }
        HttpClient cm = queryEngine.getClientConnectionManager();
        return cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CounterSet doCountersQuery(HttpClient cm, String hostname, String baseRequestURI, int uniqueId) throws Exception {
        String uriStr = baseRequestURI + "/counters";
        ConnectOptions o = new ConnectOptions(uriStr);
        o.setAcceptHeader("application/xml");
        o.method = "GET";
        o.addRequestParam("path", "/" + hostname + "/");
        o.addRequestParam("depth", "3");
        o.addRequestParam("uniqueId", Integer.toString(uniqueId));
        boolean didDrainEntity = false;
        JettyResponseListener response = null;
        try {
            CounterSet counterSet;
            response = CountersLBSPolicy.doConnect(cm, o);
            RemoteRepository.checkResponseCode((JettyResponseListener)response);
            String contentType = response.getContentType();
            if (!contentType.startsWith("application/xml")) {
                throw new IOException("Expecting application/xml, not Content-Type=" + contentType);
            }
            CounterSet counterSet2 = new CounterSet();
            InputStream is = response.getInputStream();
            try {
                counterSet2.readXML(is, DefaultInstrumentFactory.NO_OVERWRITE_60M, null);
                didDrainEntity = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("hostname=" + hostname + ": counters=" + counterSet2));
                }
                counterSet = counterSet2;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    log.warn((Object)ex);
                }
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException ex) {
                log.warn((Object)ex);
            }
            return counterSet;
        }
        finally {
            if (response != null && !didDrainEntity) {
                response.abort();
            }
        }
    }

    private static JettyResponseListener doConnect(HttpClient httpClient, ConnectOptions opts) throws IOException {
        String requestURL = opts.serviceURL;
        StringBuilder urlString = new StringBuilder(requestURL);
        ConnectOptions.addQueryParams((StringBuilder)urlString, (Map)opts.requestParams);
        if (log.isDebugEnabled()) {
            log.debug((Object)"*** Request ***");
            log.debug((Object)requestURL);
            log.debug((Object)opts.method);
            log.debug((Object)urlString.toString());
        }
        Request request = null;
        try {
            request = httpClient.newRequest(urlString.toString()).method(HttpMethod.GET);
            if (opts.requestHeaders != null) {
                for (Map.Entry e : opts.requestHeaders.entrySet()) {
                    request.header((String)e.getKey(), (String)e.getValue());
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)((String)e.getKey() + ": " + (String)e.getValue()));
                }
            }
            if (opts.entity != null) {
                EntityContentProvider cp = new EntityContentProvider(opts.entity);
                request.content((ContentProvider)cp, cp.getContentType());
            }
            JettyResponseListener listener = new JettyResponseListener(request, TimeUnit.SECONDS.toMillis(300L));
            request.send((Response.CompleteListener)listener);
            return listener;
        }
        catch (Throwable t) {
            try {
                if (request != null) {
                    request.abort(t);
                }
            }
            catch (Throwable t2) {
                log.warn((Object)t2);
            }
            throw new RuntimeException(requestURL + " : " + t, t);
        }
    }

    @Override
    protected String getDefaultScoringRule() {
        return DefaultHostScoringRule.class.getName();
    }

    public static interface InitParams
    extends AbstractHostLBSPolicy.InitParams {
    }
}

