/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.btree.IndexMetadata;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.Journal;
import com.bigdata.rdf.properties.PropertiesFormat;
import com.bigdata.rdf.properties.PropertiesParser;
import com.bigdata.rdf.properties.PropertiesParserFactory;
import com.bigdata.rdf.properties.PropertiesParserRegistry;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.BigdataSailRepositoryConnection;
import com.bigdata.rdf.sail.webapp.AbstractRestApiTask;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.DatasetNotFoundException;
import com.bigdata.rdf.sail.webapp.HttpOperationException;
import com.bigdata.rdf.sail.webapp.RESTServlet;
import com.bigdata.rdf.sail.webapp.RestApiCreateKBTask;
import com.bigdata.rdf.sail.webapp.RestApiDestroyKBTask;
import com.bigdata.rdf.sail.webapp.VoID;
import com.bigdata.rdf.sail.webapp.client.ConnectOptions;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.RelationSchema;
import com.bigdata.service.AbstractClient;
import com.bigdata.service.AbstractFederation;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.util.InnerCause;
import com.bigdata.util.NV;
import com.bigdata.util.PropertyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.impl.LinkedHashModel;
import org.openrdf.model.impl.ValueFactoryImpl;

public class MultiTenancyServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MultiTenancyServlet.class);
    protected static final String DESCRIBE_EACH_NAMED_GRAPH = "describe-each-named-graph";
    protected static final String DESCRIBE_DEFAULT_NAMESPACE = "describe-default-namespace";
    private static final String FORCE_INDEX_CREATE_PARAMETER = "force-index-create";
    private RESTServlet m_restServlet;
    private static final String namespaceRegex = "[^.]+\\Z";
    public static final Set<String> PROPERTIES_BLACK_LIST = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(Journal.Options.BUFFER_MODE, Journal.Options.FILE, Journal.Options.INITIAL_EXTENT, Journal.Options.MAXIMUM_EXTENT, IndexMetadata.Options.WRITE_RETENTION_QUEUE_CAPACITY, IndexMetadata.Options.BTREE_BRANCHING_FACTOR, RelationSchema.CLASS, AbstractTransactionService.Options.MIN_RELEASE_AGE, RelationSchema.NAMESPACE, RelationSchema.CONTAINER)));

    public void init() throws ServletException {
        super.init();
        this.m_restServlet = new RESTServlet();
        this.m_restServlet.init(this.getServletConfig());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getRequestURI().endsWith("/namespace")) {
            this.doCreateNamespace(req, resp);
            return;
        }
        if (req.getRequestURI().endsWith("/prepareProperties")) {
            this.doPrepareProperties(req, resp);
            return;
        }
        String namespace = this.getNamespace(req);
        if (req.getRequestURI().endsWith(ConnectOptions.urlEncode((String)namespace) + "/textIndex")) {
            this.doRebuildTextIndex(req, resp, namespace);
            return;
        }
        this.m_restServlet.doPost(req, resp);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!MultiTenancyServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String namespace = this.getNamespace(req);
        if (req.getRequestURI().endsWith("/namespace/" + ConnectOptions.urlEncode((String)namespace))) {
            this.doDeleteNamespace(req, resp);
            return;
        }
        this.m_restServlet.doDelete(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!MultiTenancyServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        this.m_restServlet.doPut(req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getRequestURI().endsWith("/namespace")) {
            this.doDescribeNamespaces(req, resp);
            return;
        }
        if (req.getRequestURI().endsWith("/properties")) {
            this.doShowProperties(req, resp);
            return;
        }
        this.m_restServlet.doGet(req, resp);
    }

    private void doPrepareProperties(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Properties defaults;
        PropertiesParserFactory parserFactory;
        PropertiesFormat format;
        if (!MultiTenancyServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        BigdataRDFContext context = this.getBigdataRDFContext();
        IIndexManager indexManager = context.getIndexManager();
        long timestamp = this.getTimestamp(req);
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if ((format = PropertiesFormat.forMIMEType((String)contentType)) == null) {
            MultiTenancyServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as Properties: " + contentType, new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Format=" + format));
        }
        if ((parserFactory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get((Object)format)) == null) {
            MultiTenancyServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format, new NV[0]);
            return;
        }
        PropertiesParser parser = parserFactory.getParser();
        Properties given = parser.parse((InputStream)req.getInputStream());
        BigdataSail.checkProperties(given);
        String namespace = given.getProperty(BigdataSail.Options.NAMESPACE, "kb");
        try {
            if (!Pattern.matches(namespaceRegex, namespace)) {
                throw new IllegalArgumentException("Namespace should not be empty nor include '.' character");
            }
        }
        catch (Throwable e) {
            MultiTenancyServlet.launderThrowable(e, resp, "namespace=" + namespace);
            return;
        }
        if (indexManager instanceof IJournal) {
            IJournal jnl = (IJournal)indexManager;
            defaults = new Properties(jnl.getProperties());
        } else {
            AbstractFederation fed = (AbstractFederation)indexManager;
            defaults = ((AbstractClient)fed.getClient()).getProperties();
        }
        final Properties effectiveProperties = PropertyUtil.flatCopy((Properties)defaults);
        for (Map.Entry<Object, Object> e : given.entrySet()) {
            String string = (String)e.getKey();
            Object val = e.getValue();
            if (val == null) continue;
            effectiveProperties.put(string, val);
        }
        HashSet<Object> keySet = new HashSet<Object>();
        keySet.addAll(effectiveProperties.keySet());
        for (String string : keySet) {
            String newName;
            if (PROPERTIES_BLACK_LIST.contains(string)) {
                effectiveProperties.remove(string);
            }
            if ((newName = string.replaceAll("(?<=\\.namespace\\.)([^.]+)(?=\\.)", Matcher.quoteReplacement(namespace))).equals(string)) continue;
            Object val = effectiveProperties.get(string);
            effectiveProperties.remove(string);
            effectiveProperties.put(newName, val);
        }
        try {
            this.submitApiTask(new AbstractRestApiTask<Void>(req, resp, namespace, timestamp){

                @Override
                public boolean isReadOnly() {
                    return true;
                }

                @Override
                public Void call() throws Exception {
                    BigdataRDFServlet.sendProperties(this.req, this.resp, effectiveProperties);
                    return null;
                }
            }).get();
        }
        catch (Throwable t) {
            MultiTenancyServlet.launderThrowable(t, resp, "namespace=" + namespace);
        }
    }

    private void doCreateNamespace(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        PropertiesParserFactory parserFactory;
        PropertiesFormat format;
        if (!MultiTenancyServlet.isWritable(this.getServletContext(), req, resp)) {
            return;
        }
        String contentType = req.getContentType();
        if (log.isInfoEnabled()) {
            log.info((Object)("Request body: " + contentType));
        }
        if ((format = PropertiesFormat.forMIMEType((String)contentType)) == null) {
            MultiTenancyServlet.buildAndCommitResponse(resp, 400, "text/plain", "Content-Type not recognized as Properties: " + contentType, new NV[0]);
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Format=" + format));
        }
        if ((parserFactory = (PropertiesParserFactory)PropertiesParserRegistry.getInstance().get((Object)format)) == null) {
            MultiTenancyServlet.buildAndCommitResponse(resp, 500, "text/plain", "Parser factory not found: Content-Type=" + contentType + ", format=" + format, new NV[0]);
            return;
        }
        PropertiesParser parser = parserFactory.getParser();
        Properties props = parser.parse((InputStream)req.getInputStream());
        String namespace = props.getProperty(BigdataSail.Options.NAMESPACE, "kb");
        try {
            if (!Pattern.matches(namespaceRegex, namespace)) {
                throw new IllegalArgumentException("Namespace should not be empty nor include '.' character");
            }
            this.submitApiTask(new RestApiCreateKBTask(req, resp, namespace, props)).get();
        }
        catch (Throwable e) {
            MultiTenancyServlet.launderThrowable(e, resp, "namespace=" + namespace);
        }
    }

    private void doDeleteNamespace(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String namespace = this.getNamespace(req);
        try {
            this.submitApiTask(new RestApiDestroyKBTask(req, resp, namespace)).get();
        }
        catch (Throwable e) {
            MultiTenancyServlet.launderThrowable(e, resp, "DELETE NAMESPACE: namespace=" + namespace);
        }
    }

    private void doShowProperties(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String namespace = this.getNamespace(req);
        long timestamp = this.getTimestamp(req);
        try {
            this.submitApiTask(new AbstractRestApiTask<Void>(req, resp, namespace, timestamp){

                @Override
                public boolean isReadOnly() {
                    return true;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Void void_;
                    BigdataSailRepositoryConnection conn = this.getQueryConnection();
                    try {
                        Properties properties = PropertyUtil.flatCopy((Properties)conn.getTripleStore().getProperties());
                        BigdataRDFServlet.sendProperties(this.req, this.resp, properties);
                        void_ = null;
                    }
                    catch (Throwable throwable) {
                        try {
                            conn.close();
                            throw throwable;
                        }
                        catch (Throwable t) {
                            if (InnerCause.isInnerCause((Throwable)t, DatasetNotFoundException.class)) {
                                throw new HttpOperationException(404, "text/plain", "Not found: namespace=" + this.namespace);
                            }
                            throw new RuntimeException(t);
                        }
                    }
                    conn.close();
                    return void_;
                }
            }).get();
        }
        catch (Throwable t) {
            MultiTenancyServlet.launderThrowable(t, resp, "namespace=" + namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDescribeNamespaces(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        long timestamp = this.getTimestamp(req);
        String s = req.getParameter(DESCRIBE_EACH_NAMED_GRAPH);
        boolean describeEachNamedGraph = s != null ? Boolean.valueOf(s) : this.getBigdataRDFContext().getConfig().describeEachNamedGraph;
        String s2 = req.getParameter(DESCRIBE_DEFAULT_NAMESPACE);
        boolean describeDefaultNamespace = s2 != null ? Boolean.valueOf(s2) : false;
        long tx = this.getBigdataRDFContext().newTx(timestamp);
        try {
            LinkedHashModel g = new LinkedHashModel();
            if (describeDefaultNamespace) {
                String namespace = this.getBigdataRDFContext().getConfig().namespace;
                this.describeNamespaceTx(req, (Graph)g, namespace, describeEachNamedGraph, tx);
            } else {
                List<String> namespaces = this.getBigdataRDFContext().getNamespacesTx(tx);
                for (String namespace : namespaces) {
                    this.describeNamespaceTx(req, (Graph)g, namespace, describeEachNamedGraph, tx);
                }
            }
            MultiTenancyServlet.sendGraph(req, resp, (Graph)g);
        }
        catch (Throwable t) {
            MultiTenancyServlet.launderThrowable(t, resp, "describeEachNamedGraph=" + describeEachNamedGraph + ", describeDefaultNamespace=" + describeDefaultNamespace);
        }
        finally {
            this.getBigdataRDFContext().abortTx(tx);
        }
    }

    private void describeNamespaceTx(HttpServletRequest req, Graph g, String namespace, boolean describeEachNamedGraph, long tx) throws IOException {
        AbstractTripleStore tripleStore = this.getBigdataRDFContext().getTripleStore(namespace, tx);
        if (tripleStore == null) {
            return;
        }
        BNode aDataSet = ValueFactoryImpl.getInstance().createBNode();
        String[] serviceURI = MultiTenancyServlet.getServiceURIs(this.getServletContext(), req);
        VoID v = new VoID(g, tripleStore, serviceURI, (Resource)aDataSet);
        v.describeDataSet(false, describeEachNamedGraph);
    }

    private void doRebuildTextIndex(HttpServletRequest req, HttpServletResponse resp, String namespace) throws IOException {
        boolean forceIndexCreate = Boolean.TRUE.toString().equals(req.getParameter(FORCE_INDEX_CREATE_PARAMETER));
        PrintWriter writer = resp.getWriter();
        try {
            AbstractTripleStore store = this.getBigdataRDFContext().getTripleStore(namespace, 0L);
            store.getLexiconRelation().rebuildTextIndex(forceIndexCreate);
            writer.append("Text index rebuild completed");
        }
        catch (UnsupportedOperationException e) {
            writer.append(e.getMessage());
            resp.sendError(500, e.getMessage());
        }
    }
}

