/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.quorum;

import com.bigdata.quorum.AsynchronousQuorumCloseException;
import com.bigdata.quorum.QuorumActor;
import com.bigdata.quorum.QuorumClient;
import com.bigdata.quorum.QuorumListener;
import com.bigdata.quorum.QuorumMember;
import java.rmi.Remote;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public interface Quorum<S extends Remote, C extends QuorumClient<S>> {
    public static final long NO_QUORUM = -1L;

    public int replicationFactor();

    public boolean isQuorum(int var1);

    public long token();

    public long lastValidToken();

    public boolean isHighlyAvailable();

    public boolean isQuorumMet();

    public boolean isQuorumFullyMet(long var1);

    public void addListener(QuorumListener var1);

    public void removeListener(QuorumListener var1);

    public UUID[] getMembers();

    public Map<Long, UUID[]> getVotes();

    public Long getCastVote(UUID var1);

    public Long getCastVoteIfConsensus(UUID var1);

    public UUID[] getJoined();

    public UUID[] getPipeline();

    public UUID getLastInPipeline();

    public UUID[] getPipelinePriorAndNext(UUID var1);

    public long awaitQuorum() throws InterruptedException, AsynchronousQuorumCloseException;

    public long awaitQuorum(long var1, TimeUnit var3) throws InterruptedException, AsynchronousQuorumCloseException, TimeoutException;

    public void awaitBreak() throws InterruptedException, AsynchronousQuorumCloseException;

    public void awaitBreak(long var1, TimeUnit var3) throws InterruptedException, AsynchronousQuorumCloseException, TimeoutException;

    public void assertQuorum(long var1);

    public void assertLeader(long var1);

    public UUID getLeaderId();

    public void start(C var1);

    public void terminate();

    public C getClient();

    public QuorumMember<S> getMember();

    public QuorumActor<S, C> getActor();
}

