/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.BigdataStatics;
import com.bigdata.btree.BTree;
import com.bigdata.btree.Checkpoint;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleIterator;
import com.bigdata.btree.IndexInconsistentError;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.keys.ICUVersionRecord;
import com.bigdata.cache.ConcurrentWeakValueCache;
import com.bigdata.cache.ConcurrentWeakValueCacheWithTimeout;
import com.bigdata.concurrent.FutureTaskMon;
import com.bigdata.config.Configuration;
import com.bigdata.config.IValidator;
import com.bigdata.config.IntegerRangeValidator;
import com.bigdata.config.IntegerValidator;
import com.bigdata.config.LongRangeValidator;
import com.bigdata.config.LongValidator;
import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.Instrument;
import com.bigdata.ha.CommitRequest;
import com.bigdata.ha.CommitResponse;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.HAStatusEnum;
import com.bigdata.ha.HATXSGlue;
import com.bigdata.ha.IHAPipelineResetRequest;
import com.bigdata.ha.IHAPipelineResetResponse;
import com.bigdata.ha.IIndexManagerCallable;
import com.bigdata.ha.IJoinedAndNonJoinedServices;
import com.bigdata.ha.JoinedAndNonJoinedServices;
import com.bigdata.ha.PrepareRequest;
import com.bigdata.ha.PrepareResponse;
import com.bigdata.ha.QuorumService;
import com.bigdata.ha.RunState;
import com.bigdata.ha.msg.HANotifyReleaseTimeResponse;
import com.bigdata.ha.msg.HAReadResponse;
import com.bigdata.ha.msg.HARootBlockRequest;
import com.bigdata.ha.msg.HARootBlockResponse;
import com.bigdata.ha.msg.HAWriteSetStateResponse;
import com.bigdata.ha.msg.IHA2PhaseAbortMessage;
import com.bigdata.ha.msg.IHA2PhaseCommitMessage;
import com.bigdata.ha.msg.IHA2PhasePrepareMessage;
import com.bigdata.ha.msg.IHAAwaitServiceJoinRequest;
import com.bigdata.ha.msg.IHADigestRequest;
import com.bigdata.ha.msg.IHADigestResponse;
import com.bigdata.ha.msg.IHAGatherReleaseTimeRequest;
import com.bigdata.ha.msg.IHALogDigestRequest;
import com.bigdata.ha.msg.IHALogDigestResponse;
import com.bigdata.ha.msg.IHALogRequest;
import com.bigdata.ha.msg.IHALogRootBlocksRequest;
import com.bigdata.ha.msg.IHALogRootBlocksResponse;
import com.bigdata.ha.msg.IHANotifyReleaseTimeRequest;
import com.bigdata.ha.msg.IHANotifyReleaseTimeResponse;
import com.bigdata.ha.msg.IHAReadRequest;
import com.bigdata.ha.msg.IHAReadResponse;
import com.bigdata.ha.msg.IHARebuildRequest;
import com.bigdata.ha.msg.IHARemoteRebuildRequest;
import com.bigdata.ha.msg.IHARootBlockRequest;
import com.bigdata.ha.msg.IHARootBlockResponse;
import com.bigdata.ha.msg.IHASendState;
import com.bigdata.ha.msg.IHASendStoreResponse;
import com.bigdata.ha.msg.IHASnapshotDigestRequest;
import com.bigdata.ha.msg.IHASnapshotDigestResponse;
import com.bigdata.ha.msg.IHASnapshotRequest;
import com.bigdata.ha.msg.IHASnapshotResponse;
import com.bigdata.ha.msg.IHASyncRequest;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.ha.msg.IHAWriteSetStateRequest;
import com.bigdata.ha.msg.IHAWriteSetStateResponse;
import com.bigdata.ha.msg.Mock2PhaseCommitProtocolException;
import com.bigdata.htree.HTree;
import com.bigdata.io.ChecksumUtility;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.SerializerUtil;
import com.bigdata.journal.AbortRequiredException;
import com.bigdata.journal.BufferMode;
import com.bigdata.journal.CommitRecord;
import com.bigdata.journal.CommitRecordIndex;
import com.bigdata.journal.CommitRecordSerializer;
import com.bigdata.journal.DeleteBlockCommitter;
import com.bigdata.journal.DirectBufferStrategy;
import com.bigdata.journal.DiskOnlyStrategy;
import com.bigdata.journal.FileMetadata;
import com.bigdata.journal.ForceEnum;
import com.bigdata.journal.IBufferStrategy;
import com.bigdata.journal.ICommitRecord;
import com.bigdata.journal.ICommitter;
import com.bigdata.journal.IHABufferStrategy;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.ILocalTransactionManager;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.ITx;
import com.bigdata.journal.Journal;
import com.bigdata.journal.JournalTransactionService;
import com.bigdata.journal.MappedBufferStrategy;
import com.bigdata.journal.Name2Addr;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.Options;
import com.bigdata.journal.RWStrategy;
import com.bigdata.journal.RootBlockCommitter;
import com.bigdata.journal.RootBlockUtility;
import com.bigdata.journal.RootBlockView;
import com.bigdata.journal.StoreTypeEnum;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.journal.TransactionNotFoundException;
import com.bigdata.journal.TransientBufferStrategy;
import com.bigdata.journal.WORMStrategy;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.JournalMetadata;
import com.bigdata.quorum.AsynchronousQuorumCloseException;
import com.bigdata.quorum.Quorum;
import com.bigdata.quorum.QuorumActor;
import com.bigdata.quorum.QuorumException;
import com.bigdata.quorum.QuorumTokenTransitions;
import com.bigdata.rawstore.IAllocationContext;
import com.bigdata.rawstore.IAllocationManagerStore;
import com.bigdata.rawstore.IPSOutputStream;
import com.bigdata.rawstore.SimpleMemoryRawStore;
import com.bigdata.resources.ResourceManager;
import com.bigdata.rwstore.IAllocationManager;
import com.bigdata.rwstore.IHistoryManager;
import com.bigdata.rwstore.IRWStrategy;
import com.bigdata.rwstore.RWStore;
import com.bigdata.rwstore.sector.MemStrategy;
import com.bigdata.rwstore.sector.MemoryManager;
import com.bigdata.service.AbstractHATransactionService;
import com.bigdata.service.AbstractTransactionService;
import com.bigdata.util.BytesUtil;
import com.bigdata.util.ClocksNotSynchronizedException;
import com.bigdata.util.NT;
import com.bigdata.util.StackInfoReport;
import cutthecrap.utils.striterators.IFilter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.rmi.RemoteException;
import java.security.DigestException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log4j.Logger;

public abstract class AbstractJournal
implements IJournal,
IAllocationManager,
IAllocationManagerStore {
    private static final Logger log = Logger.getLogger(AbstractJournal.class);
    private static final Logger txLog = Logger.getLogger((String)"com.bigdata.txLog");
    protected static final Logger haLog = Logger.getLogger((String)"com.bigdata.haLog");
    public static final transient int ROOT_NAME2ADDR = 0;
    public static final transient int PREV_ROOTBLOCK = 1;
    public static final transient int DELETEBLOCK = 2;
    public static final transient int ROOT_ICUVERSION = 3;
    protected final Properties properties;
    static final AtomicInteger nopen = new AtomicInteger();
    static final AtomicInteger nclose = new AtomicInteger();
    static final AtomicInteger ndestroy = new AtomicInteger();
    public final File tmpDir;
    private final ChecksumUtility checker = new ChecksumUtility();
    private FileMetadata fileMetadata;
    private final IBufferStrategy _bufferStrategy;
    private final AtomicReference<JournalMetadata> journalMetadata = new AtomicReference();
    private volatile IRootBlockView _rootBlock;
    private volatile ICommitter[] _committers = new ICommitter[50];
    private final ReentrantReadWriteLock _fieldReadWriteLock = new ReentrantReadWriteLock(false);
    private final Lock _gatherLock = new ReentrantLock();
    private volatile ICommitRecord _commitRecord;
    private volatile CommitRecordIndex _commitRecordIndex;
    private volatile ICUVersionRecord _icuVersionRecord;
    private final int liveIndexCacheCapacity;
    private final long liveIndexCacheTimeout;
    private final int historicalIndexCacheCapacity;
    private final long historicalIndexCacheTimeout;
    private final ConcurrentWeakValueCache<Long, ICommitter> historicalIndexCache;
    private final ConcurrentWeakValueCacheWithTimeout<NT, ICheckpointProtocol> indexCache;
    private volatile Name2Addr _name2Addr;
    private final AtomicBoolean abortRequired = new AtomicBoolean(false);
    private final boolean readOnly;
    protected final boolean doubleSync;
    protected final ForceEnum forceOnCommit;
    protected final boolean deleteOnClose;
    private final long maximumExtent;
    private final long initialExtent;
    private final long minimumExtension;
    private RootBlockCommitter m_rootBlockCommitter;
    private final CommitCounters commitCounters = new CommitCounters();
    private volatile long quorumToken = -1L;
    private final Condition haReadyCondition = this._fieldReadWriteLock.writeLock().newCondition();
    private volatile long haReadyToken = -1L;
    private volatile HAStatusEnum haStatus = HAStatusEnum.NotReady;
    private final Quorum<HAGlue, QuorumService<HAGlue>> quorum;
    private final AtomicReference<Future<IHANotifyReleaseTimeResponse>> gatherFuture = new AtomicReference();

    FileMetadata getFileMetadata() {
        return this.fileMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Name2Addr _getName2Addr() {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            Name2Addr tmp = this._name2Addr;
            if (tmp == null) {
                throw new AssertionError();
            }
            Name2Addr name2Addr = tmp;
            return name2Addr;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex getName2Addr() {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            long checkpointAddr = this._name2Addr == null ? this.getRootAddr(0) : this._name2Addr.getCheckpoint().getCheckpointAddr();
            BTree btree = (BTree)this.getIndexWithCheckpointAddr(checkpointAddr);
            if (this._name2Addr == btree) {
                throw new AssertionError();
            }
            long lastCommitTime = this.getLastCommitTime();
            if (lastCommitTime != 0L) {
                btree.setLastCommitTime(lastCommitTime);
            }
            BTree bTree = btree;
            return bTree;
        }
        finally {
            lock.unlock();
        }
    }

    public IIndex getName2Addr(long commitTime) {
        ICommitRecord commitRecord = this.getCommitRecord(commitTime);
        if (commitRecord == null) {
            return null;
        }
        long checkpointAddr = commitRecord.getRootAddr(0);
        Name2Addr n2a = (Name2Addr)this.getIndexWithCheckpointAddr(checkpointAddr);
        long commitTime2 = commitRecord.getTimestamp();
        n2a.setLastCommitTime(commitTime2);
        return n2a;
    }

    public final long getMaximumExtent() {
        return this.maximumExtent;
    }

    protected static String getProperty(Properties properties, String name, String defaultValue) {
        return Configuration.getProperty(null, properties, "", name, defaultValue);
    }

    protected String getProperty(String name, String defaultValue) {
        return Configuration.getProperty(this, this.properties, "", name, defaultValue);
    }

    protected <E> E getProperty(String name, String defaultValue, IValidator<E> validator) {
        return Configuration.getProperty(this, this.properties, "", name, defaultValue, validator);
    }

    protected AbstractJournal(Properties properties) {
        this(properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractJournal(Properties properties, Quorum<HAGlue, QuorumService<HAGlue>> quorum) {
        if (properties == null) {
            throw new IllegalArgumentException();
        }
        this.properties = properties = (Properties)properties.clone();
        this.quorum = quorum;
        this.historicalIndexCacheCapacity = this.getProperty(Options.HISTORICAL_INDEX_CACHE_CAPACITY, "60", IntegerValidator.GT_ZERO);
        this.historicalIndexCacheTimeout = this.getProperty(Options.HISTORICAL_INDEX_CACHE_TIMEOUT, "60000", LongValidator.GTE_ZERO);
        this.historicalIndexCache = new ConcurrentWeakValueCacheWithTimeout(this.historicalIndexCacheCapacity, TimeUnit.MILLISECONDS.toNanos(this.historicalIndexCacheTimeout));
        this.indexCache = new ConcurrentWeakValueCacheWithTimeout(this.historicalIndexCacheCapacity, TimeUnit.MILLISECONDS.toNanos(this.historicalIndexCacheTimeout));
        this.liveIndexCacheCapacity = this.getProperty(Options.LIVE_INDEX_CACHE_CAPACITY, "60", IntegerValidator.GT_ZERO);
        this.liveIndexCacheTimeout = this.getProperty(Options.LIVE_INDEX_CACHE_TIMEOUT, "60000", LongValidator.GTE_ZERO);
        this.initialExtent = this.getProperty(Options.INITIAL_EXTENT, "10485760", new LongRangeValidator(0x100000L, Long.MAX_VALUE));
        this.maximumExtent = this.getProperty(Options.MAXIMUM_EXTENT, "209715200", new LongRangeValidator(this.initialExtent, Long.MAX_VALUE));
        this.minimumExtension = this.getProperty(Options.MINIMUM_EXTENSION, "33554432", new LongRangeValidator(0x100000L, Long.MAX_VALUE));
        this.readOnly = Boolean.parseBoolean(this.getProperty(Options.READ_ONLY, "false"));
        this.forceOnCommit = ForceEnum.parse(this.getProperty(Options.FORCE_ON_COMMIT, Options.DEFAULT_FORCE_ON_COMMIT));
        this.doubleSync = Boolean.parseBoolean(this.getProperty(Options.DOUBLE_SYNC, "false"));
        this.deleteOnClose = Boolean.parseBoolean(this.getProperty(Options.DELETE_ON_CLOSE, "false"));
        this.tmpDir = new File(this.getProperty(Options.TMP_DIR, System.getProperty("java.io.tmpdir")));
        if (!this.tmpDir.exists() && !this.tmpDir.mkdirs()) {
            throw new RuntimeException("Could not create directory: " + this.tmpDir.getAbsolutePath());
        }
        if (!this.tmpDir.isDirectory()) {
            throw new RuntimeException("Not a directory: " + this.tmpDir.getAbsolutePath());
        }
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        lock.lock();
        try {
            boolean update;
            if (BufferMode.valueOf(this.getProperty(Options.BUFFER_MODE, Options.DEFAULT_BUFFER_MODE)).isFullyBuffered()) {
                if (this.readOnly) {
                    throw new RuntimeException("readOnly not supported for transient journals.");
                }
                this.fileMetadata = null;
                long createTime = Long.parseLong(this.getProperty(Options.CREATE_TIME, "" + System.currentTimeMillis()));
                int offsetBits = this.getProperty(Options.OFFSET_BITS, Integer.toString(this instanceof Journal ? 42 : 38), new IntegerRangeValidator(31, 60));
                BufferMode bufferMode = BufferMode.valueOf(this.getProperty(Options.BUFFER_MODE, Options.DEFAULT_BUFFER_MODE));
                switch (bufferMode) {
                    case Transient: {
                        boolean useDirectBuffers = Boolean.parseBoolean(this.getProperty(Options.USE_DIRECT_BUFFERS, "false"));
                        this._bufferStrategy = new TransientBufferStrategy(offsetBits, this.initialExtent, 0L, useDirectBuffers);
                        break;
                    }
                    case MemStore: {
                        this._bufferStrategy = new MemStrategy(new MemoryManager(DirectBufferPool.INSTANCE, Integer.MAX_VALUE, true, properties));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("bufferMode=" + (Object)((Object)bufferMode)));
                    }
                }
                boolean nextOffset = false;
                long firstCommitTime = 0L;
                long lastCommitTime = 0L;
                long commitCounter = 0L;
                long commitRecordAddr = 0L;
                long commitRecordIndexAddr = 0L;
                UUID uuid = UUID.randomUUID();
                long closedTime = 0L;
                long blockSequence = 0L;
                StoreTypeEnum storeType = bufferMode.getStoreType();
                if (createTime == 0L) {
                    throw new IllegalArgumentException("Create time may not be zero.");
                }
                RootBlockView rootBlock0 = new RootBlockView(true, offsetBits, 0L, 0L, 0L, 0L, 0L, 0L, uuid, 0L, this.quorumToken, 0L, 0L, storeType, createTime, 0L, 3, this.checker);
                RootBlockView rootBlock1 = new RootBlockView(false, offsetBits, 0L, 0L, 0L, 0L, 0L, 0L, uuid, 0L, this.quorumToken, 0L, 0L, storeType, createTime, 0L, 3, this.checker);
                this._bufferStrategy.writeRootBlock(rootBlock0, ForceEnum.No);
                this._bufferStrategy.writeRootBlock(rootBlock1, ForceEnum.No);
                this._rootBlock = rootBlock1;
            } else {
                this.fileMetadata = FileMetadata.createInstance(properties, !(this instanceof Journal), this.quorumToken);
                BufferMode bufferMode = this.fileMetadata.bufferMode;
                switch (bufferMode) {
                    case Direct: {
                        this._bufferStrategy = new DirectBufferStrategy(0L, this.fileMetadata);
                        this._rootBlock = this.fileMetadata.rootBlock;
                        break;
                    }
                    case Mapped: {
                        this._bufferStrategy = new MappedBufferStrategy(this.maximumExtent, this.fileMetadata);
                        this._rootBlock = this.fileMetadata.rootBlock;
                        break;
                    }
                    case Disk: 
                    case DiskWORM: {
                        this._bufferStrategy = new WORMStrategy(0L, this.minimumExtension, this.fileMetadata, quorum);
                        this._rootBlock = this.fileMetadata.rootBlock;
                        break;
                    }
                    case DiskRW: {
                        this._bufferStrategy = new RWStrategy(this.fileMetadata, quorum);
                        this._rootBlock = this.fileMetadata.rootBlock;
                        break;
                    }
                    case TemporaryRW: {
                        this._bufferStrategy = new RWStrategy(this.fileMetadata, quorum);
                        this._rootBlock = this.fileMetadata.rootBlock;
                        break;
                    }
                    case Temporary: {
                        this._bufferStrategy = new DiskOnlyStrategy(0L, this.fileMetadata);
                        this._rootBlock = this.fileMetadata.rootBlock;
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            this.journalMetadata.set(new JournalMetadata(this));
            this._commitRecord = this._getCommitRecord();
            this._commitRecordIndex = this._getCommitRecordIndex();
            if (this._bufferStrategy instanceof IHistoryManager) {
                int checkpointRecordSize = this.getByteCount(this._commitRecordIndex.getCheckpoint().getCheckpointAddr());
                ((IHistoryManager)((Object)this._bufferStrategy)).registerExternalCache(this.historicalIndexCache, checkpointRecordSize);
            }
            this._icuVersionRecord = this._getICUVersionRecord();
            if (this._icuVersionRecord != null && !ICUVersionRecord.newInstance().equals(this._icuVersionRecord) && !(update = Boolean.valueOf(properties.getProperty(Options.UPDATE_ICU_VERSION, "false")).booleanValue())) {
                throw new RuntimeException("ICUVersionChange: store=" + this._icuVersionRecord + ", runtime=" + ICUVersionRecord.newInstance());
            }
            this.setupCommitters();
            ResourceManager.openJournal(this.getFile() == null ? null : this.getFile().toString(), this.size(), this.getBufferStrategy().getBufferMode());
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("OPEN-JOURNAL: uuid=" + this.getUUID() + ", file=" + this.getFile() + ", bufferMode=" + (Object)((Object)this.getBufferStrategy().getBufferMode())));
            }
        }
        finally {
            lock.unlock();
        }
        nopen.incrementAndGet();
    }

    @Override
    public final Properties getProperties() {
        return new Properties(this.properties);
    }

    public IBufferStrategy getBufferStrategy() {
        return this._bufferStrategy;
    }

    @Override
    public abstract ExecutorService getExecutorService();

    @Override
    public synchronized void shutdown() {
        if (!this.isOpen()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this._close();
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutdown complete.");
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (!this.isOpen()) {
            return;
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this._close();
        if (log.isInfoEnabled()) {
            log.info((Object)"Shutdown complete.");
        }
    }

    protected void finalize() throws Throwable {
        if (this._bufferStrategy.isOpen()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Closing journal: " + this.getFile()));
            }
            this.shutdownNow();
        }
    }

    @Override
    public CounterSet getCounters() {
        return CountersFactory.getCounters(this);
    }

    protected final CounterSet getIndexCounters() {
        HashSet<String> foundLive = new HashSet<String>();
        CounterSet tmp = new CounterSet();
        Name2Addr n2a = this._name2Addr;
        if (n2a != null) {
            n2a.getIndexCounters(tmp, foundLive);
        }
        HashMap<String, ICheckpointProtocol> map = new HashMap<String, ICheckpointProtocol>();
        Iterator itr = this.indexCache.entryIterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            NT nt = (NT)e.getKey();
            ICheckpointProtocol newVal = (ICheckpointProtocol)((WeakReference)e.getValue()).get();
            if (newVal == null) continue;
            String name = nt.getName();
            ICheckpointProtocol oldVal = (ICheckpointProtocol)map.get(name);
            if (oldVal != null) {
                long oldTime = oldVal.getLastCommitTime();
                long newTime = newVal.getLastCommitTime();
                if (newTime <= oldTime) continue;
                map.put(name, newVal);
                continue;
            }
            map.put(name, newVal);
        }
        for (Map.Entry e : map.entrySet()) {
            String path = (String)e.getKey();
            CounterSet aCounterSet = ((ICheckpointProtocol)e.getValue()).getCounters();
            tmp.makePath(path).attach(aCounterSet);
        }
        return tmp;
    }

    @Override
    public final File getFile() {
        IBufferStrategy tmp = this.getBufferStrategy();
        if (tmp == null) {
            return null;
        }
        return tmp.getFile();
    }

    protected void assertBefore(UUID serviceId1, UUID serviceId2, long t1, long t2) throws ClocksNotSynchronizedException {
        long maxSkew = this.getMaximumClockSkewMillis();
        ClocksNotSynchronizedException.assertBefore((UUID)serviceId1, (UUID)serviceId2, (long)t1, (long)t2, (long)maxSkew);
    }

    protected long getMaximumClockSkewMillis() {
        throw new UnsupportedOperationException();
    }

    public long getHAPrepareTimeout() {
        throw new UnsupportedOperationException();
    }

    public long getHAReleaseTimeConsensusTimeout() {
        throw new UnsupportedOperationException();
    }

    protected void _close() {
        this.assertOpen();
        this._bufferStrategy.close();
        if (this.quorum != null) {
            this.quorum.terminate();
        }
        ResourceManager.closeJournal(this.getFile() == null ? null : this.getFile().toString());
        if (txLog.isInfoEnabled()) {
            txLog.info((Object)("CLOSE-JOURNAL: uuid=" + this.getUUID() + ", file=" + this.getFile()));
        }
        if (this.deleteOnClose) {
            this.deleteResources();
        }
        nclose.incrementAndGet();
    }

    @Override
    public void deleteResources() {
        IBufferStrategy bufferStrategy;
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        if ((bufferStrategy = this.getBufferStrategy()) != null) {
            bufferStrategy.deleteResources();
        }
        ResourceManager.deleteJournal(this.getFile() == null ? null : this.getFile().toString());
    }

    public void truncate() {
        this.assertOpen();
        if (this.isReadOnly()) {
            throw new IllegalStateException();
        }
        IBufferStrategy backingBuffer = this.getBufferStrategy();
        switch (backingBuffer.getBufferMode()) {
            case DiskRW: {
                return;
            }
        }
        long oldExtent = backingBuffer.getExtent();
        long newExtent = (long)backingBuffer.getHeaderSize() + backingBuffer.getNextOffset();
        backingBuffer.truncate(newExtent);
        if (log.isInfoEnabled()) {
            log.info((Object)("oldExtent=" + oldExtent + ", newExtent=" + newExtent));
        }
    }

    public long ensureMinFree(long minFree) {
        this.assertOpen();
        if (minFree < 0L) {
            throw new IllegalArgumentException();
        }
        IBufferStrategy buf = this._bufferStrategy;
        long remaining = buf.getUserExtent() - buf.getNextOffset();
        if (remaining < minFree) {
            buf.truncate(buf.getExtent() + minFree);
        }
        return buf.getUserExtent() - buf.getNextOffset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeForWrites(long closeTime) {
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        lock.lock();
        try {
            IRootBlockView old;
            long lastCommitTime = this._rootBlock.getLastCommitTime();
            if (log.isInfoEnabled()) {
                log.info((Object)("Closing journal for further writes: closeTime=" + closeTime + ", lastCommitTime=" + lastCommitTime));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("before: " + this._rootBlock));
            }
            if ((old = this._rootBlock).getCommitCounter() == 0L) {
                throw new IllegalStateException("No commits on journal");
            }
            this.truncate();
            long metaStartAddr = this._bufferStrategy.getMetaStartAddr();
            long metaBitsAddr = this._bufferStrategy.getMetaBitsAddr();
            RootBlockView newRootBlock = new RootBlockView(!old.isRootBlock0(), old.getOffsetBits(), old.getNextOffset(), old.getFirstCommitTime(), old.getLastCommitTime(), old.getCommitCounter() + 1L, old.getCommitRecordAddr(), old.getCommitRecordIndexAddr(), old.getUUID(), 0L, this.quorumToken, metaStartAddr, metaBitsAddr, old.getStoreType(), old.getCreateTime(), closeTime, old.getVersion(), this.checker);
            this._bufferStrategy.writeRootBlock(newRootBlock, ForceEnum.Force);
            this._bufferStrategy.closeForWrites();
            this._rootBlock = newRootBlock;
            if (log.isDebugEnabled()) {
                log.debug((Object)("after: " + this._rootBlock));
            }
            this._commitRecord = this._getCommitRecord();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public synchronized void close() {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.shutdownNow();
    }

    @Override
    public synchronized void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        if (this.isOpen()) {
            this.shutdownNow();
        }
        if (!this.deleteOnClose) {
            this.deleteResources();
        }
        ndestroy.incrementAndGet();
    }

    protected void assertOpen() {
        if (this._bufferStrategy != null && !this._bufferStrategy.isOpen()) {
            throw new IllegalStateException(this.getFile() == null ? "transient" : "file=" + this.getFile());
        }
    }

    @Override
    public final UUID getUUID() {
        return this.journalMetadata.get().getUUID();
    }

    @Override
    public final IResourceMetadata getResourceMetadata() {
        return this.journalMetadata.get();
    }

    @Override
    public boolean isOpen() {
        return this._bufferStrategy != null && this._bufferStrategy.isOpen();
    }

    @Override
    public boolean isReadOnly() {
        if (this.readOnly) {
            return true;
        }
        if (this.getRootBlockView().getCloseTime() != 0L) {
            return true;
        }
        long token = this.quorumToken;
        if (token != -1L) {
            switch (this.haStatus) {
                case Leader: {
                    return false;
                }
                case Follower: {
                    return true;
                }
                case NotReady: {
                    return true;
                }
            }
            throw new AssertionError();
        }
        return false;
    }

    protected void assertCanRead() {
        if (this._bufferStrategy == null) {
            throw new IllegalStateException();
        }
        if (!this._bufferStrategy.isOpen()) {
            throw new IllegalStateException();
        }
    }

    protected void assertCanWrite() {
        if (this._bufferStrategy == null) {
            throw new IllegalStateException();
        }
        if (!this._bufferStrategy.isOpen()) {
            throw new IllegalStateException();
        }
        if (this._bufferStrategy.isReadOnly()) {
            throw new IllegalStateException();
        }
        if (this.abortRequired.get()) {
            throw new AbortRequiredException();
        }
    }

    @Override
    public boolean isStable() {
        return this._bufferStrategy.isStable();
    }

    @Override
    public boolean isFullyBuffered() {
        return this._bufferStrategy.isFullyBuffered();
    }

    public boolean isDoubleSync() {
        return this.doubleSync;
    }

    public boolean isChecked() {
        return this._bufferStrategy.useChecksums();
    }

    @Override
    public final IRootBlockView getRootBlockView() {
        if (this._rootBlock == null) {
            throw new IllegalStateException();
        }
        return this._rootBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IRootBlockView getRootBlockViewWithLock() {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            if (this._rootBlock == null) {
                throw new IllegalStateException();
            }
            IRootBlockView iRootBlockView = this._rootBlock;
            return iRootBlockView;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public final long getLastCommitTime() {
        return this._rootBlock.getLastCommitTime();
    }

    @Override
    public final void setCommitter(int rootSlot, ICommitter committer) {
        this.assertOpen();
        this._committers[rootSlot] = committer;
    }

    private final long[] notifyCommitters(long commitTime) {
        assert (commitTime > 0L);
        long[] rootAddrs = new long[this._committers.length];
        for (int i = 0; i < this._committers.length; ++i) {
            long addr;
            ICommitter committer = this._committers[i];
            if (committer == null) continue;
            rootAddrs[i] = addr = committer.handleCommit(commitTime);
        }
        return rootAddrs;
    }

    @Override
    public void abort() {
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        lock.lock();
        try {
            if (this.quorum != null) {
                try {
                    this.quorum.getClient().abort2Phase(this.quorumToken);
                }
                catch (Throwable t) {
                    haLog.error((Object)("2-Phase abort failure.  Will do local abort. cause=" + t), t);
                    this.doLocalAbort();
                }
            } else {
                this.doLocalAbort();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            lock.unlock();
        }
    }

    private void _abort() {
        ReentrantReadWriteLock.WriteLock lock;
        boolean success;
        block11: {
            success = false;
            lock = this._fieldReadWriteLock.writeLock();
            lock.lock();
            if (log.isInfoEnabled()) {
                log.info((Object)"ABORT", (Throwable)new StackInfoReport("ABORT"));
            }
            this.gatherFuture.set(null);
            if (this._bufferStrategy != null) break block11;
            success = true;
            this.abortRequired.set(!success);
            lock.unlock();
            return;
        }
        try {
            txLog.info((Object)"ABORT");
            this.invalidateCommitters();
            this._bufferStrategy.abort();
            this._commitRecord = this._getCommitRecord();
            this._commitRecordIndex = this._getCommitRecordIndex();
            this._icuVersionRecord = this._getICUVersionRecord();
            this._committers = new ICommitter[this._committers.length];
            this.discardCommitters();
            this.setupCommitters();
            if (this.quorum != null) {
                QuorumService<HAGlue> localService = null;
                try {
                    localService = this.quorum.getClient();
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
                if (localService != null) {
                    localService.discardWriteSet();
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)"done");
            }
            this.abortRequired.set(!(success = true));
            lock.unlock();
        }
        catch (Throwable e) {
            try {
                log.error((Object)"ABORT FAILED!", e);
                throw new RuntimeException("ABORT FAILED", e);
            }
            catch (Throwable throwable) {
                this.abortRequired.set(!success);
                lock.unlock();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        lock.lock();
        try {
            this.assertOpen();
            if (this.isReadOnly()) {
                throw new IllegalStateException();
            }
            txLog.warn((Object)"ROLLBACK");
            ByteBuffer buf = this._bufferStrategy.readRootBlock(!this._rootBlock.isRootBlock0());
            RootBlockView newRootBlock = new RootBlockView(this._rootBlock.isRootBlock0(), buf, this.checker);
            this._bufferStrategy.writeRootBlock(newRootBlock, this.forceOnCommit);
            this._rootBlock = newRootBlock;
            this.abort();
            this.historicalIndexCache.clear();
            this.indexCache.clear();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isDirty() {
        return this._bufferStrategy.isDirty();
    }

    private long nextCommitTimestamp() {
        long t;
        IRootBlockView rootBlock = this._rootBlock;
        long lastCommitTime = rootBlock.getLastCommitTime();
        if (lastCommitTime < 0L) {
            throw new RuntimeException("Last commit time is invalid in rootBlock: " + rootBlock);
        }
        ILocalTransactionManager transactionManager = this.getLocalTransactionManager();
        boolean warned = false;
        while (true) {
            if ((t = transactionManager.nextTimestamp()) > lastCommitTime) break;
            long delta = Math.abs(t - lastCommitTime);
            if (delta > this.getMaximumClockSkewMillis()) {
                throw new ClocksNotSynchronizedException("Clocks off by " + delta + " ms: lastCommitTime=" + lastCommitTime + ", but localTimestamp=" + t);
            }
            if (!warned) {
                log.warn((Object)("Clocks off by " + delta + " ms: lastCommitTime=" + lastCommitTime + ", but localTimestamp=" + t));
                warned = true;
            }
            try {
                Thread.sleep(delta);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        long commitTime = t;
        return commitTime;
    }

    @Override
    public long commit() {
        long commitTime2;
        long commitTime = this.nextCommitTimestamp();
        IRootBlockView lastRootBlock = this._rootBlock;
        try {
            commitTime2 = this.commitNow(commitTime);
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getLocalizedMessage() + ": lastRootBlock=" + lastRootBlock, t);
        }
        if (commitTime2 == 0L) {
            return 0L;
        }
        assert (commitTime2 == commitTime);
        this.getLocalTransactionManager().notifyCommit(commitTime);
        return commitTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long commitNow(long commitTime) {
        long beginNanos = System.nanoTime();
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        lock.lock();
        try {
            Lock commitLock;
            this.assertOpen();
            if (log.isInfoEnabled()) {
                log.info((Object)("commitTime=" + commitTime));
            }
            if (this.abortRequired.get()) {
                throw new AbortRequiredException();
            }
            CommitState cs = new CommitState(this, commitTime);
            if (!cs.notifyCommitters()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Nothing to commit");
                }
                long l = 0L;
                return l;
            }
            cs.gatherPhase();
            cs.writeCommitRecord();
            if (this.quorum != null) {
                this.quorum.assertLeader(cs.commitToken);
            }
            if ((commitLock = this._bufferStrategy instanceof IRWStrategy ? ((IRWStrategy)this._bufferStrategy).getCommitLock() : null) != null) {
                commitLock.lock();
            }
            try {
                cs.flushWriteSet();
                cs.newRootBlock();
                if (this.quorum == null || this.quorum.replicationFactor() == 1) {
                    cs.commitSimple();
                } else {
                    cs.commitHA();
                }
            }
            finally {
                if (commitLock != null) {
                    commitLock.unlock();
                }
            }
            long elapsedNanos = System.nanoTime() - cs.beginNanos;
            if (BigdataStatics.debug || log.isInfoEnabled()) {
                String msg = "commit: commitTime=" + cs.commitTime + ", commitCounter=" + cs.newCommitCounter + ", latency=" + TimeUnit.NANOSECONDS.toMillis(elapsedNanos);
                if (BigdataStatics.debug) {
                    System.err.println(msg);
                } else if (log.isInfoEnabled()) {
                    log.info((Object)msg);
                }
            }
            long l = cs.commitTime;
            return l;
        }
        finally {
            lock.unlock();
            this.commitCounters.elapsedTotalCommitNanos.add(System.nanoTime() - beginNanos);
        }
    }

    protected void assertCommitTimeAdvances(long commitTime) {
        if (commitTime <= this._rootBlock.getLastCommitTime()) {
            throw new IllegalArgumentException();
        }
    }

    protected static void assertPriorCommitTimeAdvances(long currentCommitTime, long priorCommitTime) {
        if (currentCommitTime <= priorCommitTime) {
            throw new RuntimeException("Time goes backwards: commitTime=" + currentCommitTime + ", but lastCommitTime=" + priorCommitTime + " on the current root block");
        }
    }

    @Override
    public void force(boolean metadata) {
        this.assertOpen();
        this._bufferStrategy.force(metadata);
    }

    @Override
    public long size() {
        return this._bufferStrategy.size();
    }

    @Override
    public ByteBuffer read(long addr) {
        this.assertOpen();
        this.assertCanRead();
        return this._bufferStrategy.read(addr);
    }

    @Override
    public long write(ByteBuffer data) {
        this.assertCanWrite();
        return this._bufferStrategy.write(data);
    }

    @Override
    public long write(ByteBuffer data, IAllocationContext context) {
        this.assertCanWrite();
        if (this._bufferStrategy instanceof IRWStrategy) {
            return ((IRWStrategy)this._bufferStrategy).write(data, context);
        }
        return this._bufferStrategy.write(data);
    }

    @Override
    public IPSOutputStream getOutputStream() {
        this.assertCanWrite();
        return this._bufferStrategy.getOutputStream();
    }

    @Override
    public IPSOutputStream getOutputStream(IAllocationContext context) {
        this.assertCanWrite();
        if (this._bufferStrategy instanceof IRWStrategy) {
            return ((IRWStrategy)this._bufferStrategy).getOutputStream(context);
        }
        return this._bufferStrategy.getOutputStream();
    }

    @Override
    public InputStream getInputStream(long addr) {
        return this._bufferStrategy.getInputStream(addr);
    }

    @Override
    public void delete(long addr) {
        this.assertCanWrite();
        this._bufferStrategy.delete(addr);
    }

    @Override
    public void delete(long addr, IAllocationContext context) {
        this.assertCanWrite();
        if (this._bufferStrategy instanceof IRWStrategy) {
            ((IRWStrategy)this._bufferStrategy).delete(addr, context);
        } else {
            this._bufferStrategy.delete(addr);
        }
    }

    @Override
    public void detachContext(IAllocationContext context) {
        this.assertCanWrite();
        if (this._bufferStrategy instanceof IRWStrategy) {
            ((IRWStrategy)this._bufferStrategy).detachContext(context);
        }
    }

    @Override
    public void abortContext(IAllocationContext context) {
        this.assertCanWrite();
        if (this._bufferStrategy instanceof IRWStrategy) {
            ((IRWStrategy)this._bufferStrategy).abortContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getRootAddr(int index) {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            ICommitRecord commitRecord = this._commitRecord;
            if (commitRecord == null) {
                throw new AssertionError();
            }
            long l = commitRecord.getRootAddr(index);
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICommitRecord getEarliestVisibleCommitRecordForHA(long releaseTime) {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            long commitCounter = this._rootBlock.getCommitCounter();
            long lastCommitTime = this._rootBlock.getLastCommitTime();
            if (commitCounter == 0L) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"No commit points");
                }
                ICommitRecord iCommitRecord = null;
                return iCommitRecord;
            }
            if (releaseTime >= lastCommitTime) {
                throw new IllegalArgumentException("releaseTime(" + releaseTime + ") >= lastCommitTime(" + lastCommitTime + ")");
            }
            CommitRecordIndex commitRecordIndex = this._commitRecordIndex;
            if (commitRecordIndex == null) {
                throw new AssertionError();
            }
            long effectiveTimestamp = releaseTime == 0L ? 1L : releaseTime;
            ICommitRecord commitRecord = commitRecordIndex.findNext(effectiveTimestamp);
            if (commitRecord == null) {
                throw new AssertionError((Object)("commitCounter=" + commitCounter + " but no commitRecord for releaseTime=" + releaseTime + ", effectiveTimestamp=" + effectiveTimestamp + " :: " + commitRecordIndex));
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("releaseTime=" + releaseTime + ",commitRecord=" + commitRecord));
            }
            ICommitRecord iCommitRecord = commitRecord;
            return iCommitRecord;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommitRecord getCommitRecord() {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            ICommitRecord commitRecord = this._commitRecord;
            if (commitRecord == null) {
                throw new AssertionError();
            }
            ICommitRecord iCommitRecord = commitRecord;
            return iCommitRecord;
        }
        finally {
            lock.unlock();
        }
    }

    private ICommitRecord _getCommitRecord() {
        assert (this._fieldReadWriteLock.writeLock().isHeldByCurrentThread());
        long commitRecordAddr = this._rootBlock.getCommitRecordAddr();
        if (log.isInfoEnabled()) {
            log.info((Object)("Reading commit record from: " + commitRecordAddr));
        }
        if (commitRecordAddr == 0L) {
            return new CommitRecord();
        }
        return CommitRecordSerializer.INSTANCE.deserialize(this._bufferStrategy.read(commitRecordAddr));
    }

    protected void invalidateCommitters() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("invalidating commiters for: " + this + ", lastCommitTime: " + this.getLastCommitTime()));
        }
        assert (this._fieldReadWriteLock.writeLock().isHeldByCurrentThread());
        StackInfoReport t = new StackInfoReport("ABORT journal " + this + ", lastCommitTime: " + this.getLastCommitTime());
        for (ICommitter committer : this._committers) {
            if (committer == null) continue;
            committer.invalidate((Throwable)t);
        }
        this.getResourceLocator().clearUnisolatedCache();
    }

    protected void discardCommitters() {
        assert (this._fieldReadWriteLock.writeLock().isHeldByCurrentThread());
        this._name2Addr = null;
    }

    protected void setupCommitters() {
        assert (this._fieldReadWriteLock.writeLock().isHeldByCurrentThread());
        if (!this.isReadOnly()) {
            this.setupName2AddrBTree(this.getRootAddr(0));
            this.m_rootBlockCommitter = new RootBlockCommitter(this);
            if (this._bufferStrategy instanceof IRWStrategy) {
                this.setCommitter(2, new DeleteBlockCommitter((IRWStrategy)this._bufferStrategy));
            }
            this.setCommitter(3, new ICUVersionCommitter());
        }
    }

    private ICUVersionRecord _getICUVersionRecord() {
        assert (this._fieldReadWriteLock.writeLock().isHeldByCurrentThread());
        long addr = this.getRootAddr(3);
        ICUVersionRecord r = addr == 0L ? ICUVersionRecord.newInstance() : (ICUVersionRecord)SerializerUtil.deserialize(this.read(addr));
        return r;
    }

    Name2Addr setupName2AddrBTree(long addr) {
        assert (this._fieldReadWriteLock.writeLock().isHeldByCurrentThread());
        assert (this._name2Addr == null);
        if (addr == 0L) {
            if (log.isInfoEnabled()) {
                log.info((Object)("New " + Name2Addr.class.getName()));
            }
            this._name2Addr = Name2Addr.create(this.isReadOnly() ? new SimpleMemoryRawStore() : this);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading " + Name2Addr.class.getName() + " from " + addr));
            }
            this._name2Addr = (Name2Addr)BTree.load(this, addr, false);
        }
        this._name2Addr.setupCache(this.liveIndexCacheCapacity, this.liveIndexCacheTimeout);
        this.setCommitter(0, this._name2Addr);
        return this._name2Addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommitRecordIndex getReadOnlyCommitRecordIndex() {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            CommitRecordIndex commitRecordIndex;
            this.assertOpen();
            CommitRecordIndex commitRecordIndex2 = commitRecordIndex = this.getCommitRecordIndex(this._rootBlock.getCommitRecordIndexAddr(), true);
            return commitRecordIndex2;
        }
        finally {
            lock.unlock();
        }
    }

    private CommitRecordIndex _getCommitRecordIndex() {
        assert (this._fieldReadWriteLock.writeLock().isHeldByCurrentThread());
        assert (this._rootBlock != null);
        long addr = this._rootBlock.getCommitRecordIndexAddr();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loading from addr=" + addr));
            }
            return this.getCommitRecordIndex(addr, false);
        }
        catch (RuntimeException ex) {
            log.fatal((Object)("Could not read the commit record index:\n" + this._rootBlock), (Throwable)ex);
            throw ex;
        }
    }

    protected CommitRecordIndex getCommitRecordIndex(long addr, boolean readOnly) {
        if (log.isInfoEnabled()) {
            log.info((Object)("addr=" + this.toString(addr)));
        }
        CommitRecordIndex ndx = addr == 0L ? (this.isReadOnly() || readOnly ? CommitRecordIndex.createTransient() : CommitRecordIndex.create(this)) : (readOnly ? (CommitRecordIndex)this.getIndexWithCheckpointAddr(addr) : (CommitRecordIndex)BTree.load(this, addr, false));
        assert (ndx != null);
        return ndx;
    }

    private boolean isHistoryGone(long commitTime) {
        long lastReleaseTime;
        if (this._bufferStrategy instanceof IHistoryManager && commitTime <= (lastReleaseTime = ((IHistoryManager)((Object)this._bufferStrategy)).getLastReleaseTime())) {
            if (log.isDebugEnabled()) {
                log.info((Object)("History gone: commitTime=" + commitTime));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommitRecord getCommitRecord(long commitTime) {
        if (this.isHistoryGone(commitTime)) {
            return null;
        }
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            CommitRecordIndex commitRecordIndex = this._commitRecordIndex;
            if (commitRecordIndex == null) {
                throw new AssertionError();
            }
            ICommitRecord iCommitRecord = commitRecordIndex.find(commitTime);
            return iCommitRecord;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommitRecord getCommitRecordStrictlyGreaterThan(long commitTime) {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            CommitRecordIndex commitRecordIndex = this._commitRecordIndex;
            if (commitRecordIndex == null) {
                throw new AssertionError();
            }
            ICommitRecord iCommitRecord = commitRecordIndex.findNext(commitTime);
            return iCommitRecord;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public IIndex getIndex(String name, long commitTime) {
        return (BTree)this.getIndexLocal(name, commitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICheckpointProtocol getIndexLocal(String name, long commitTime) {
        if (commitTime == 0L || commitTime == -1L || TimestampUtility.isReadWriteTx(commitTime)) {
            throw new UnsupportedOperationException("name=" + name + ",commitTime=" + TimestampUtility.toString(commitTime));
        }
        ICheckpointProtocol ndx = null;
        NT nt = new NT(name, commitTime);
        ndx = (ICheckpointProtocol)this.indexCache.get((Object)nt);
        if (ndx != null) {
            if (this.isHistoryGone(commitTime)) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Removing entry from cache: " + name));
                }
                this.indexCache.remove((Object)nt);
                return null;
            }
            return ndx;
        }
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            ICommitRecord commitRecord = this.getCommitRecord(commitTime);
            if (commitRecord == null) {
                log.warn((Object)("No commit record: name=" + name + ", timestamp=" + commitTime));
                ICheckpointProtocol iCheckpointProtocol = null;
                return iCheckpointProtocol;
            }
            ndx = this.getIndexWithCommitRecord(name, commitRecord);
            if (ndx == null) {
                ICheckpointProtocol iCheckpointProtocol = null;
                return iCheckpointProtocol;
            }
            ICheckpointProtocol ndx2 = (ICheckpointProtocol)this.indexCache.putIfAbsent((Object)nt, (Object)ndx);
            if (ndx2 != null) {
                ndx = ndx2;
            }
            ICheckpointProtocol iCheckpointProtocol = ndx;
            return iCheckpointProtocol;
        }
        finally {
            lock.unlock();
        }
    }

    protected int getIndexCacheSize() {
        return this.indexCache.size();
    }

    protected int getHistoricalIndexCacheSize() {
        return this.historicalIndexCache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ICheckpointProtocol getIndexWithCommitRecord(String name, ICommitRecord commitRecord) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (commitRecord == null) {
            throw new IllegalArgumentException();
        }
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            long checkpointAddr = commitRecord.getRootAddr(0);
            if (checkpointAddr == 0L) {
                log.warn((Object)("No name2addr entry in this commit record: " + commitRecord));
                ICheckpointProtocol iCheckpointProtocol = null;
                return iCheckpointProtocol;
            }
            Name2Addr name2Addr = (Name2Addr)this.getIndexWithCheckpointAddr(checkpointAddr);
            Name2Addr.Entry entry = name2Addr.getEntry(name);
            if (entry == null) {
                ICheckpointProtocol iCheckpointProtocol = null;
                return iCheckpointProtocol;
            }
            ICheckpointProtocol index = this.getIndexWithCheckpointAddr(entry.checkpointAddr);
            assert (entry.commitTime != 0L) : "Entry=" + entry;
            index.setLastCommitTime(entry.commitTime);
            ICheckpointProtocol iCheckpointProtocol = index;
            return iCheckpointProtocol;
        }
        finally {
            lock.unlock();
        }
    }

    public final ICheckpointProtocol getIndexWithCheckpointAddr(long checkpointAddr) {
        ICommitter oldval;
        long offset = this.getPhysicalAddress(checkpointAddr);
        ICommitter ndx = (ICommitter)this.historicalIndexCache.get((Object)offset);
        if (ndx == null) {
            ndx = Checkpoint.loadFromCheckpoint(this, checkpointAddr, true);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Adding checkpoint to historical index at " + checkpointAddr));
            }
        } else if (log.isTraceEnabled()) {
            log.trace((Object)("Found historical index at " + checkpointAddr + ", historicalIndexCache.size(): " + this.historicalIndexCache.size()));
        }
        if ((oldval = (ICommitter)this.historicalIndexCache.putIfAbsent((Object)offset, (Object)ndx)) != null) {
            ndx = oldval;
        }
        return (ICheckpointProtocol)ndx;
    }

    @Override
    public final void registerIndex(IndexMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException();
        }
        String name = metadata.getName();
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.validateIndexMetadata(name, metadata);
        ICheckpointProtocol ndx = Checkpoint.create(this, metadata);
        this._register(name, ndx);
    }

    protected void validateIndexMetadata(String name, IndexMetadata metadata) {
    }

    @Override
    public final BTree registerIndex(String name, IndexMetadata metadata) {
        this.validateIndexMetadata(name, metadata);
        BTree btree = BTree.create(this, metadata);
        return this.registerIndex(name, btree);
    }

    @Override
    public ICheckpointProtocol register(String name, IndexMetadata metadata) {
        ICheckpointProtocol ndx = Checkpoint.create(this, metadata);
        this._register(name, ndx);
        return ndx;
    }

    @Override
    public final BTree registerIndex(String name, BTree ndx) {
        this._register(name, ndx);
        return ndx;
    }

    public final void registerIndex(String name, HTree ndx) {
        this._register(name, ndx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _register(String name, ICheckpointProtocol ndx) {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            Name2Addr name2Addr = this._name2Addr;
            synchronized (name2Addr) {
                this._name2Addr.registerIndex(name, ndx);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropIndex(String name) {
        ICheckpointProtocol ndx = this.getUnisolatedIndex(name);
        if (ndx == null) {
            throw new NoSuchIndexException(name);
        }
        if (this.getBufferStrategy() instanceof IRWStrategy) {
            ndx.removeAll();
        }
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            Name2Addr name2Addr = this._name2Addr;
            synchronized (name2Addr) {
                this._name2Addr.dropIndex(name);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> indexNameScan(String prefix, long timestamp) {
        IIndex n2a;
        if (timestamp == 0L) {
            ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
            lock.lock();
            try {
                LinkedList<String> names = new LinkedList<String>();
                Object object = this._name2Addr;
                synchronized (object) {
                    Iterator<String> itr = Name2Addr.indexNameScan(prefix, this._name2Addr);
                    while (itr.hasNext()) {
                        names.add(itr.next());
                    }
                }
                object = names.iterator();
                return object;
            }
            finally {
                lock.unlock();
            }
        }
        if (timestamp == -1L) {
            n2a = this.getName2Addr();
        } else if (TimestampUtility.isReadWriteTx(timestamp)) {
            ITx tx = this.getLocalTransactionManager().getTx(timestamp);
            if (tx == null) {
                throw new TransactionNotFoundException(timestamp);
            }
            long readsOnCommitTime = tx.getReadsOnCommitTime();
            n2a = this.getName2Addr(readsOnCommitTime);
        } else {
            n2a = this.getName2Addr(timestamp);
        }
        return Name2Addr.indexNameScan(prefix, n2a);
    }

    @Override
    public final BTree getIndex(String name) {
        return (BTree)this.getUnisolatedIndex(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICheckpointProtocol getUnisolatedIndex(String name) {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            this.assertOpen();
            if (name == null) {
                throw new IllegalArgumentException();
            }
            if (Thread.interrupted()) {
                throw new RuntimeException(new InterruptedException());
            }
            Name2Addr name2Addr = this._name2Addr;
            synchronized (name2Addr) {
                ICheckpointProtocol iCheckpointProtocol = this._name2Addr.getIndex(name);
                return iCheckpointProtocol;
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public final long getOffset(long addr) {
        return this._bufferStrategy.getOffset(addr);
    }

    @Override
    public final long getPhysicalAddress(long addr) {
        return this._bufferStrategy.getAddressManager().getPhysicalAddress(addr);
    }

    @Override
    public final int getByteCount(long addr) {
        return this._bufferStrategy.getByteCount(addr);
    }

    @Override
    public final long toAddr(int nbytes, long offset) {
        return this._bufferStrategy.toAddr(nbytes, offset);
    }

    @Override
    public final String toString(long addr) {
        return this._bufferStrategy.toString(addr);
    }

    public final int getOffsetBits() {
        return this._bufferStrategy.getOffsetBits();
    }

    public final int getMaxRecordSize() {
        return this._bufferStrategy.getMaxRecordSize();
    }

    protected long getQuorumToken() {
        return this.quorumToken;
    }

    protected void clearQuorumToken(long newValue) {
        boolean isServiceJoined = false;
        this.setQuorumToken2(newValue, false);
    }

    protected void setQuorumToken(long newValue) {
        if (this.quorum == null) {
            return;
        }
        QuorumService<HAGlue> localService = this.quorum.getClient();
        boolean isServiceJoined = localService != null && localService.isJoinedMember(newValue);
        this.setQuorumToken2(newValue, isServiceJoined);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setQuorumToken2(long newValue, boolean isServiceJoined) {
        block25: {
            QuorumService<HAGlue> t;
            if (haLog.isInfoEnabled()) {
                log.info((Object)("current: " + this.quorumToken + ", new: " + newValue + ", joined=" + isServiceJoined));
            }
            if (this.quorum == null) {
                return;
            }
            try {
                t = this.quorum.getClient();
            }
            catch (IllegalStateException ex) {
                t = null;
            }
            QuorumService<HAGlue> localService = t;
            QuorumTokenTransitions transitionState = new QuorumTokenTransitions(this.quorumToken, newValue, isServiceJoined, this.haReadyToken);
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)transitionState.toString());
            }
            if (transitionState.didBreak) {
                this.quorumToken = -1L;
            }
            ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
            lock.lock();
            try {
                if (transitionState.didLeaveMetQuorum) {
                    this.quorumToken = newValue;
                    ((AbstractTransactionService)this.getLocalTransactionManager().getTransactionService()).abortAllTx();
                    this.doLocalAbort();
                    this.haReadyToken = -1L;
                    this.haStatus = HAStatusEnum.NotReady;
                    this.haReadyCondition.signalAll();
                    break block25;
                }
                if (transitionState.didBreak) {
                    this.quorumToken = -1L;
                    this.haReadyToken = -1L;
                    this.haStatus = HAStatusEnum.NotReady;
                    this.haReadyCondition.signalAll();
                    break block25;
                }
                if (transitionState.didMeet || transitionState.didJoinMetQuorum) {
                    long tmp;
                    boolean isFollower;
                    boolean isLeader;
                    this.quorumToken = newValue;
                    boolean installedRBs = false;
                    long localCommitCounter = this._rootBlock.getCommitCounter();
                    if (localService.isFollower(newValue)) {
                        isLeader = false;
                        isFollower = true;
                        if (localCommitCounter == 0L) {
                            IRootBlockView leaderRB;
                            HAGlue leader = (HAGlue)localService.getLeader(newValue);
                            haLog.info((Object)"Fetching root block from leader.");
                            try {
                                leaderRB = leader.getRootBlock(new HARootBlockRequest(null)).getRootBlock();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            if (leaderRB.getCommitCounter() == 0L) {
                                localService.installRootBlocks(leaderRB.asRootBlock(true), leaderRB.asRootBlock(false));
                                installedRBs = true;
                            }
                        }
                        tmp = newValue;
                    } else if (localService.isLeader(newValue)) {
                        isLeader = true;
                        isFollower = false;
                        tmp = newValue;
                    } else {
                        isLeader = false;
                        isFollower = false;
                        tmp = -1L;
                    }
                    this.haReadyToken = tmp;
                    HAStatusEnum hAStatusEnum = isLeader ? HAStatusEnum.Leader : (this.haStatus = isFollower ? HAStatusEnum.Follower : HAStatusEnum.NotReady);
                    if (!installedRBs) {
                        if (haLog.isInfoEnabled()) {
                            haLog.info((Object)("Calling localAbort if NOT didJoinMetQuorum: " + transitionState.didJoinMetQuorum));
                        }
                        if (!transitionState.didJoinMetQuorum) {
                            this.doLocalAbort();
                        }
                    }
                    this.haReadyCondition.signalAll();
                    break block25;
                }
                if (this.haReadyToken != -1L) {
                    throw new AssertionError((Object)"VOID setToken");
                }
            }
            finally {
                lock.unlock();
            }
        }
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("done: token=" + this.quorumToken + ", HAReady=" + this.haReadyToken + ", HAStatus=" + (Object)((Object)this.haStatus)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long awaitHAReady(long timeout, TimeUnit units) throws InterruptedException, TimeoutException, AsynchronousQuorumCloseException {
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        long begin = System.nanoTime();
        long nanos = units.toNanos(timeout);
        long remaining = nanos;
        if (!lock.tryLock(remaining, TimeUnit.NANOSECONDS)) {
            throw new TimeoutException();
        }
        try {
            remaining = nanos - (System.nanoTime() - begin);
            long t = -1L;
            while ((t = this.haReadyToken) == -1L && this.getQuorum().getClient() != null && remaining > 0L) {
                if (!this.haReadyCondition.await(remaining, TimeUnit.NANOSECONDS)) {
                    throw new TimeoutException();
                }
                remaining = nanos - (System.nanoTime() - begin);
            }
            QuorumService<HAGlue> client = this.getQuorum().getClient();
            if (client == null) {
                throw new AsynchronousQuorumCloseException();
            }
            if (remaining <= 0L) {
                throw new TimeoutException();
            }
            if (!client.isJoinedMember(t)) {
                throw new QuorumException();
            }
            long l = t;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    public final long getHAReady() {
        return this.haReadyToken;
    }

    public final HAStatusEnum getHAStatus() {
        if (this.quorum == null) {
            return null;
        }
        return this.haStatus;
    }

    public final void assertHAReady(long token) throws QuorumException {
        if (this.quorum == null) {
            return;
        }
        if (token != this.haReadyToken) {
            throw new QuorumException(HAStatusEnum.NotReady.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installRootBlocks(IRootBlockView rootBlock0, IRootBlockView rootBlock1) {
        if (rootBlock0 == null) {
            throw new IllegalArgumentException();
        }
        if (rootBlock1 == null) {
            throw new IllegalArgumentException();
        }
        if (!rootBlock0.isRootBlock0()) {
            throw new IllegalArgumentException();
        }
        if (rootBlock1.isRootBlock0()) {
            throw new IllegalArgumentException();
        }
        if (!rootBlock0.getStoreType().equals((Object)rootBlock1.getStoreType())) {
            throw new IllegalArgumentException();
        }
        if (!rootBlock0.getUUID().equals(rootBlock1.getUUID())) {
            throw new IllegalArgumentException();
        }
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        lock.lock();
        try {
            if (!this._rootBlock.getStoreType().equals((Object)rootBlock0.getStoreType())) {
                throw new RuntimeException("Incompatible StoreType: expected=" + (Object)((Object)this._rootBlock.getStoreType()) + ", actual=" + (Object)((Object)rootBlock0.getStoreType()));
            }
            this._bufferStrategy.writeRootBlock(rootBlock0, ForceEnum.Force);
            this._bufferStrategy.writeRootBlock(rootBlock1, ForceEnum.Force);
            this._rootBlock = RootBlockUtility.chooseRootBlock(rootBlock0, rootBlock1);
            this.journalMetadata.set(new JournalMetadata(this));
            haLog.warn((Object)("Installed new root blocks: rootBlock0=" + rootBlock0 + ", rootBlock1=" + rootBlock1));
            if (this._bufferStrategy instanceof IHABufferStrategy) {
                ((IHABufferStrategy)this._bufferStrategy).resetFromHARootBlock(this._rootBlock);
            }
            this.doLocalAbort();
        }
        finally {
            lock.unlock();
        }
    }

    public final void doLocalAbort() {
        this._abort();
    }

    public final void doLocalCommit(IRootBlockView rootBlock) {
        this.doLocalCommit(null, rootBlock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLocalCommit(QuorumService<HAGlue> localService, IRootBlockView rootBlock) {
        ReentrantReadWriteLock.WriteLock lock = this._fieldReadWriteLock.writeLock();
        lock.lock();
        try {
            boolean leader;
            boolean shouldFlush;
            boolean bl = shouldFlush = localService == null || this.haStatus == null || this.haStatus == HAStatusEnum.NotReady;
            if (!shouldFlush) {
                // empty if block
            }
            if (this.doubleSync) {
                this._bufferStrategy.force(false);
            }
            long commitTime = rootBlock.getLastCommitTime();
            this._bufferStrategy.writeRootBlock(rootBlock, this.forceOnCommit);
            this._rootBlock = rootBlock;
            boolean bl2 = leader = localService == null ? false : localService.isLeader(rootBlock.getQuorumToken());
            if (leader) {
                if (this._bufferStrategy instanceof IRWStrategy) {
                    ((IRWStrategy)this._bufferStrategy).postCommit();
                }
            } else {
                if (haLog.isInfoEnabled() && localService != null) {
                    haLog.info((Object)("PostHACommit: serviceUUID=" + localService.getServiceId()));
                }
                ((IHABufferStrategy)this._bufferStrategy).postHACommit(rootBlock);
                this._commitRecordIndex = this._getCommitRecordIndex();
            }
            this._commitRecord = this._getCommitRecord();
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("COMMIT: commitCounter=" + rootBlock.getCommitCounter() + ", commitTime=" + commitTime));
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Quorum<HAGlue, QuorumService<HAGlue>> getQuorum() {
        return this.quorum;
    }

    protected HAGlue newHAGlue(UUID serviceId) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRootBlockView[] getRootBlocks() {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            ChecksumUtility checker = ChecksumUtility.getCHK();
            RootBlockView rb0 = new RootBlockView(true, this.getBufferStrategy().readRootBlock(true), checker);
            RootBlockView rb1 = new RootBlockView(false, this.getBufferStrategy().readRootBlock(false), checker);
            IRootBlockView[] iRootBlockViewArray = new IRootBlockView[]{rb0, rb1};
            return iRootBlockViewArray;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISnapshotData snapshotAllocationData(AtomicReference<IRootBlockView> rbv) throws IOException {
        ReentrantReadWriteLock.ReadLock lock = this._fieldReadWriteLock.readLock();
        lock.lock();
        try {
            SnapshotData tm = new SnapshotData();
            IBufferStrategy bs = this.getBufferStrategy();
            ByteBuffer rb0 = bs.readRootBlock(true);
            tm.put(8L, BytesUtil.toArray((ByteBuffer)rb0));
            ByteBuffer rb1 = bs.readRootBlock(false);
            tm.put(348L, BytesUtil.toArray((ByteBuffer)rb1));
            RootBlockView rbv0 = new RootBlockView(true, rb0, this.checker);
            RootBlockView rbv1 = new RootBlockView(false, rb1, this.checker);
            rbv.set(RootBlockUtility.chooseRootBlock(rbv0, rbv1));
            if (bs instanceof RWStrategy) {
                RWStore rws = ((RWStrategy)bs).getStore();
                rws.snapshotMetabits(tm);
                rws.snapshotAllocators(tm);
            }
            SnapshotData snapshotData = tm;
            return snapshotData;
        }
        finally {
            lock.unlock();
        }
    }

    public int removeCommitRecordEntries(byte[] fromKey, byte[] toKey) {
        CommitRecordIndex cri = this._commitRecordIndex;
        ITupleIterator commitRecords = cri.rangeIterator(fromKey, toKey, 0, 35, (IFilter)null);
        int removed = 0;
        while (commitRecords.hasNext()) {
            ITuple t = commitRecords.next();
            this.delete(((CommitRecordIndex.Entry)t.getObject()).addr);
            commitRecords.remove();
            ++removed;
        }
        return removed;
    }

    @Override
    public IAllocationContext newAllocationContext(boolean isolated) {
        if (this._bufferStrategy instanceof RWStrategy) {
            return ((RWStrategy)this._bufferStrategy).newAllocationContext(isolated);
        }
        return null;
    }

    public static class SnapshotData
    implements ISnapshotData {
        final TreeMap<Long, byte[]> m_map = new TreeMap();

        @Override
        public void put(long addr, byte[] data) {
            this.m_map.put(addr, data);
        }

        @Override
        public Iterator<ISnapshotEntry> entries() {
            final Iterator<Map.Entry<Long, byte[]>> entries = this.m_map.entrySet().iterator();
            return new Iterator<ISnapshotEntry>(){

                @Override
                public boolean hasNext() {
                    return entries.hasNext();
                }

                @Override
                public ISnapshotEntry next() {
                    final Map.Entry entry = (Map.Entry)entries.next();
                    return new ISnapshotEntry(){

                        @Override
                        public long getAddress() {
                            return (Long)entry.getKey();
                        }

                        @Override
                        public byte[] getData() {
                            return (byte[])entry.getValue();
                        }
                    };
                }

                @Override
                public void remove() {
                    entries.remove();
                }
            };
        }
    }

    public static interface ISnapshotData {
        public void put(long var1, byte[] var3);

        public Iterator<ISnapshotEntry> entries();
    }

    public static interface ISnapshotEntry {
        public long getAddress();

        public byte[] getData();
    }

    protected class BasicHA
    implements HAGlue {
        private final UUID serviceId;
        private final InetSocketAddress writePipelineAddr;
        private final AtomicReference<IHA2PhasePrepareMessage> prepareRequest = new AtomicReference();
        private final AtomicBoolean vote = new AtomicBoolean(false);

        protected BasicHA(UUID serviceId, InetSocketAddress writePipelineAddr) {
            if (serviceId == null) {
                throw new IllegalArgumentException();
            }
            if (writePipelineAddr == null) {
                throw new IllegalArgumentException();
            }
            this.serviceId = serviceId;
            this.writePipelineAddr = writePipelineAddr;
        }

        public AbstractJournal getIndexManager() {
            return AbstractJournal.this;
        }

        @Override
        public UUID getServiceId() {
            return this.serviceId;
        }

        @Override
        public InetSocketAddress getWritePipelineAddr() {
            return this.writePipelineAddr;
        }

        @Override
        public int getNSSPort() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RunState getRunState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExtendedRunState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HAStatusEnum getHAStatus() {
            return AbstractJournal.this.getHAStatus();
        }

        @Override
        public long awaitHAReady(long timeout, TimeUnit units) throws AsynchronousQuorumCloseException, InterruptedException, TimeoutException {
            return AbstractJournal.this.awaitHAReady(timeout, units);
        }

        @Override
        public IHANotifyReleaseTimeResponse awaitServiceJoin(IHAAwaitServiceJoinRequest req) throws AsynchronousQuorumCloseException, InterruptedException, TimeoutException {
            AbstractJournal.this._gatherLock.lock();
            try {
                long nanos;
                UUID serviceUUID = req.getServiceUUID();
                long begin = System.nanoTime();
                long remaining = nanos = req.getUnit().toNanos(req.getTimeout());
                while ((remaining = nanos - (System.nanoTime() - begin)) > 0L) {
                    UUID[] joined;
                    for (UUID t : joined = AbstractJournal.this.getQuorum().getJoined()) {
                        if (!serviceUUID.equals(t)) continue;
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Found Joined Service: " + serviceUUID));
                        }
                        JournalTransactionService ts = (JournalTransactionService)AbstractJournal.this.getLocalTransactionManager().getTransactionService();
                        HANotifyReleaseTimeResponse hANotifyReleaseTimeResponse = new HANotifyReleaseTimeResponse(ts.getReleaseTime(), -1L);
                        return hANotifyReleaseTimeResponse;
                    }
                    remaining = nanos - (System.nanoTime() - begin);
                    if (remaining <= 0L) continue;
                    long sleepMillis = Math.min(TimeUnit.NANOSECONDS.toMillis(remaining), 10L);
                    if (sleepMillis <= 0L) {
                        throw new TimeoutException();
                    }
                    Thread.sleep(sleepMillis);
                }
                throw new TimeoutException();
            }
            finally {
                AbstractJournal.this._gatherLock.unlock();
            }
        }

        @Override
        public IHADigestResponse computeDigest(IHADigestRequest req) throws IOException, NoSuchAlgorithmException, DigestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public IHALogDigestResponse computeHALogDigest(IHALogDigestRequest req) throws IOException, NoSuchAlgorithmException, DigestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public IHASnapshotDigestResponse computeHASnapshotDigest(IHASnapshotDigestRequest req) throws IOException, NoSuchAlgorithmException, DigestException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<IHASnapshotResponse> takeSnapshot(IHASnapshotRequest req) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<Void> rebuildFromLeader(IHARemoteRebuildRequest req) throws IOException {
            throw new UnsupportedOperationException();
        }

        protected final <E> Future<E> getProxy(Future<E> future) {
            return this.getProxy(future, false);
        }

        protected <E> Future<E> getProxy(Future<E> future, boolean asyncFuture) {
            return future;
        }

        @Override
        public Future<Boolean> prepare2Phase(IHA2PhasePrepareMessage prepareMessage) {
            if (prepareMessage == null) {
                throw new IllegalArgumentException();
            }
            boolean isRootBlock0 = prepareMessage.isRootBlock0();
            long timeout = prepareMessage.getTimeout();
            TimeUnit unit = prepareMessage.getUnit();
            IRootBlockView rootBlock = prepareMessage.getRootBlock();
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("isJoinedService=" + prepareMessage.isJoinedService() + ", isRootBlock0=" + isRootBlock0 + ", rootBlock=" + rootBlock + ", timeout=" + timeout + ", unit=" + (Object)((Object)unit)));
            }
            long prepareToken = rootBlock.getQuorumToken();
            AbstractJournal.this.quorum.assertQuorum(prepareToken);
            AbstractJournal.this.assertHAReady(prepareToken);
            this.prepareRequest.set(prepareMessage);
            this.vote.set(false);
            QuorumService quorumService = (QuorumService)AbstractJournal.this.quorum.getClient();
            boolean isJoined = prepareMessage.isJoinedService();
            boolean isLeader = quorumService.isLeader(prepareToken);
            FutureTaskMon<Boolean> ft = !isJoined ? new FutureTaskMon<Boolean>(new VoteNoTask(quorumService)) : new FutureTaskMon<Boolean>(new Prepare2PhaseTask(isLeader, prepareMessage));
            if (isLeader) {
                ((FutureTask)ft).run();
            } else {
                AbstractJournal.this.getExecutorService().execute(ft);
            }
            return this.getProxy(ft);
        }

        protected void validateNewRootBlock(boolean isLeader, IRootBlockView oldRB, IRootBlockView newRB) {
            long tmp;
            HAStatusEnum st;
            long oldcc;
            if (oldRB == null) {
                throw new IllegalStateException();
            }
            if (newRB == null) {
                throw new IllegalStateException();
            }
            if (!newRB.getUUID().equals(oldRB.getUUID())) {
                throw new IllegalStateException("Store UUID: old=" + oldRB.getUUID() + " != new=" + newRB.getUUID());
            }
            if (newRB.getLastCommitTime() <= oldRB.getLastCommitTime()) {
                throw new IllegalStateException("lastCommitTime: old=" + oldRB.getLastCommitTime() + " > new=" + newRB.getLastCommitTime());
            }
            long newcc = newRB.getCommitCounter();
            if (newcc != (oldcc = oldRB.getCommitCounter()) + 1L) {
                throw new IllegalStateException("commitCounter: ( old=" + oldcc + " + 1 ) != new=" + newcc);
            }
            long prepareToken = newRB.getQuorumToken();
            AbstractJournal.this.quorum.assertQuorum(prepareToken);
            AbstractJournal.this.assertHAReady(prepareToken);
            QuorumService localService = (QuorumService)AbstractJournal.this.quorum.getClient();
            if (isLeader) {
                if (!localService.isLeader(prepareToken)) {
                    throw new IllegalStateException("Not leader.");
                }
                st = this.getHAStatus();
                if (!HAStatusEnum.Leader.equals((Object)st)) {
                    throw new IllegalStateException("HAStatusEnum: expected=" + (Object)((Object)HAStatusEnum.Leader) + ", actual=" + (Object)((Object)st));
                }
            } else {
                if (!localService.isFollower(prepareToken)) {
                    throw new IllegalStateException("Not follower.");
                }
                st = this.getHAStatus();
                if (!HAStatusEnum.Follower.equals((Object)st)) {
                    throw new IllegalStateException("HAStatusEnum: expected=" + (Object)((Object)HAStatusEnum.Follower) + ", actual=" + (Object)((Object)st));
                }
            }
            if (prepareToken != (tmp = AbstractJournal.this.getHAReady())) {
                throw new IllegalStateException("HAReadyToken: expected=" + prepareToken + ", actual=" + tmp);
            }
        }

        @Override
        public Future<Void> commit2Phase(IHA2PhaseCommitMessage commitMessage) {
            FutureTaskMon<Object> ft = new FutureTaskMon<Object>((Runnable)new Commit2PhaseTask(commitMessage), null);
            ((FutureTask)ft).run();
            return this.getProxy(ft);
        }

        @Override
        public Future<Void> abort2Phase(IHA2PhaseAbortMessage abortMessage) {
            FutureTaskMon<Object> ft = new FutureTaskMon<Object>((Runnable)new Abort2PhaseTask(abortMessage), null);
            ((FutureTask)ft).run();
            return this.getProxy(ft);
        }

        @Override
        public Future<IHAReadResponse> readFromDisk(IHAReadRequest msg) {
            final long token = msg.getQuorumToken();
            final long addr = msg.getAddr();
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("token=" + token + ", addr=" + addr));
            }
            FutureTask<IHAReadResponse> ft = new FutureTask<IHAReadResponse>(new Callable<IHAReadResponse>(){

                @Override
                public IHAReadResponse call() throws Exception {
                    if (haLog.isInfoEnabled()) {
                        haLog.info((Object)("token=" + token));
                    }
                    AbstractJournal.this.quorum.assertQuorum(token);
                    ByteBuffer b = ((IHABufferStrategy)AbstractJournal.this.getBufferStrategy()).readFromLocalStore(addr);
                    byte[] a = BytesUtil.toArray((ByteBuffer)b);
                    return new HAReadResponse(a);
                }
            });
            ft.run();
            return this.getProxy(ft);
        }

        @Override
        public Future<Void> receiveAndReplicate(IHASyncRequest req, IHASendState snd, IHAWriteMessage msg) throws IOException {
            if (haLog.isDebugEnabled()) {
                haLog.debug((Object)("req=" + req + ", msg=" + msg));
            }
            Future<Void> ft = ((QuorumService)AbstractJournal.this.quorum.getClient()).receiveAndReplicate(req, snd, msg);
            return this.getProxy(ft);
        }

        @Override
        public IHALogRootBlocksResponse getHALogRootBlocksForWriteSet(IHALogRootBlocksRequest msg) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<Void> sendHALogForWriteSet(IHALogRequest msg) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Future<IHASendStoreResponse> sendHAStore(IHARebuildRequest msg) throws IOException {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHAWriteSetStateResponse getHAWriteSetState(IHAWriteSetStateRequest req) {
            HAWriteSetStateResponse resp;
            long token = AbstractJournal.this.getQuorum().token();
            AbstractJournal.this.getQuorum().assertLeader(token);
            ReentrantReadWriteLock.ReadLock lock = AbstractJournal.this._fieldReadWriteLock.readLock();
            lock.lock();
            try {
                IRootBlockView rb = AbstractJournal.this._rootBlock;
                long sequence = ((IHABufferStrategy)AbstractJournal.this.getBufferStrategy()).getCurrentBlockSequence();
                resp = new HAWriteSetStateResponse(rb.getCommitCounter(), rb.getLastCommitTime(), sequence);
            }
            finally {
                lock.unlock();
            }
            AbstractJournal.this.getQuorum().assertLeader(token);
            return resp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IHARootBlockResponse getRootBlock(IHARootBlockRequest msg) {
            UUID storeId = msg.getStoreUUID();
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("storeId=" + storeId));
            }
            if (storeId != null && !AbstractJournal.this.getUUID().equals(storeId)) {
                throw new UnsupportedOperationException();
            }
            if (msg.isNonBlocking()) {
                return new HARootBlockResponse(AbstractJournal.this.getRootBlockView());
            }
            ReentrantReadWriteLock.ReadLock lock = AbstractJournal.this._fieldReadWriteLock.readLock();
            lock.lock();
            try {
                HARootBlockResponse hARootBlockResponse = new HARootBlockResponse(AbstractJournal.this.getRootBlockView());
                return hARootBlockResponse;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public Future<Void> moveToEndOfPipeline() {
            FutureTaskMon<Object> ft = new FutureTaskMon<Object>(new Runnable(){

                @Override
                public void run() {
                    if (haLog.isInfoEnabled()) {
                        haLog.info((Object)"");
                    }
                    QuorumActor actor = AbstractJournal.this.quorum.getActor();
                    actor.pipelineRemove();
                    actor.pipelineAdd();
                }
            }, null);
            AbstractJournal.this.getExecutorService().execute(ft);
            return this.getProxy(ft);
        }

        @Override
        public Future<IHAPipelineResetResponse> resetPipeline(IHAPipelineResetRequest req) throws IOException {
            Future<IHAPipelineResetResponse> f = ((QuorumService)AbstractJournal.this.quorum.getClient()).resetPipeline(req);
            return this.getProxy(f);
        }

        @Override
        public void gatherMinimumVisibleCommitTime(IHAGatherReleaseTimeRequest req) throws IOException {
            Future oldFuture;
            if (haLog.isInfoEnabled()) {
                haLog.info((Object)("req=" + req));
            }
            if ((oldFuture = (Future)AbstractJournal.this.gatherFuture.getAndSet(null)) != null && !oldFuture.isDone()) {
                oldFuture.cancel(true);
            }
            UUID leaderId = req.getLeaderId();
            HAGlue leader = (HAGlue)AbstractJournal.this.getQuorum().getClient().getService(leaderId);
            if (leader == null) {
                throw new RuntimeException("Could not discover the quorum leader.");
            }
            UUID serviceId = this.getServiceId();
            if (serviceId == null) {
                throw new AssertionError();
            }
            Callable<IHANotifyReleaseTimeResponse> task = ((AbstractHATransactionService)AbstractJournal.this.getLocalTransactionManager().getTransactionService()).newGatherMinimumVisibleCommitTimeTask(leader, serviceId, req);
            FutureTask<IHANotifyReleaseTimeResponse> ft = new FutureTask<IHANotifyReleaseTimeResponse>(task);
            AbstractJournal.this.gatherFuture.set(ft);
            AbstractJournal.this.getExecutorService().execute(ft);
        }

        @Override
        public IHANotifyReleaseTimeResponse notifyEarliestCommitTime(IHANotifyReleaseTimeRequest req) throws IOException, InterruptedException, BrokenBarrierException {
            return ((HATXSGlue)((Object)AbstractJournal.this.getLocalTransactionManager().getTransactionService())).notifyEarliestCommitTime(req);
        }

        public long nextTimestamp() {
            try {
                return AbstractJournal.this.getLocalTransactionManager().getTransactionService().nextTimestamp();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public UUID getServiceUUID() throws IOException {
            return this.getServiceId();
        }

        @Override
        public Class getServiceIface() throws IOException {
            return HAGlue.class;
        }

        @Override
        public String getHostname() throws IOException {
            return AbstractStatisticsCollector.fullyQualifiedHostName;
        }

        @Override
        public String getServiceName() throws IOException {
            return this.getServiceIface().getName() + "@" + this.getHostname() + "#" + this.hashCode();
        }

        @Override
        public void destroy() throws RemoteException {
            AbstractJournal.this.destroy();
        }

        @Override
        public <T> Future<T> submit(IIndexManagerCallable<T> callable, boolean asyncFuture) throws IOException {
            callable.setIndexManager(this.getIndexManager());
            Future<T> ft = this.getIndexManager().getExecutorService().submit(callable);
            return this.getProxy(ft, asyncFuture);
        }

        private class Abort2PhaseTask
        implements Runnable {
            private final IHA2PhaseAbortMessage abortMessage;

            public Abort2PhaseTask(IHA2PhaseAbortMessage abortMessage) {
                if (abortMessage == null) {
                    throw new IllegalArgumentException();
                }
                this.abortMessage = abortMessage;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    BasicHA.this.prepareRequest.set(null);
                    BasicHA.this.vote.set(false);
                    long token = this.abortMessage.getQuorumToken();
                    if (haLog.isInfoEnabled()) {
                        haLog.info((Object)("token=" + token));
                    }
                }
                finally {
                    AbstractJournal.this.doLocalAbort();
                }
            }
        }

        private class Commit2PhaseTask
        implements Runnable {
            private final IHA2PhaseCommitMessage commitMessage;

            public Commit2PhaseTask(IHA2PhaseCommitMessage commitMessage) {
                if (commitMessage == null) {
                    throw new IllegalArgumentException();
                }
                this.commitMessage = commitMessage;
            }

            @Override
            public void run() {
                QuorumService localService = null;
                AbstractJournal.this._fieldReadWriteLock.writeLock().lock();
                try {
                    localService = (QuorumService)AbstractJournal.this.quorum.getClient();
                    this.doInnerRun(localService);
                }
                catch (Throwable t) {
                    try {
                        haLog.error((Object)("ERROR IN 2-PHASE COMMIT: " + t + ", rootBlock=" + ((IHA2PhasePrepareMessage)BasicHA.this.prepareRequest.get()).getRootBlock()), t);
                    }
                    catch (Throwable t2) {
                        log.error((Object)t2, t2);
                    }
                    if (localService != null) {
                        localService.enterErrorState();
                    }
                    throw new RuntimeException(t);
                }
                finally {
                    BasicHA.this.prepareRequest.set(null);
                    BasicHA.this.vote.set(false);
                    AbstractJournal.this._fieldReadWriteLock.writeLock().unlock();
                }
            }

            private void doInnerRun(QuorumService<HAGlue> localService) throws Exception {
                IHA2PhasePrepareMessage prepareMessage = (IHA2PhasePrepareMessage)BasicHA.this.prepareRequest.get();
                if (prepareMessage == null) {
                    throw new IllegalStateException();
                }
                if (!prepareMessage.isJoinedService()) {
                    throw new AssertionError();
                }
                IRootBlockView rootBlock = prepareMessage == null ? null : prepareMessage.getRootBlock();
                long commitTime = this.commitMessage.getCommitTime();
                if (rootBlock == null) {
                    throw new IllegalStateException();
                }
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("commitTime=" + commitTime + ", commitCounter=" + prepareMessage.getRootBlock().getCommitCounter() + ", vote=" + BasicHA.this.vote));
                }
                if (rootBlock.getLastCommitTime() != commitTime) {
                    throw new IllegalStateException();
                }
                if (!BasicHA.this.vote.get()) {
                    haLog.warn((Object)"IGNORING COMMIT2PHASE");
                    return;
                }
                AbstractJournal.this.quorum.assertQuorum(rootBlock.getQuorumToken());
                if (this.commitMessage.failCommit_beforeWritingRootBlockOnJournal()) {
                    throw new Mock2PhaseCommitProtocolException();
                }
                AbstractJournal.this.doLocalCommit(localService, rootBlock);
                if (this.commitMessage.failCommit_beforeClosingHALog()) {
                    throw new Mock2PhaseCommitProtocolException();
                }
                localService.logRootBlock(rootBlock);
                if (this.commitMessage.didAllServicesPrepare()) {
                    localService.purgeHALogs(rootBlock.getQuorumToken());
                }
            }
        }

        private class Prepare2PhaseTask
        implements Callable<Boolean> {
            private final boolean isLeader;
            private final IHA2PhasePrepareMessage prepareMessage;

            public Prepare2PhaseTask(boolean isLeader, IHA2PhasePrepareMessage prepareMessage) {
                if (prepareMessage == null) {
                    throw new IllegalArgumentException();
                }
                if (!prepareMessage.isJoinedService()) {
                    throw new AssertionError();
                }
                this.isLeader = isLeader;
                this.prepareMessage = prepareMessage;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                QuorumService localService = null;
                try {
                    localService = (QuorumService)AbstractJournal.this.quorum.getClient();
                    Boolean bl = this.innerCall();
                    return bl;
                }
                finally {
                    if (haLog.isInfoEnabled()) {
                        haLog.info((Object)("VOTE=" + BasicHA.this.vote.get()));
                    }
                    if (!BasicHA.this.vote.get() && localService != null) {
                        localService.enterErrorState();
                    }
                }
            }

            private Boolean innerCall() throws Exception {
                long expectedReleaseTime;
                long localReleaseTime;
                Future oldFuture = AbstractJournal.this.gatherFuture.getAndSet(null);
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("gatherFuture=" + oldFuture));
                }
                IRootBlockView rootBlock = this.prepareMessage.getRootBlock();
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("preparedRequest=" + rootBlock + ", isLeader: " + this.isLeader));
                }
                if (rootBlock == null) {
                    throw new IllegalStateException();
                }
                BasicHA.this.validateNewRootBlock(this.isLeader, AbstractJournal.this._rootBlock, rootBlock);
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)("validated=" + rootBlock));
                }
                IHANotifyReleaseTimeResponse consensusReleaseTime = this.prepareMessage.getConsensusReleaseTime();
                if (oldFuture != null) {
                    oldFuture.get();
                }
                if ((localReleaseTime = AbstractJournal.this.getLocalTransactionManager().getTransactionService().getReleaseTime()) != (expectedReleaseTime = Math.max(0L, consensusReleaseTime.getCommitTime() - 1L))) {
                    throw new AssertionError((Object)("Local service does not agree with consensusReleaseTime: localReleaseTime=" + localReleaseTime + ", expectedReleaseTime=" + expectedReleaseTime + ", consensusReleaseTime=" + consensusReleaseTime + ", serviceId=" + BasicHA.this.getServiceId()));
                }
                if (!this.isLeader) {
                    if (!this.prepareMessage.isGatherService()) {
                        assert (oldFuture == null);
                        BasicHA.this.vote.set(true);
                        return BasicHA.this.vote.get();
                    }
                    try {
                        IHANotifyReleaseTimeResponse tmp = (IHANotifyReleaseTimeResponse)oldFuture.get();
                        if (tmp.getCommitCounter() != consensusReleaseTime.getCommitCounter() || tmp.getCommitTime() != consensusReleaseTime.getCommitTime()) {
                            throw new AssertionError((Object)("GatherTask reports different consensus: GatherTask=" + tmp + ", consensusReleaseTime=" + consensusReleaseTime));
                        }
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError();
                    }
                    catch (CancellationException e) {
                        haLog.error((Object)("Gather cancelled on follower: serviceId=" + BasicHA.this.getServiceId() + " : " + e), (Throwable)e);
                        return BasicHA.this.vote.get();
                    }
                    catch (ExecutionException e) {
                        haLog.error((Object)("Gather failed on follower: serviceId=" + BasicHA.this.getServiceId() + " : " + e), (Throwable)e);
                        return BasicHA.this.vote.get();
                    }
                }
                if (AbstractJournal.this.doubleSync) {
                    AbstractJournal.this._bufferStrategy.force(false);
                }
                if (this.prepareMessage.voteNo()) {
                    throw new Mock2PhaseCommitProtocolException("Force NO vote");
                }
                BasicHA.this.vote.set(true);
                return BasicHA.this.vote.get();
            }
        }

        protected class VoteNoTask
        implements Callable<Boolean> {
            private final QuorumService<HAGlue> localService;

            public VoteNoTask(QuorumService<HAGlue> localService) {
                this.localService = localService;
            }

            @Override
            public Boolean call() throws Exception {
                BasicHA.this.vote.set(false);
                IHA2PhasePrepareMessage req = (IHA2PhasePrepareMessage)BasicHA.this.prepareRequest.get();
                AbstractJournal.this.doLocalAbort();
                if (req.isJoinedService() && this.localService != null) {
                    this.localService.enterErrorState();
                }
                return BasicHA.this.vote.get();
            }
        }
    }

    private class ICUVersionCommitter
    implements ICommitter {
        private boolean update;
        private long lastAddr;
        private volatile Throwable error = null;

        private ICUVersionCommitter() {
            this.update = Boolean.valueOf(AbstractJournal.this.properties.getProperty(Options.UPDATE_ICU_VERSION, "false"));
            this.lastAddr = AbstractJournal.this.getRootAddr(3);
        }

        @Override
        public long handleCommit(long commitTime) {
            if (this.error != null) {
                throw new IndexInconsistentError(this.error);
            }
            if (!this.update && this.lastAddr != 0L) {
                return this.lastAddr;
            }
            ICUVersionRecord r = ICUVersionRecord.newInstance();
            if (this.lastAddr == 0L || !r.equals(AbstractJournal.this._icuVersionRecord) || !this.update) {
                if (AbstractJournal.this._icuVersionRecord != null && this.update) {
                    log.warn((Object)("Updating ICUVersion: old=" + AbstractJournal.this._icuVersionRecord + ", new=" + r));
                }
                this.update = false;
                this.lastAddr = AbstractJournal.this.write(ByteBuffer.wrap(SerializerUtil.serialize(r)));
                return this.lastAddr;
            }
            return this.lastAddr;
        }

        @Override
        public void invalidate(Throwable t) {
            if (t == null) {
                throw new IllegalArgumentException();
            }
            if (this.error == null) {
                this.error = t;
            }
        }
    }

    private static class CommitState {
        private final long beginNanos;
        private final AbstractJournal store;
        private final IBufferStrategy _bufferStrategy;
        private final Quorum<HAGlue, QuorumService<HAGlue>> quorum;
        private final QuorumService<HAGlue> quorumService;
        private final long commitTime;
        private final IRootBlockView old;
        private final long commitToken;
        private final long newCommitCounter;
        private long[] rootAddrs;
        private long commitRecordAddr;
        private long commitRecordIndexAddr;
        private IRootBlockView newRootBlock;
        private IJoinedAndNonJoinedServices gatherJoinedAndNonJoinedServices = null;
        private IHANotifyReleaseTimeResponse consensusReleaseTime = null;
        private IJoinedAndNonJoinedServices prepareJoinedAndNonJoinedServices;
        private PrepareRequest prepareRequest;
        private PrepareResponse prepareResponse;
        private CommitRequest commitRequest;
        private CommitResponse commitResponse;

        public CommitState(AbstractJournal store, long commitTime) {
            if (store == null) {
                throw new IllegalArgumentException();
            }
            this.beginNanos = System.nanoTime();
            this.store = store;
            this.commitTime = commitTime;
            this._bufferStrategy = store._bufferStrategy;
            this.quorum = store.quorum;
            this.quorumService = this.quorum == null ? null : this.quorum.getClient();
            this.old = store._rootBlock;
            this.newCommitCounter = this.old.getCommitCounter() + 1L;
            this.commitToken = store.quorumToken;
            store.assertCommitTimeAdvances(commitTime);
        }

        private boolean notifyCommitters() {
            long beginNanos = System.nanoTime();
            this.rootAddrs = this.store.notifyCommitters(this.commitTime);
            if (!this._bufferStrategy.requiresCommit(this.store._rootBlock)) {
                return false;
            }
            this.rootAddrs[1] = this.store.m_rootBlockCommitter.handleCommit(this.commitTime);
            this.store.commitCounters.elapsedNotifyCommittersNanos.add(System.nanoTime() - beginNanos);
            return true;
        }

        private void writeCommitRecord() {
            long beginNanos = System.nanoTime();
            if (this._bufferStrategy instanceof IHistoryManager) {
                ((IHistoryManager)((Object)this._bufferStrategy)).checkDeferredFrees(this.store);
            }
            CommitRecord commitRecord = new CommitRecord(this.commitTime, this.newCommitCounter, this.rootAddrs);
            this.commitRecordAddr = this.store.write(ByteBuffer.wrap(CommitRecordSerializer.INSTANCE.serialize(commitRecord)));
            this.store._commitRecordIndex.add(this.commitRecordAddr, commitRecord);
            this.commitRecordIndexAddr = this.store._commitRecordIndex.writeCheckpoint();
            this.store.commitCounters.elapsedWriteCommitRecordNanos.add(System.nanoTime() - beginNanos);
        }

        private void flushWriteSet() {
            long beginNanos = System.nanoTime();
            this._bufferStrategy.commit();
            this.store.commitCounters.elapsedFlushWriteSetNanos.add(System.nanoTime() - beginNanos);
        }

        private void newRootBlock() {
            long nextOffset = this._bufferStrategy.getNextOffset();
            long blockSequence = this._bufferStrategy instanceof IHABufferStrategy ? ((IHABufferStrategy)this._bufferStrategy).getBlockSequence() : this.old.getBlockSequence();
            long firstCommitTime = this.old.getFirstCommitTime() == 0L ? this.commitTime : this.old.getFirstCommitTime();
            long priorCommitTime = this.old.getLastCommitTime();
            if (priorCommitTime != 0L) {
                AbstractJournal.assertPriorCommitTimeAdvances(this.commitTime, priorCommitTime);
            }
            long lastCommitTime = this.commitTime;
            long metaStartAddr = this._bufferStrategy.getMetaStartAddr();
            long metaBitsAddr = this._bufferStrategy.getMetaBitsAddr();
            this.newRootBlock = new RootBlockView(!this.old.isRootBlock0(), this.old.getOffsetBits(), nextOffset, firstCommitTime, lastCommitTime, this.newCommitCounter, this.commitRecordAddr, this.commitRecordIndexAddr, this.old.getUUID(), blockSequence, this.commitToken, metaStartAddr, metaBitsAddr, this.old.getStoreType(), this.old.getCreateTime(), this.old.getCloseTime(), this.old.getVersion(), this.store.checker);
        }

        private void gatherPhase() {
            long beginNanos = System.nanoTime();
            if (!(this._bufferStrategy instanceof IHABufferStrategy)) {
                return;
            }
            if (this.quorum == null) {
                return;
            }
            if (!this.quorum.isHighlyAvailable()) {
                return;
            }
            this.store._gatherLock.lock();
            try {
                this.gatherJoinedAndNonJoinedServices = new JoinedAndNonJoinedServices(this.quorum);
                this.consensusReleaseTime = ((AbstractHATransactionService)this.store.getLocalTransactionManager().getTransactionService()).updateReleaseTimeConsensus(this.newCommitCounter, this.commitTime, this.gatherJoinedAndNonJoinedServices.getJoinedServiceIds(), this.store.getHAReleaseTimeConsensusTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                throw new RuntimeException(ex);
            }
            finally {
                this.store._gatherLock.unlock();
                this.store.commitCounters.elapsedGatherNanos.add(System.nanoTime() - beginNanos);
            }
        }

        private void commitSimple() {
            QuorumService<HAGlue> localService;
            long beginNanos = System.nanoTime();
            if (this.store.doubleSync) {
                this._bufferStrategy.force(false);
            }
            this._bufferStrategy.writeRootBlock(this.newRootBlock, this.store.forceOnCommit);
            if (this._bufferStrategy instanceof IRWStrategy) {
                ((IRWStrategy)this._bufferStrategy).postCommit();
            }
            this.store._rootBlock = this.newRootBlock;
            this.store._commitRecord = this.store._getCommitRecord();
            if (this.quorum != null && (localService = this.quorum.getClient()) != null) {
                try {
                    localService.logRootBlock(this.newRootBlock);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (txLog.isInfoEnabled()) {
                txLog.info((Object)("COMMIT: commitTime=" + this.commitTime));
            }
            this.store.commitCounters.elapsedSimpleCommitNanos.add(System.nanoTime() - beginNanos);
        }

        private void commitHA() {
            try {
                this.prepare2Phase();
                this.commit2Phase();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepare2Phase() throws InterruptedException, TimeoutException, IOException {
            long beginNanos = System.nanoTime();
            boolean didPrepare = false;
            try {
                this.prepareJoinedAndNonJoinedServices = new JoinedAndNonJoinedServices(this.quorum);
                this.prepareRequest = new PrepareRequest(this.consensusReleaseTime, this.gatherJoinedAndNonJoinedServices, this.prepareJoinedAndNonJoinedServices, this.newRootBlock, this.quorumService.getPrepareTimeout(), TimeUnit.MILLISECONDS);
                this.prepareResponse = this.quorumService.prepare2Phase(this.prepareRequest);
                if (haLog.isInfoEnabled()) {
                    haLog.info((Object)this.prepareResponse.toString());
                }
                if (!this.prepareResponse.willCommit()) {
                    throw new QuorumException("PREPARE rejected: nyes=" + this.prepareResponse.getYesCount() + ", replicationFactor=" + this.prepareResponse.replicationFactor());
                }
                didPrepare = true;
            }
            finally {
                if (!didPrepare) {
                    try {
                        this.quorumService.abort2Phase(this.commitToken);
                    }
                    catch (Throwable t) {
                        log.warn((Object)t, t);
                    }
                }
                this.store.commitCounters.elapsedPrepare2PhaseNanos.add(System.nanoTime() - beginNanos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commit2Phase() throws Exception {
            long beginNanos = System.nanoTime();
            boolean didCommit = false;
            try {
                this.commitRequest = new CommitRequest(this.prepareRequest, this.prepareResponse);
                this.commitResponse = this.quorumService.commit2Phase(this.commitRequest);
                if (!this.store.quorum.isQuorum(this.commitResponse.getNOk())) {
                    this.commitResponse.throwCauses();
                }
                didCommit = true;
            }
            finally {
                if (!didCommit) {
                    this.quorumService.enterErrorState();
                }
                this.store.commitCounters.elapsedCommit2PhaseNanos.add(System.nanoTime() - beginNanos);
            }
        }
    }

    private static class CommitCounters
    implements ICounterSetAccess {
        private final CAT elapsedNotifyCommittersNanos = new CAT();
        private final CAT elapsedWriteCommitRecordNanos = new CAT();
        private final CAT elapsedFlushWriteSetNanos = new CAT();
        private final CAT elapsedSimpleCommitNanos = new CAT();
        private final CAT elapsedTotalCommitNanos = new CAT();
        private final CAT elapsedGatherNanos = new CAT();
        private final CAT elapsedPrepare2PhaseNanos = new CAT();
        private final CAT elapsedCommit2PhaseNanos = new CAT();

        private CommitCounters() {
        }

        @Override
        public CounterSet getCounters() {
            CounterSet root = new CounterSet();
            root.addCounter("notifyCommittersSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedNotifyCommittersNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            root.addCounter("writeCommitRecordSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedWriteCommitRecordNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            root.addCounter("flushWriteSetSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedFlushWriteSetNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            root.addCounter("simpleCommitSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedSimpleCommitNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            root.addCounter("totalCommitSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedTotalCommitNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            root.addCounter("gatherSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedGatherNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            root.addCounter("prepare2PhaseSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedPrepare2PhaseNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            root.addCounter("commit2PhaseSecs", new Instrument<Double>(){

                @Override
                public void sample() {
                    double secs = (double)CommitCounters.this.elapsedCommit2PhaseNanos.get() / 1.0E9;
                    this.setValue(secs);
                }
            });
            return root;
        }
    }

    private static class CountersFactory {
        private CountersFactory() {
        }

        public static CounterSet getCounters(AbstractJournal jnl) {
            CounterSet counters = new CounterSet();
            final WeakReference<AbstractJournal> ref = new WeakReference<AbstractJournal>(jnl);
            counters.addCounter("file", new Instrument<String>(){

                @Override
                public void sample() {
                    File file;
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null && (file = jnl.getFile()) != null) {
                        this.setValue(file.toString());
                    }
                }
            });
            counters.addCounter("bufferMode", new Instrument<String>(){

                @Override
                public void sample() {
                    BufferMode bufferMode;
                    IBufferStrategy bufferStrategy;
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null && (bufferStrategy = jnl.getBufferStrategy()) != null && (bufferMode = bufferStrategy.getBufferMode()) != null) {
                        this.setValue(bufferMode.toString());
                    }
                }
            });
            counters.addCounter("groupCommit", new Instrument<Boolean>(){

                @Override
                public void sample() {
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null) {
                        this.setValue(jnl.isGroupCommit());
                    }
                }
            });
            counters.addCounter("createTime", new Instrument<Long>(){

                @Override
                public void sample() {
                    IRootBlockView rootBlock;
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null && (rootBlock = jnl._rootBlock) != null) {
                        this.setValue(rootBlock.getCreateTime());
                    }
                }
            });
            counters.addCounter("closeTime", new Instrument<Long>(){

                @Override
                public void sample() {
                    IRootBlockView rootBlock;
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null && (rootBlock = jnl._rootBlock) != null) {
                        this.setValue(rootBlock.getCloseTime());
                    }
                }
            });
            counters.addCounter("commitCount", new Instrument<Long>(){

                @Override
                public void sample() {
                    IRootBlockView rootBlock;
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null && (rootBlock = jnl._rootBlock) != null) {
                        this.setValue(rootBlock.getCommitCounter());
                    }
                }
            });
            counters.addCounter("historicalIndexCacheSize", new Instrument<Integer>(){

                @Override
                public void sample() {
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null) {
                        this.setValue(jnl.historicalIndexCache.size());
                    }
                }
            });
            counters.addCounter("indexCacheSize", new Instrument<Integer>(){

                @Override
                public void sample() {
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null) {
                        this.setValue(jnl.indexCache.size());
                    }
                }
            });
            counters.addCounter("liveIndexCacheSize", new Instrument<Integer>(){

                @Override
                public void sample() {
                    Name2Addr name2Addr;
                    AbstractJournal jnl = (AbstractJournal)ref.get();
                    if (jnl != null && (name2Addr = jnl._name2Addr) != null) {
                        this.setValue(name2Addr.getIndexCacheSize());
                    }
                }
            });
            counters.attach(jnl._bufferStrategy.getCounters());
            counters.makePath("commit").attach(jnl.commitCounters.getCounters());
            return counters;
        }
    }
}

