/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters;

import com.bigdata.counters.AbstractProcessCollector;
import com.bigdata.counters.AbstractProcessReader;
import com.bigdata.util.DaemonThreadFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.log4j.Logger;

public class ActiveProcess {
    protected static final Logger log = Logger.getLogger(ActiveProcess.class);
    protected final ExecutorService readService = Executors.newSingleThreadExecutor((ThreadFactory)new DaemonThreadFactory(this.getClass().getName() + ".readService"));
    protected Process process = null;
    protected InputStream is = null;
    protected volatile Future readerFuture;

    protected ActiveProcess() {
    }

    public ActiveProcess(List<String> command, AbstractProcessCollector collector) {
        if (command == null) {
            throw new IllegalArgumentException();
        }
        if (command.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (collector == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        for (String s : command) {
            sb.append(s + " ");
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("command:\n" + sb));
        }
        try {
            ProcessBuilder tmp = new ProcessBuilder(command);
            collector.setEnvironment(tmp.environment());
            this.process = tmp.start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void start(AbstractProcessReader processReader) {
        log.info((Object)"");
        if (processReader == null) {
            throw new IllegalArgumentException();
        }
        if (this.readerFuture != null) {
            throw new IllegalStateException();
        }
        this.is = this.process.getInputStream();
        assert (this.is != null);
        if (log.isInfoEnabled()) {
            log.info((Object)("starting process reader: " + processReader));
        }
        processReader.start(this.is);
        if (log.isInfoEnabled()) {
            log.info((Object)("submitting process reader task: " + processReader));
        }
        this.readerFuture = this.readService.submit(processReader);
        if (log.isInfoEnabled()) {
            log.info((Object)("readerFuture: done=" + this.readerFuture.isDone()));
        }
    }

    public void stop() {
        if (this.readerFuture == null) {
            return;
        }
        this.readerFuture.cancel(true);
        this.readService.shutdownNow();
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
            this.is = null;
        }
        this.readerFuture = null;
    }

    public boolean isAlive() {
        if (this.readerFuture == null || this.readerFuture.isDone() || this.process == null || this.is == null) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Not alive: readerFuture=" + this.readerFuture + (this.readerFuture != null ? "done=" + this.readerFuture.isDone() : "") + ", process=" + this.process + ", is=" + this.is));
            }
            return false;
        }
        return true;
    }
}

