/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.AbstractBTree;
import com.bigdata.btree.AbstractNode;
import com.bigdata.btree.PageStats;

public class BTreePageStats
extends PageStats {
    public void visit(AbstractBTree btree, AbstractNode<?> node) {
        if (this.m == 0) {
            this.m = btree.getBranchingFactor();
            this.ntuples = btree.getEntryCount();
            this.height = btree.getHeight();
        }
        super.visit(btree, node);
    }

    @Override
    public int getRecommendedBranchingFactor() {
        if (this.nnodes == 0L) {
            return this.m;
        }
        int NOMINAL_PAGE_SIZE = 8192;
        float maxPercentBlobs = 0.05f;
        float[] percentages = new float[SLOT_SIZES.length];
        long nallocs = this.nnodes + this.nleaves;
        for (int i = 0; i < SLOT_SIZES.length; ++i) {
            percentages[i] = this.histogram[i] / nallocs;
        }
        float percentBlobs = this.blobs / nallocs;
        if (percentBlobs > 0.05f) {
            int newM = (int)((double)this.m * (1.0 - (double)(percentBlobs - 0.05f)));
            return newM;
        }
        double averageNodeBytes = (double)this.nodeBytes / (double)this.nnodes;
        double averageLeafBytes = (double)this.leafBytes / (double)this.nleaves;
        double reductionFactor = 0.8;
        int newM_nodes = (int)(0.8 * (double)(this.m * 8192) / averageNodeBytes);
        int newM_leaves = (int)(0.8 * (double)(this.m * 8192) / averageLeafBytes);
        int newM = (newM_nodes + newM_leaves) / 2;
        return newM;
    }
}

