/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.counters.CAT;

public class PipelineJoinStats
extends BaseJoinStats {
    private static final long serialVersionUID = 1L;
    public final CAT inputSolutions = new CAT();
    public final CAT outputSolutions = new CAT();

    public double getJoinHitRatio() {
        long in = this.inputSolutions.get();
        long out = this.outputSolutions.get();
        if (in == 0L) {
            return 0.0;
        }
        return (double)out / (double)in;
    }

    @Override
    public void add(BOpStats o) {
        super.add(o);
        if (o instanceof PipelineJoinStats) {
            PipelineJoinStats t = (PipelineJoinStats)o;
            this.inputSolutions.add(t.inputSolutions.get());
            this.outputSolutions.add(t.outputSolutions.get());
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        sb.append(",inputSolutions=" + this.inputSolutions.get());
        sb.append(",outputSolutions=" + this.outputSolutions.get());
        sb.append(",joinHitRatio=" + this.getJoinHitRatio());
    }
}

