/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.constraint;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.constraint.INConstraint;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;

public class INBinarySearch<T>
extends INConstraint<T> {
    private static final long serialVersionUID = 2251370041131847351L;
    private volatile transient IVariable<T> var;
    private volatile transient T[] set;

    public INBinarySearch(INBinarySearch<T> op) {
        super(op);
    }

    public INBinarySearch(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
    }

    public INBinarySearch(IVariable<T> x, IConstant<T>[] set) {
        super(new BOp[0], NV.asMap(new NV(INConstraint.Annotations.VARIABLE, x), new NV(INConstraint.Annotations.SET, set)));
    }

    private static <T> T[] sort(IConstant<T>[] set) {
        int n = set.length;
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        Object firstValue = set[0].get();
        Object[] tmp = (Object[])Array.newInstance(firstValue.getClass(), n);
        for (int i = 0; i < n; ++i) {
            tmp[i] = set[i].get();
        }
        Arrays.sort(tmp);
        return tmp;
    }

    private void init() {
        this.var = this.getVariable();
        this.set = INBinarySearch.sort(this.getSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean get(IBindingSet bindingSet) {
        IConstant x;
        if (this.var == null) {
            INBinarySearch iNBinarySearch = this;
            synchronized (iNBinarySearch) {
                if (this.var == null) {
                    this.init();
                }
            }
        }
        if ((x = bindingSet.get(this.var)) == null) {
            return true;
        }
        Object v = x.get();
        int pos = Arrays.binarySearch(this.set, v);
        boolean found = pos >= 0;
        return found;
    }
}

