from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    BooleanType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImplementationGuideSchema:
    """
    A set of rules of how FHIR is used to solve a particular problem. This
    resource is used to gather all the parts of an implementation guide into a
    logical whole and to publish a computable definition of all the parts.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueUrl",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        A set of rules of how FHIR is used to solve a particular problem. This
        resource is used to gather all the parts of an implementation guide into a
        logical whole and to publish a computable definition of all the parts.


        id: The logical id of the resource, as used in the URL for the resource. Once
            assigned, this value never changes.

        extension: May be used to represent additional information that is not part of the basic
            definition of the resource. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        meta: The metadata about the resource. This is content that is maintained by the
            infrastructure. Changes to the content may not always be associated with
            version changes to the resource.

        implicitRules: A reference to a set of rules that were followed when the resource was
            constructed, and which must be understood when processing the content.

        language: The base language in which the resource is written.

        text: A human-readable narrative that contains a summary of the resource, and may be
            used to represent the content of the resource to a human. The narrative need
            not encode all the structured data, but is required to contain sufficient
            detail to make it "clinically safe" for a human to just read the narrative.
            Resource definitions may define what content should be represented in the
            narrative to ensure clinical safety.

        contained: These resources do not have an independent existence apart from the resource
            that contains them - they cannot be identified independently, and nor can they
            have their own independent transaction scope.

        resourceType: This is a ImplementationGuide resource

        url: An absolute URI that is used to identify this implementation guide when it is
            referenced in a specification, model, design or an instance. This SHALL be a
            URL, SHOULD be globally unique, and SHOULD be an address at which this
            implementation guide is (or will be) published. The URL SHOULD include the
            major version of the implementation guide. For more information see [Technical
            and Business Versions](resource.html#versions).

        version: The identifier that is used to identify this version of the implementation
            guide when it is referenced in a specification, model, design or instance.
            This is an arbitrary value managed by the implementation guide author and is
            not expected to be globally unique. For example, it might be a timestamp (e.g.
            yyyymmdd) if a managed version is not available. There is also no expectation
            that versions can be placed in a lexicographical sequence.

        name: A natural language name identifying the implementation guide. This name should
            be usable as an identifier for the module by machine processing applications
            such as code generation.

        status: The status of this implementation guide. Enables tracking the life-cycle of
            the content.

        experimental: A boolean value to indicate that this implementation guide is authored for
            testing purposes (or education/evaluation/marketing), and is not intended to
            be used for genuine usage.

        date: The date  (and optionally time) when the implementation guide was published.
            The date must change if and when the business version changes and it must
            change if the status code changes. In addition, it should change when the
            substantive content of the implementation guide changes.

        publisher: The name of the individual or organization that published the implementation
            guide.

        contact: Contact details to assist a user in finding and communicating with the
            publisher.

        description: A free text natural language description of the implementation guide from a
            consumer's perspective.

        useContext: The content was developed with a focus and intent of supporting the contexts
            that are listed. These terms may be used to assist with indexing and searching
            for appropriate implementation guide instances.

        jurisdiction: A legal or geographic region in which the implementation guide is intended to
            be used.

        copyright: A copyright statement relating to the implementation guide and/or its
            contents. Copyright statements are generally legal restrictions on the use and
            publishing of the implementation guide.

        fhirVersion: The version of the FHIR specification on which this ImplementationGuide is
            based - this is the formal version of the specification, without the revision
            number, e.g. [publication].[major].[minor], which is 3.0.1 for this version.

        dependency: Another implementation guide that this implementation depends on. Typically,
            an implementation guide uses value sets, profiles etc.defined in other
            implementation guides.

        package: A logical group of resources. Logical groups can be used when building pages.

        global: A set of profiles that all resources covered by this implementation guide must
            conform to.

        binary: A binary file that is included in the  implementation guide when it is
            published.

        page: A page / section in the implementation guide. The root page is the
            implementation guide home page.

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.meta import MetaSchema
        from spark_fhir_schemas.stu3.complex_types.narrative import NarrativeSchema
        from spark_fhir_schemas.stu3.simple_types.resourcelist import ResourceListSchema
        from spark_fhir_schemas.stu3.complex_types.contactdetail import (
            ContactDetailSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.usagecontext import (
            UsageContextSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.implementationguide_dependency import (
            ImplementationGuide_DependencySchema,
        )
        from spark_fhir_schemas.stu3.complex_types.implementationguide_package import (
            ImplementationGuide_PackageSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.implementationguide_global import (
            ImplementationGuide_GlobalSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.implementationguide_page import (
            ImplementationGuide_PageSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ImplementationGuide") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImplementationGuide"]
        schema = StructType(
            [
                # The logical id of the resource, as used in the URL for the resource. Once
                # assigned, this value never changes.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the resource. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The metadata about the resource. This is content that is maintained by the
                # infrastructure. Changes to the content may not always be associated with
                # version changes to the resource.
                StructField(
                    "meta",
                    MetaSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A reference to a set of rules that were followed when the resource was
                # constructed, and which must be understood when processing the content.
                StructField("implicitRules", StringType(), True),
                # The base language in which the resource is written.
                StructField("language", StringType(), True),
                # A human-readable narrative that contains a summary of the resource, and may be
                # used to represent the content of the resource to a human. The narrative need
                # not encode all the structured data, but is required to contain sufficient
                # detail to make it "clinically safe" for a human to just read the narrative.
                # Resource definitions may define what content should be represented in the
                # narrative to ensure clinical safety.
                StructField(
                    "text",
                    NarrativeSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # These resources do not have an independent existence apart from the resource
                # that contains them - they cannot be identified independently, and nor can they
                # have their own independent transaction scope.
                StructField(
                    "contained",
                    ArrayType(
                        ResourceListSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # This is a ImplementationGuide resource
                StructField("resourceType", StringType(), True),
                # An absolute URI that is used to identify this implementation guide when it is
                # referenced in a specification, model, design or an instance. This SHALL be a
                # URL, SHOULD be globally unique, and SHOULD be an address at which this
                # implementation guide is (or will be) published. The URL SHOULD include the
                # major version of the implementation guide. For more information see [Technical
                # and Business Versions](resource.html#versions).
                StructField("url", StringType(), True),
                # The identifier that is used to identify this version of the implementation
                # guide when it is referenced in a specification, model, design or instance.
                # This is an arbitrary value managed by the implementation guide author and is
                # not expected to be globally unique. For example, it might be a timestamp (e.g.
                # yyyymmdd) if a managed version is not available. There is also no expectation
                # that versions can be placed in a lexicographical sequence.
                StructField("version", StringType(), True),
                # A natural language name identifying the implementation guide. This name should
                # be usable as an identifier for the module by machine processing applications
                # such as code generation.
                StructField("name", StringType(), True),
                # The status of this implementation guide. Enables tracking the life-cycle of
                # the content.
                StructField("status", StringType(), True),
                # A boolean value to indicate that this implementation guide is authored for
                # testing purposes (or education/evaluation/marketing), and is not intended to
                # be used for genuine usage.
                StructField("experimental", BooleanType(), True),
                # The date  (and optionally time) when the implementation guide was published.
                # The date must change if and when the business version changes and it must
                # change if the status code changes. In addition, it should change when the
                # substantive content of the implementation guide changes.
                StructField("date", StringType(), True),
                # The name of the individual or organization that published the implementation
                # guide.
                StructField("publisher", StringType(), True),
                # Contact details to assist a user in finding and communicating with the
                # publisher.
                StructField(
                    "contact",
                    ArrayType(
                        ContactDetailSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A free text natural language description of the implementation guide from a
                # consumer's perspective.
                StructField("description", StringType(), True),
                # The content was developed with a focus and intent of supporting the contexts
                # that are listed. These terms may be used to assist with indexing and searching
                # for appropriate implementation guide instances.
                StructField(
                    "useContext",
                    ArrayType(
                        UsageContextSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A legal or geographic region in which the implementation guide is intended to
                # be used.
                StructField(
                    "jurisdiction",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A copyright statement relating to the implementation guide and/or its
                # contents. Copyright statements are generally legal restrictions on the use and
                # publishing of the implementation guide.
                StructField("copyright", StringType(), True),
                # The version of the FHIR specification on which this ImplementationGuide is
                # based - this is the formal version of the specification, without the revision
                # number, e.g. [publication].[major].[minor], which is 3.0.1 for this version.
                StructField("fhirVersion", StringType(), True),
                # Another implementation guide that this implementation depends on. Typically,
                # an implementation guide uses value sets, profiles etc.defined in other
                # implementation guides.
                StructField(
                    "dependency",
                    ArrayType(
                        ImplementationGuide_DependencySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A logical group of resources. Logical groups can be used when building pages.
                StructField(
                    "package",
                    ArrayType(
                        ImplementationGuide_PackageSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A set of profiles that all resources covered by this implementation guide must
                # conform to.
                StructField(
                    "global",
                    ArrayType(
                        ImplementationGuide_GlobalSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A binary file that is included in the  implementation guide when it is
                # published.
                # A page / section in the implementation guide. The root page is the
                # implementation guide home page.
                StructField(
                    "page",
                    ImplementationGuide_PageSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
