from typing import Union, List, Optional

from pyspark.sql.types import (
    StructType,
    StructField,
    StringType,
    ArrayType,
    IntegerType,
    DataType,
)


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImagingStudy_SeriesSchema:
    """
    Representation of the content produced in a DICOM imaging study. A study
    comprises a set of series, each of which includes a set of Service-Object Pair
    Instances (SOP Instances - images or other data) acquired or produced in a
    common context.  A series is of only one modality (e.g. X-ray, CT, MR,
    ultrasound), but a study may have multiple series of different modalities.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
        extension_fields: Optional[List[str]] = [
            "valueBoolean",
            "valueCode",
            "valueDate",
            "valueDateTime",
            "valueDecimal",
            "valueId",
            "valueInteger",
            "valuePositiveInt",
            "valueString",
            "valueTime",
            "valueUnsignedInt",
            "valueUri",
            "valueUrl",
        ],
        extension_depth: int = 0,
        max_extension_depth: Optional[int] = 2,
    ) -> Union[StructType, DataType]:
        """
        Representation of the content produced in a DICOM imaging study. A study
        comprises a set of series, each of which includes a set of Service-Object Pair
        Instances (SOP Instances - images or other data) acquired or produced in a
        common context.  A series is of only one modality (e.g. X-ray, CT, MR,
        ultrasound), but a study may have multiple series of different modalities.


        id: unique id for the element within a resource (for internal references). This
            may be any string value that does not contain spaces.

        extension: May be used to represent additional information that is not part of the basic
            definition of the element. In order to make the use of extensions safe and
            manageable, there is a strict set of governance  applied to the definition and
            use of extensions. Though any implementer is allowed to define an extension,
            there is a set of requirements that SHALL be met as part of the definition of
            the extension.

        uid: Formal identifier for this series.

        number: The numeric identifier of this series in the study.

        modality: The modality of this series sequence.

        description: A description of the series.

        numberOfInstances: Number of SOP Instances in the Study. The value given may be larger than the
            number of instance elements this resource contains due to resource
            availability, security, or other factors. This element should be present if
            any instance elements are present.

        availability: Availability of series (online, offline or nearline).

        endpoint: The network service providing access (e.g., query, view, or retrieval) for
            this series. See implementation notes for information about using DICOM
            endpoints. A series-level endpoint, if present, has precedence over a study-
            level endpoint with the same Endpoint.type.

        bodySite: The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema
            .org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to
            SNOMED-CT mappings. The bodySite may indicate the laterality of body part
            imaged; if so, it shall be consistent with any content of
            ImagingStudy.series.laterality.

        laterality: The laterality of the (possibly paired) anatomic structures examined. E.g.,
            the left knee, both lungs, or unpaired abdomen. If present, shall be
            consistent with any laterality information indicated in
            ImagingStudy.series.bodySite.

        started: The date and time the series was started.

        performer: The physician or operator (often the radiology technician)  who performed the
            series. The performer is recorded at the series level, since each series in a
            study may be performed by a different practitioner, at different times, and
            using different devices. A series may be performed by multiple practitioners.

        instance: A single SOP instance within the series, e.g. an image, or presentation state.

        """
        from spark_fhir_schemas.stu3.complex_types.extension import ExtensionSchema
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.imagingstudy_instance import (
            ImagingStudy_InstanceSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("ImagingStudy_Series") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImagingStudy_Series"]
        schema = StructType(
            [
                # unique id for the element within a resource (for internal references). This
                # may be any string value that does not contain spaces.
                StructField("id", StringType(), True),
                # May be used to represent additional information that is not part of the basic
                # definition of the element. In order to make the use of extensions safe and
                # manageable, there is a strict set of governance  applied to the definition and
                # use of extensions. Though any implementer is allowed to define an extension,
                # there is a set of requirements that SHALL be met as part of the definition of
                # the extension.
                StructField(
                    "extension",
                    ArrayType(
                        ExtensionSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # Formal identifier for this series.
                StructField("uid", StringType(), True),
                # The numeric identifier of this series in the study.
                StructField("number", IntegerType(), True),
                # The modality of this series sequence.
                StructField(
                    "modality",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # A description of the series.
                StructField("description", StringType(), True),
                # Number of SOP Instances in the Study. The value given may be larger than the
                # number of instance elements this resource contains due to resource
                # availability, security, or other factors. This element should be present if
                # any instance elements are present.
                StructField("numberOfInstances", IntegerType(), True),
                # Availability of series (online, offline or nearline).
                StructField("availability", StringType(), True),
                # The network service providing access (e.g., query, view, or retrieval) for
                # this series. See implementation notes for information about using DICOM
                # endpoints. A series-level endpoint, if present, has precedence over a study-
                # level endpoint with the same Endpoint.type.
                StructField(
                    "endpoint",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # The anatomic structures examined. See DICOM Part 16 Annex L (http://dicom.nema
                # .org/medical/dicom/current/output/chtml/part16/chapter_L.html) for DICOM to
                # SNOMED-CT mappings. The bodySite may indicate the laterality of body part
                # imaged; if so, it shall be consistent with any content of
                # ImagingStudy.series.laterality.
                StructField(
                    "bodySite",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The laterality of the (possibly paired) anatomic structures examined. E.g.,
                # the left knee, both lungs, or unpaired abdomen. If present, shall be
                # consistent with any laterality information indicated in
                # ImagingStudy.series.bodySite.
                StructField(
                    "laterality",
                    CodingSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                        extension_fields=extension_fields,
                        extension_depth=extension_depth,
                        max_extension_depth=max_extension_depth,
                    ),
                    True,
                ),
                # The date and time the series was started.
                StructField("started", StringType(), True),
                # The physician or operator (often the radiology technician)  who performed the
                # series. The performer is recorded at the series level, since each series in a
                # study may be performed by a different practitioner, at different times, and
                # using different devices. A series may be performed by multiple practitioners.
                StructField(
                    "performer",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
                # A single SOP instance within the series, e.g. an image, or presentation state.
                StructField(
                    "instance",
                    ArrayType(
                        ImagingStudy_InstanceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                            extension_fields=extension_fields,
                            extension_depth=extension_depth,
                            max_extension_depth=max_extension_depth,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]

        return schema
