# bivariate_choropleth


<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Usage

### Installation

Install latest from the GitHub
[repository](https://github.com/Parkes2/bivariate_choropleth):

``` sh
$ pip install git+https://github.com/Parkes2/bivariate_choropleth.git
```

or from [conda](https://anaconda.org/Parkes2/bivariate_choropleth)

``` sh
$ conda install -c Parkes2 bivariate_choropleth
```

or from [pypi](https://pypi.org/project/bivariate_choropleth/)

``` sh
$ pip install bivariate_choropleth
```

### Documentation

Documentation can be found hosted on this GitHub
[repository](https://github.com/Parkes2/bivariate_choropleth)’s
[pages](https://Parkes2.github.io/bivariate_choropleth/). Additionally
you can find package manager specific guidelines on
[conda](https://anaconda.org/Parkes2/bivariate_choropleth) and
[pypi](https://pypi.org/project/bivariate_choropleth/) respectively.

## How to use

### Choose a palette for your legend

default GridPalette is a 3x3 grid with the blues2reds palette.

Use `GridPalette.from_dropdown` to get an interactive widget with the
premade palettes. See `nbs/01_grid_palette` for more options for
selecting grid palettes

``` python
gp = BivariateGridPalette.from_dropdown()
```

    interactive(children=(Dropdown(description='name', options=('blues2reds', 'purple2gold', 'purple2cyan', 'green…

## An example using a geodatasets dataset

``` python
import geodatasets
```

``` python
geodatasets.data.geoda.atlanta.url
```

    'https://geodacenter.github.io/data-and-lab//data/atlanta_hom.zip'

### `bivariate_choropleth.shapefiles` has some functions for using

``` python
from bivariate_choropleth.shapefiles import *
```

use
[`download_and_unzip`](https://Parkes2.github.io/bivariate_choropleth/shapefiles.html#download_and_unzip)
to download from the url above. The directory and filename are entered
as separate arguments

``` python
download_and_unzip(r"https://geodacenter.github.io/data-and-lab//data/",'atlanta_hom.zip')
```

    atlanta_hom.zip already exists, do you want to overwrite y/n? n

calling
[`load_gdf()`](https://Parkes2.github.io/bivariate_choropleth/shapefiles.html#load_gdf)
with no arguments will show a list of folders in the location of
`SHAPE_FILES_PATH` (`User/Documents/SHP_FILES`)

``` python
load_gdf()
```

    Available shapefiles are:  atlanta_hom atlanta_hom LSOA_2021_BOUNDARIES_V4 ca_state ca_counties ca_places

``` python
atlanta = load_gdf('atlanta_hom')
```

``` python
from bivariate_choropleth.plotting import *
```

call `plot_bivariate_choropleth(gdf, x_col_name, y_col_name)` to plot a
bivariate choropleth

``` python
ax, cax = plot_bivariate_choropleth(atlanta, x='PE87', y='HR8995')
```

![](index_files/figure-commonmark/cell-10-output-1.png)

the `grid_size` can be changed if you want more ranks in your data.

`ax, cax` is returned so that the plot can be manipulated

``` python
ax, cax = plot_bivariate_choropleth(atlanta, x='PE87', y='HR8995', grid_size=5, palette_name='purple2gold')
ax.set_title('Police Expenditure and Homicide Rates in Atlanta Counties')
ax.set_axis_off()
cax.set_xlabel('Police Expenditure 1987', fontsize=5)
cax.set_ylabel('Homicide Rate 89-95', fontsize=5);
```

![](index_files/figure-commonmark/cell-11-output-1.png)
