from typing import Tuple, List, Union, Optional, Dict, MutableSet

ColorInput = Union[Tuple[int, int, int], List[int, int, int], str]
ColorOutput = Tuple[int, int, int]

def get_pixel(x: int, y: int) -> ColorOutput: ...
def set_pixel(x: int, y: int, color: ColorInput) -> None: ...
def color(color: ColorInput) -> ColorOutput: ...
def color(r: int, g: int, b: int) -> ColorOutput: ...
def draw_string(text: str, x: int, y: int, color: Optional[ColorInput]=(0, 0, 0), 
                background: Optional[ColorInput]=(248, 252, 248), font: bool=False) -> None: ...
def fill_rect(x: int, y: int, width: int, height: int, color: ColorInput) -> None: ...

# Special method, only in pc
def quit() -> None: ...

# Methods for other os
def draw_line(x1: int, y1: int, x2: int, y2: int, color: ColorInput) -> None: ...
def wait_vblank() -> None: ...
def get_keys() -> MutableSet[str]: ...
small_font: bool = ...
large_font: bool = ...
def draw_circle(x: int, y: int, r: int, color: ColorInput) -> None: ...
def fill_circle(x: int, y: int, r: int, color: ColorInput) -> None: ...
def fill_polygon(points: List[Tuple[int, int]], color: ColorInput) -> None: ...
def get_palette() -> Dict[str, ColorOutput]: ...
