import copy
import os
import shutil

import grass.script as grass
import grass.script.setup as gsetup
import numpy as np
import pandas as pd
import pytest
from grass.pygrass.modules import Module
from grass.pygrass.modules.shortcuts import general as g
from grass.pygrass.modules.shortcuts import raster as r
from grass.script import array as garray
from grass_session import Session
from simpledbf import Dbf5

from processing_functions_attribute_table import Evaluate_Two_Dataframes
from ToolboxClass import LRRT
from utilities import Dbf_To_Dataframe

os.environ.update(
    dict(GRASS_COMPRESS_NULLS="1", GRASS_COMPRESSOR="ZSTD", GRASS_VERBOSE="1")
)


def Return_Raster_As_Array(grassdb, grass_location, raster_mn):
    """Transfer an rater in grass database into np array
    Parameters
    ----------
    grassdb         : string
    Full path to a grass database
    grass_location  : string
    location name in that grass database
    raster_mn       : string
    raster name

    Returns:
    -------
    Array            : array
    np array of the raster.

    """
    PERMANENT = Session()
    PERMANENT.open(gisdb=grassdb, location=grass_location, create_opts="")
    Array = copy.deepcopy(garray.array(mapname=raster_mn))
    PERMANENT.close()
    return Array


def test_RoutingNetworkTopologyUpdateToolset_riv():
    """test function that will:
    Calculate hydrological paramters for each subbasin generated by
    "AutomatedWatershedsandLakesFilterToolset". The result generaed
    by this tool can be used as inputs for Define_Final_Catchment
    and other post processing tools
    """

    ###Floder where store the inputs for tests function
    Data_Folder = "./testdata/Required_data_to_start_from_dem/"

    ###Folder where store the expected resuts
    Final_Result_Folder_Expected = os.path.join(
        "./testdata", "Final_output_folder", "Expected_InDEM"
    )
    Temporary_Result_Folder_Expected = os.path.join(
        "./testdata", "Temporary_output_folder", "Expected_InDEM"
    )

    ###Folder where the output will be generated
    Temporary_Result_Folder_Result = os.path.join(
        "./testdata", "Temporary_output_folder", "testout4"
    )
    Final_Result_Folder_Result = os.path.join(
        "./testdata", "Final_output_folder", "testout4"
    )
    #    shutil.rmtree(Temporary_Result_Folder_Result,ignore_errors=True)

    ###The pathes for all inputs
    Path_DEM_big = os.path.join(Data_Folder, "DEM_big_merit.tif")
    Path_DEM_small = os.path.join(Data_Folder, "DEM_samll_merit.tif")
    Path_Lake_ply = os.path.join(Data_Folder, "HyLake.shp")
    Path_bkf_wd = os.path.join(Data_Folder, "Bkfullwidth_depth.shp")
    Path_Landuse = os.path.join(Data_Folder, "landuse.tif")
    Path_Roughness_landuse = os.path.join(Data_Folder, "Landuse_info.csv")

    ###Generate test resuts, for option 1
    RTtool = LRRT(
        dem_in=Path_DEM_small,
        WidDep=Path_bkf_wd,
        Lakefile=Path_Lake_ply,
        Landuse=Path_Landuse,
        Landuseinfo=Path_Roughness_landuse,
        OutputFolder=Final_Result_Folder_Result,
        TempOutFolder=Temporary_Result_Folder_Result,
    )
    ### test using extent of input dem as processing extent
    RTtool.Generatmaskregion()
    RTtool.Generateinputdata()
    RTtool.WatershedDiscretizationToolset(accthresold=500)
    RTtool.AutomatedWatershedsandLakesFilterToolset(
        Thre_Lake_Area_Connect=0, Thre_Lake_Area_nonConnect=0
    )
    RTtool.RoutingNetworkTopologyUpdateToolset_riv(projection="EPSG:3573")

    """Evaluate result attribute table of result polygon,polylie, and two 
       lake polygons      
    """

    ### transfer expected siplified product into pandas dataframe
    Expect_Finalriv_info_ply = Dbf_To_Dataframe(
        os.path.join(Final_Result_Folder_Expected, "finalriv_info_ply.shp")
    ).sort_values(by=["SubId"])
    Result_Finalriv_info_ply = Dbf_To_Dataframe(
        os.path.join(Final_Result_Folder_Result, "finalriv_info_ply.shp")
    ).sort_values(by=["SubId"])

    assert Evaluate_Two_Dataframes(
        Result_Finalriv_info_ply, Expect_Finalriv_info_ply, Check_Col_NM="SubId"
    )

    """Evaluate lake polygon files 
    Con_Lake_Ply is the lake polygon that connected by river network 
    Non_Con_Lake_Ply is the lake polygon that did not connected by 
    river network 
    """
    ### transfer expected siplified connected lake polygon  into pandas dataframe Expect_Con_Lake_Ply
    Expect_Con_Lake_Ply = Dbf_To_Dataframe(
        os.path.join(Expect_Result_Folder, "Con_Lake_Ply.shp")
    ).sort_values(by=["Hylak_id"])
    ### transfer expected siplified non connected lake polygon  into pandas dataframe Expect_Non_Con_Lake_Ply
    Expect_Non_Con_Lake_Ply = Dbf_To_Dataframe(
        os.path.join(Expect_Result_Folder, "Non_Con_Lake_Ply.shp")
    ).sort_values(by=["Hylak_id"])

    ### transfer resulted siplified connected lake polygon  into pandas dataframe Result_Con_Lake_Ply
    Result_Con_Lake_Ply = Dbf_To_Dataframe(
        os.path.join(Output_Folder, "Con_Lake_Ply.shp")
    ).sort_values(by=["Hylak_id"])
    ### transfer resulted siplified non connected lake polygon  into pandas dataframe Result_Non_Con_Lake_Ply
    Result_Non_Con_Lake_Ply = Dbf_To_Dataframe(
        os.path.join(Output_Folder, "Non_Con_Lake_Ply.shp")
    ).sort_values(by=["Hylak_id"])

    ### compare two pandas dataframe Expect_Con_Lake_Ply and Result_Con_Lake_Ply
    assert Evaluate_Two_Dataframes(
        Expect_Con_Lake_Ply, Result_Con_Lake_Ply, Check_Col_NM="Hylak_id"
    )
    ### compare two pandas dataframe Expect_Non_Con_Lake_Ply and Result_Non_Con_Lake_Ply
    assert Evaluate_Two_Dataframes(
        Expect_Non_Con_Lake_Ply, Result_Non_Con_Lake_Ply, Check_Col_NM="Hylak_id"
    )
    RTtool.Output_Clean()
