/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import java.lang.reflect.InvocationHandler;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.util.Collection;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.jeri.AbstractILFactory;
import net.jini.jeri.BasicInvocationDispatcher;
import net.jini.jeri.BasicInvocationHandler;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.ServerCapabilities;
import net.jini.security.proxytrust.TrustEquivalence;

public class BasicILFactory
extends AbstractILFactory {
    private final MethodConstraints serverConstraints;
    private final Class permissionClass;

    public BasicILFactory() {
        this.serverConstraints = null;
        this.permissionClass = null;
    }

    public BasicILFactory(MethodConstraints serverConstraints, Class permissionClass) {
        this(serverConstraints, permissionClass, null);
    }

    public BasicILFactory(MethodConstraints serverConstraints, Class permissionClass, ClassLoader loader) {
        super(loader);
        BasicInvocationDispatcher.checkPermissionClass(permissionClass);
        this.serverConstraints = serverConstraints;
        this.permissionClass = permissionClass;
    }

    protected InvocationHandler createInvocationHandler(Class[] interfaces, Remote impl, ObjectEndpoint oe) throws ExportException {
        int i = interfaces.length;
        while (--i >= 0) {
            if (interfaces[i] != null) continue;
            throw new NullPointerException();
        }
        if (impl == null) {
            throw new NullPointerException();
        }
        return new BasicInvocationHandler(oe, this.serverConstraints);
    }

    protected Class[] getExtraProxyInterfaces(Remote impl) {
        if (impl == null) {
            throw new NullPointerException();
        }
        return new Class[]{RemoteMethodControl.class, TrustEquivalence.class};
    }

    protected InvocationDispatcher createInvocationDispatcher(Collection methods, Remote impl, ServerCapabilities caps) throws ExportException {
        if (impl == null) {
            throw new NullPointerException("impl is null");
        }
        return new BasicInvocationDispatcher(methods, caps, this.serverConstraints, this.permissionClass, this.getClassLoader());
    }

    public final MethodConstraints getServerConstraints() {
        return this.serverConstraints;
    }

    public final Class getPermissionClass() {
        return this.permissionClass;
    }

    public int hashCode() {
        int h = super.hashCode();
        if (this.serverConstraints != null) {
            h += this.serverConstraints.hashCode();
        }
        if (this.permissionClass != null) {
            h += this.permissionClass.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        BasicILFactory ilf = (BasicILFactory)obj;
        return this.permissionClass == ilf.permissionClass && (this.serverConstraints == ilf.serverConstraints || this.serverConstraints != null && this.serverConstraints.equals(ilf.serverConstraints));
    }

    public String toString() {
        return super.toString() + "[" + this.serverConstraints + (this.permissionClass != null ? ", " + this.permissionClass.getName() : "") + "]";
    }
}

