/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.datum.Ellipsoid;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.Geocentric2Geographic;
import org.cts.op.NonInvertibleOperationException;

public class Geographic2Geocentric
extends AbstractCoordinateOperation {
    private static final Identifier opId = new Identifier("EPSG", "9602", "Geographic to geocentric conversion", "Geographic to geocentric");
    private final Ellipsoid ellipsoid;
    private final double epsilon;

    public Geographic2Geocentric(Ellipsoid ellipsoid) {
        super(opId);
        this.ellipsoid = ellipsoid;
        this.precision = 1.0E-4;
        this.epsilon = 1.0E-11;
    }

    public Geographic2Geocentric(Ellipsoid ellipsoid, double epsilon) {
        super(opId);
        this.ellipsoid = ellipsoid;
        this.precision = 1.0E-4;
        this.epsilon = epsilon;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (coord.length < 2) {
            throw new CoordinateDimensionException(coord, 3);
        }
        if (coord.length == 2) {
            coord = new double[]{coord[0], coord[1], 0.0};
        }
        double lat = coord[0];
        double lon = coord[1];
        double height = 0.0;
        if (coord.length > 2 && !Double.isNaN(coord[2])) {
            height = coord[2];
        }
        double N = this.ellipsoid.transverseRadiusOfCurvature(lat);
        coord[0] = (N + height) * Math.cos(lat) * Math.cos(lon);
        coord[1] = (N + height) * Math.cos(lat) * Math.sin(lon);
        coord[2] = (N * (1.0 - this.ellipsoid.getSquareEccentricity()) + height) * Math.sin(lat);
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return new Geocentric2Geographic(this.ellipsoid, this.epsilon);
    }

    public String toString() {
        return this.getName() + " (" + this.ellipsoid.getName() + ")";
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Geographic2Geocentric) {
            Geographic2Geocentric gg2gc = (Geographic2Geocentric)o;
            return this.getEllipsoid().equals(gg2gc.getEllipsoid());
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + (this.ellipsoid != null ? this.ellipsoid.hashCode() : 0);
        return hash;
    }
}

