/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.dlsyntax.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.semanticweb.owlapi.dlsyntax.parser.DLSyntaxParser;
import org.semanticweb.owlapi.dlsyntax.parser.ParseException;
import org.semanticweb.owlapi.dlsyntax.parser.StreamProvider;
import org.semanticweb.owlapi.formats.DLSyntaxHTMLDocumentFormat;
import org.semanticweb.owlapi.formats.DLSyntaxHTMLDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class DLSyntaxOWLParser
extends AbstractOWLParser {
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new DLSyntaxHTMLDocumentFormatFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OWLDocumentFormat parse(OWLOntologyDocumentSource source, OWLOntology ontology, OWLOntologyLoaderConfiguration config) {
        try (Reader r = DocumentSources.wrapInputAsReader((OWLOntologyDocumentSource)source, (OWLOntologyLoaderConfiguration)config);){
            DLSyntaxParser parser = new DLSyntaxParser(new StreamProvider(r));
            parser.setOWLDataFactory(ontology.getOWLOntologyManager().getOWLDataFactory());
            Set<OWLAxiom> set = parser.parseAxioms();
            ontology.add(set);
            DLSyntaxHTMLDocumentFormat dLSyntaxHTMLDocumentFormat = new DLSyntaxHTMLDocumentFormat();
            return dLSyntaxHTMLDocumentFormat;
        }
        catch (IOException | ParseException | OWLOntologyInputSourceException e) {
            throw new OWLParserException(((Throwable)e).getMessage(), (Throwable)e);
        }
    }
}

