/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.coode.owlapi.obo12.parser.AbstractTagValueHandler;
import org.coode.owlapi.obo12.parser.OBOConsumer;
import org.coode.owlapi.obo12.parser.OBOVocabulary;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntologyChange;

class RelationshipTagValueHandler
extends AbstractTagValueHandler {
    private final Pattern tagValuePattern = Pattern.compile("([^\\s]*)\\s*([^\\s]*)\\s*(\\{([^\\}]*)\\})?");

    public RelationshipTagValueHandler(OBOConsumer consumer) {
        super(OBOVocabulary.RELATIONSHIP.getName(), consumer);
    }

    @Override
    public void handle(String currentId, String value, String qualifierBlock, String comment) {
        Matcher matcher = this.tagValuePattern.matcher(value);
        if (matcher.matches()) {
            IRI propIRI = this.getConsumer().getRelationIRIFromSymbolicIdOrOBOId(matcher.group(1));
            IRI fillerIRI = this.getIRIFromOBOId(matcher.group(2));
            OWLObjectProperty prop = this.getDataFactory().getOWLObjectProperty(propIRI);
            OWLClass filler = this.getDataFactory().getOWLClass(fillerIRI);
            OWLObjectSomeValuesFrom restriction = this.getDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)prop, (OWLClassExpression)filler);
            OWLClass subCls = this.getDataFactory().getOWLClass(this.getIRIFromOBOId(currentId));
            this.applyChange((OWLOntologyChange)new AddAxiom(this.getOntology(), (OWLAxiom)this.getDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)subCls, (OWLClassExpression)restriction)));
            this.applyChange((OWLOntologyChange)new AddAxiom(this.getOntology(), (OWLAxiom)this.getDataFactory().getOWLDeclarationAxiom((OWLEntity)prop)));
        }
    }
}

