/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.service.ndx.pipeline;

import com.bigdata.btree.keys.KVO;
import com.bigdata.service.ndx.pipeline.IDuplicateRemover;
import com.bigdata.service.ndx.pipeline.KVOList;
import com.bigdata.util.BytesUtil;

public class DefaultDuplicateRemover<O>
implements IDuplicateRemover<O> {
    private final boolean testRefs;
    public static final transient IDuplicateRemover KEY_VAL = new DefaultDuplicateRemover(false);
    public static final transient IDuplicateRemover KEY_REF_VAL = new DefaultDuplicateRemover(false);

    public DefaultDuplicateRemover(boolean testRefs) {
        this.testRefs = testRefs;
    }

    @Override
    public KVO<O>[] filter(KVO<O>[] src) {
        KVO[] tmp = new KVO[src.length];
        int ndistinct = 0;
        KVO<O> prior = null;
        for (KVO<O> other : src) {
            if (prior != null && this.filterDuplicate(prior, other)) continue;
            tmp[ndistinct++] = prior = other;
        }
        return KVO.dense(tmp, ndistinct);
    }

    protected boolean filterDuplicate(KVO<O> prior, KVO<O> other) {
        if (BytesUtil.bytesEqual((byte[])prior.key, (byte[])other.key) && (this.testRefs && prior.obj != null && prior.obj == other.obj || BytesUtil.bytesEqual((byte[])prior.val, (byte[])other.val))) {
            if (prior instanceof KVOList) {
                ((KVOList)prior).add(other);
            }
            return true;
        }
        return false;
    }
}

