/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.search;

import com.bigdata.search.IHit;
import org.apache.log4j.Logger;

public class Hit<V extends Comparable<V>>
implements IHit<V>,
Comparable<Hit<V>> {
    private static final transient Logger log = Logger.getLogger(Hit.class);
    private V docId = null;
    private final boolean[] searchTerms;
    private double cosine;
    private int rank;

    Hit(int numSearchTerms) {
        this.searchTerms = new boolean[numSearchTerms];
    }

    synchronized void setDocId(V docId) {
        if (docId == null) {
            throw new IllegalArgumentException();
        }
        this.docId = docId;
    }

    synchronized void setRank(int rank) {
        this.rank = rank;
    }

    public synchronized int getTermCount() {
        if (this.searchTerms.length == 0) {
            return 0;
        }
        int nterms = 0;
        for (boolean b : this.searchTerms) {
            if (!b) continue;
            ++nterms;
        }
        return nterms;
    }

    @Override
    public synchronized double getCosine() {
        return this.cosine;
    }

    @Override
    public synchronized int getRank() {
        return this.rank;
    }

    @Override
    public synchronized V getDocId() {
        return this.docId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int termNdx, double weight) {
        Hit hit = this;
        synchronized (hit) {
            this.cosine += weight;
            this.searchTerms[termNdx] = true;
        }
    }

    public String toString() {
        return "Hit{docId" + this.docId + ",nterms=" + this.getTermCount() + ",cosine=" + this.cosine + "}";
    }

    @Override
    public int compareTo(Hit<V> o) {
        if (this.cosine < o.cosine) {
            return 1;
        }
        if (this.cosine > o.cosine) {
            return -1;
        }
        return this.docId.compareTo(o.docId);
    }
}

