/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rwstore.sector;

import com.bigdata.rwstore.sector.IMemoryManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;

public class PSInputStream
extends InputStream {
    private static final Logger log = Logger.getLogger(PSInputStream.class);
    final ByteBuffer[] m_buffers;
    int m_index = 0;
    int m_cursor = 0;

    public PSInputStream(IMemoryManager mm, long addr) {
        int sze = mm.allocationSize(addr);
        if (sze > 4096) {
            ByteBuffer[] block;
            int buffers = 1 + (sze - 1) / 4096;
            this.m_buffers = new ByteBuffer[buffers];
            ByteBuffer[] hdr = mm.get((addr & 0xFFFFFFFF00000000L) + (long)((buffers + 1) * 4));
            int rem = sze;
            int hdrsze = hdr[0].getInt();
            if (hdrsze != buffers) {
                throw new IllegalStateException("Check blob header assumptions: hdrsize(" + hdrsze + ") != buffers(" + buffers + ")");
            }
            int totalRemaining = 0;
            for (ByteBuffer hbuf : hdr) {
                totalRemaining += hbuf.remaining();
            }
            if (totalRemaining != buffers * 4) {
                throw new IllegalStateException("Check blob header assumptions, remaining: " + totalRemaining + " for " + buffers + " buffers");
            }
            int index = 0;
            int hdrIndex = 0;
            while (rem > 4096) {
                long ba = hdr[hdrIndex].getInt();
                block = mm.get((ba <<= 32) + 4096L);
                this.m_buffers[index++] = block[0];
                rem -= 4096;
                if (hdr[hdrIndex].remaining() != 0) continue;
                ++hdrIndex;
            }
            if (rem > 0) {
                long ba = hdr[hdrIndex].getInt();
                block = mm.get((ba <<= 32) + (long)rem);
                this.m_buffers[index] = block[0];
            }
        } else {
            this.m_buffers = sze == 0 ? new ByteBuffer[0] : mm.get(addr);
        }
    }

    @Override
    public int read() throws IOException {
        if (this.m_index >= this.m_buffers.length) {
            return -1;
        }
        ByteBuffer buf = this.m_buffers[this.m_index];
        int rem = buf.remaining();
        assert (rem > 0);
        if (rem == 1) {
            ++this.m_index;
        }
        return 0xFF & buf.get();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.m_index >= this.m_buffers.length) {
            return -1;
        }
        ByteBuffer buf = this.m_buffers[this.m_index];
        int rem = buf.remaining();
        int retlen = 0;
        while (len > rem) {
            buf.get(b, off, rem);
            retlen += rem;
            off += rem;
            len -= rem;
            if (++this.m_index == this.m_buffers.length) {
                return retlen;
            }
            buf = this.m_buffers[this.m_index];
            rem = buf.remaining();
        }
        if (len > 0) {
            buf.get(b, off, len);
            retlen += len;
            if ((rem -= len) == 0) {
                ++this.m_index;
            }
        }
        return retlen;
    }
}

