/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.relation.rule.eval.pipeline;

import com.bigdata.relation.accesspath.IAsynchronousIterator;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.relation.rule.IRule;
import com.bigdata.relation.rule.eval.IJoinNexus;
import com.bigdata.relation.rule.eval.ISolution;
import com.bigdata.relation.rule.eval.pipeline.JoinMasterTask;
import com.bigdata.relation.rule.eval.pipeline.LocalJoinTask;
import com.bigdata.service.IBigdataFederation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class LocalJoinMasterTask
extends JoinMasterTask {
    public LocalJoinMasterTask(IRule rule, IJoinNexus joinNexus, IBuffer<ISolution[]> buffer) {
        super(rule, joinNexus, buffer);
        if (joinNexus.getIndexManager() instanceof IBigdataFederation && ((IBigdataFederation)joinNexus.getIndexManager()).isScaleOut()) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected List<Future<Void>> start() throws Exception {
        IAsynchronousIterator[] sources = new IAsynchronousIterator[this.tailCount];
        sources[0] = this.newBindingSetIterator(this.joinNexus.newBindingSet(this.rule));
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>(this.tailCount);
        LocalJoinTask priorJoinTask = null;
        for (int orderIndex = 0; orderIndex < this.tailCount; ++orderIndex) {
            boolean lastJoin = orderIndex + 1 == this.tailCount;
            IAsynchronousIterator iAsynchronousIterator = sources[orderIndex];
            assert (iAsynchronousIterator != null) : "No source: orderIndex=" + orderIndex + ", tailCount=" + this.tailCount + ", rule=" + this.rule;
            LocalJoinTask joinTask = new LocalJoinTask(this.rule, this.joinNexus, this.order, orderIndex, this, this.masterUUID, iAsynchronousIterator, this.getSolutionBuffer(), this.ruleState.getRequiredVars());
            if (!lastJoin) {
                sources[orderIndex + 1] = joinTask.syncBuffer.iterator();
            }
            FutureTask<Void> ft = new FutureTask<Void>(joinTask);
            futures.add(ft);
            if (!lastJoin) {
                joinTask.syncBuffer.setFuture(ft);
            }
            if (priorJoinTask != null) {
                priorJoinTask.setSinkFuture(ft);
            }
            priorJoinTask = joinTask;
        }
        ExecutorService executorService = this.joinNexus.getIndexManager().getExecutorService();
        for (Future future : futures) {
            executorService.execute((FutureTask)future);
        }
        return futures;
    }
}

