/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.store.AbstractLocalTripleStore;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.locator.DefaultResourceLocator;
import com.bigdata.util.PropertyUtil;
import java.util.Enumeration;
import java.util.Properties;
import java.util.UUID;
import org.apache.log4j.Logger;

public class TempTripleStore
extends AbstractLocalTripleStore {
    private static final Logger log = Logger.getLogger(TempTripleStore.class);
    private final TemporaryStore store;

    @Override
    public TemporaryStore getIndexManager() {
        return this.store;
    }

    @Override
    public final long commit() {
        return super.commit();
    }

    @Override
    public final void abort() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final boolean isStable() {
        return this.store.isStable();
    }

    @Override
    public final void close() {
        this.destroy();
        super.close();
    }

    public TempTripleStore(Properties properties) {
        this(properties, null);
    }

    public TempTripleStore(Properties properties, AbstractTripleStore db) {
        this(new TemporaryStore(), properties, db);
    }

    public TempTripleStore(TemporaryStore store, Properties properties, AbstractTripleStore db) {
        this(store, db == null ? properties : TempTripleStore.stackProperties(properties, store, db));
        if (log.isInfoEnabled()) {
            log.info((Object)("new temporary store: " + store.getFile() + ", namespace=" + this.getNamespace()));
        }
        if (db != null) {
            ((DefaultResourceLocator)db.getIndexManager().getResourceLocator()).add(store);
        }
        this.create();
    }

    private TempTripleStore(TemporaryStore store, Properties properties) {
        this(store, UUID.randomUUID() + "kb", 0L, properties);
    }

    public TempTripleStore(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(indexManager, namespace, timestamp, properties);
        this.store = (TemporaryStore)indexManager;
        if (log.isInfoEnabled()) {
            log.info((Object)("view on existing temporary store: " + this.store.getUUID()));
        }
    }

    private static Properties stackProperties(Properties properties, TemporaryStore tempStore, AbstractTripleStore db) {
        Properties out = new Properties();
        Properties in = PropertyUtil.flatCopy((Properties)properties);
        Enumeration<Object> e = in.keys();
        while (e.hasMoreElements()) {
            Object ekey = e.nextElement();
            if (!(ekey instanceof String)) continue;
            String key = (String)ekey;
            String val = in.getProperty(key);
            if (BigdataSail.Options.NAMESPACE.equals(key)) {
                out.setProperty(key, val + "_temporaryStore=" + tempStore.getUUID());
                continue;
            }
            out.setProperty(key, val);
        }
        return out;
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    public static interface Options
    extends AbstractTripleStore.Options {
    }
}

