/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.store;

import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.Var;
import com.bigdata.bop.bindingSet.ListBindingSet;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.striterator.AbstractChunkedResolverator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.openrdf.model.Value;
import org.openrdf.query.Binding;
import org.openrdf.query.BindingSet;

public class BigdataOpenRDFBindingSetsResolverator
extends AbstractChunkedResolverator<BindingSet, IBindingSet, AbstractTripleStore> {
    private static final Logger log = Logger.getLogger(BigdataOpenRDFBindingSetsResolverator.class);

    public BigdataOpenRDFBindingSetsResolverator(AbstractTripleStore db, IChunkedOrderedIterator<BindingSet> src) {
        super(db, src, new BlockingBuffer<F[]>(db.getChunkOfChunksCapacity(), db.getChunkCapacity(), db.getChunkTimeout(), TimeUnit.MILLISECONDS));
    }

    public BigdataOpenRDFBindingSetsResolverator start(ExecutorService service) {
        return (BigdataOpenRDFBindingSetsResolverator)super.start(service);
    }

    protected IBindingSet[] resolveChunk(BindingSet[] chunk) {
        return BigdataOpenRDFBindingSetsResolverator.resolveChunk(((AbstractTripleStore)this.state).getLexiconRelation(), chunk);
    }

    public static IBindingSet[] resolveChunk(LexiconRelation r, BindingSet[] chunk) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Fetched chunk: size=" + chunk.length));
        }
        int initialCapacity = chunk.length;
        LinkedHashSet<Value> valueSet = new LinkedHashSet<Value>(initialCapacity);
        for (BindingSet bindingSet : chunk) {
            for (Binding binding : bindingSet) {
                Value value = binding.getValue();
                if (value == null) continue;
                valueSet.add(value);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Resolving " + valueSet.size() + " term identifiers"));
        }
        BigdataValueFactory vf = r.getValueFactory();
        int nvalues = valueSet.size();
        BigdataValue[] values = new BigdataValue[nvalues];
        LinkedHashMap<Value, BigdataValue> map = new LinkedHashMap<Value, BigdataValue>(nvalues);
        int i = 0;
        for (Value value : valueSet) {
            BigdataValue val = vf.asValue(value);
            map.put(value, val);
            values[i++] = val;
        }
        r.addTerms(values, nvalues, true);
        IBindingSet[] chunk2 = new IBindingSet[chunk.length];
        int i2 = 0;
        for (BindingSet e : chunk) {
            IBindingSet f = BigdataOpenRDFBindingSetsResolverator.getBindingSet(e, map);
            chunk2[i2++] = f;
        }
        return chunk2;
    }

    private static IBindingSet getBindingSet(BindingSet bindingSet, Map<Value, BigdataValue> map) {
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        if (map == null) {
            throw new IllegalArgumentException();
        }
        ListBindingSet out = new ListBindingSet();
        for (Binding binding : bindingSet) {
            String name = binding.getName();
            Value value = binding.getValue();
            BigdataValue outVal = map.get(value);
            assert (outVal != null);
            if (outVal.getIV() == null) {
                TermId<?> dummy = TermId.mockIV(VTE.valueOf(outVal));
                outVal.setIV(dummy);
            }
            IV iv = outVal.getIV();
            iv.setValue(outVal);
            Constant<IV> c = new Constant<IV>(iv);
            out.set(Var.var(name), c);
        }
        return out;
    }
}

