/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.quorum.Quorum;
import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.axioms.NoAxioms;
import com.bigdata.rdf.axioms.OwlAxioms;
import com.bigdata.rdf.axioms.RdfsAxioms;
import com.bigdata.rdf.sail.BigdataSail;
import com.bigdata.rdf.sail.webapp.IFeatureSupported;
import com.bigdata.rdf.sail.webapp.VoID;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.util.ClassPathUtil;
import java.util.Properties;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.URIImpl;
import org.openrdf.model.vocabulary.RDF;

public class SD {
    public static final String NS = "http://www.w3.org/ns/sparql-service-description#";
    public static final URI Service = new URIImpl("http://www.w3.org/ns/sparql-service-description#Service");
    public static final URI endpoint = new URIImpl("http://www.w3.org/ns/sparql-service-description#endpoint");
    public static final URI supportedLanguage = new URIImpl("http://www.w3.org/ns/sparql-service-description#supportedLanguage");
    public static final URI SPARQL10Query = new URIImpl("http://www.w3.org/ns/sparql-service-description#SPARQL10Query");
    public static final URI SPARQL11Query = new URIImpl("http://www.w3.org/ns/sparql-service-description#SPARQL11Query");
    public static final URI SPARQL11Update = new URIImpl("http://www.w3.org/ns/sparql-service-description#SPARQL11Update");
    public static final URI resultFormat = new URIImpl("http://www.w3.org/ns/sparql-service-description#resultFormat");
    public static final URI inputFormat = new URIImpl("http://www.w3.org/ns/sparql-service-description#inputFormat");
    public static final URI feature = new URIImpl("http://www.w3.org/ns/sparql-service-description#feature");
    public static final URI DereferencesURIs = new URIImpl("http://www.w3.org/ns/sparql-service-description#DereferencesURIs");
    public static final URI UnionDefaultGraph = new URIImpl("http://www.w3.org/ns/sparql-service-description#UnionDefaultGraph");
    public static final URI RequiresDataset = new URIImpl("http://www.w3.org/ns/sparql-service-description#RequiresDataset");
    public static final URI EmptyGraphs = new URIImpl("http://www.w3.org/ns/sparql-service-description#EmptyGraphs");
    public static final URI BasicFederatedQuery = new URIImpl("http://www.w3.org/ns/sparql-service-description#BasicFederatedQuery");
    public static final String BDFNS = "http://www.bigdata.com/rdf#/features/";
    public static final URI ModeTriples = new URIImpl("http://www.bigdata.com/rdf#/features/KB/Mode/Triples");
    public static final URI ModeQuads = new URIImpl("http://www.bigdata.com/rdf#/features/KB/Mode/Quads");
    public static final URI ModeSids = new URIImpl("http://www.bigdata.com/rdf#/features/KB/Mode/Sids");
    public static final URI TextIndexValueCentric = new URIImpl("http://www.bigdata.com/rdf#/features/KB/TextIndex/ValueCentric");
    public static final URI TextIndexSubjectCentric = new URIImpl("http://www.bigdata.com/rdf#/features/KB/TextIndex/SubjectCentric");
    public static final URI TruthMaintenance = new URIImpl("http://www.bigdata.com/rdf#/features/KB/TruthMaintenance");
    public static final URI IsolatableIndices = new URIImpl("http://www.bigdata.com/rdf#/features/KB/IsolatableIndices");
    public static final URI HighlyAvailable = new URIImpl("http://www.bigdata.com/rdf#/features/HighlyAvailable");
    public static final URI ReplicationFactor = new URIImpl("http://www.bigdata.com/rdf#/features/replicationFactor");
    public static final URI ScaleOut = new URIImpl("http://www.bigdata.com/rdf#/features/ScaleOut");
    public static final URI MapgraphCompatible = new URIImpl("http://www.bigdata.com/rdf#/features/MapgraphCompatible");
    public static final URI MapgraphAcceleration = new URIImpl("http://www.bigdata.com/rdf#/features/MapgraphAcceleration");
    public static final URI KB_NAMESPACE = new URIImpl("http://www.bigdata.com/rdf#/features/KB/Namespace");
    public static final URI defaultEntailmentRegime = new URIImpl("http://www.w3.org/ns/sparql-service-description#defaultEntailmentRegime");
    public static final URI entailmentRegime = new URIImpl("http://www.w3.org/ns/sparql-service-description#entailmentRegime");
    public static final URI supportedEntailmentProfile = new URIImpl("http://www.w3.org/ns/sparql-service-description#supportedEntailmentProfile");
    public static final URI extensionFunction = new URIImpl("http://www.w3.org/ns/sparql-service-description#extensionFunction");
    public static final URI simpleEntailment = new URIImpl("http://www.w3.org/ns/entailment/Simple");
    public static final URI rdfEntailment = new URIImpl("http://www.w3.org/ns/entailment/RDF");
    public static final URI rdfsEntailment = new URIImpl("http://www.w3.org/ns/entailment/RDFS");
    public static final URI Function = new URIImpl("http://www.w3.org/ns/sparql-service-description#Function");
    public static final URI defaultDataset = new URIImpl("http://www.w3.org/ns/sparql-service-description#defaultDataset");
    public static final URI Dataset = new URIImpl("http://www.w3.org/ns/sparql-service-description#Dataset");
    public static final URI defaultGraph = new URIImpl("http://www.w3.org/ns/sparql-service-description#defaultGraph");
    public static final URI Graph = new URIImpl("http://www.w3.org/ns/sparql-service-description#Graph");
    public static final URI namedGraph = new URIImpl("http://www.w3.org/ns/sparql-service-description#namedGraph");
    public static final URI NamedGraph = new URIImpl("http://www.w3.org/ns/sparql-service-description#NamedGraph");
    public static final URI name = new URIImpl("http://www.w3.org/ns/sparql-service-description#name");
    public static final URI RDFXML = new URIImpl("http://www.w3.org/ns/formats/RDF_XML");
    public static final URI NTRIPLES = new URIImpl("http://www.w3.org/ns/formats/N-Triples");
    public static final URI TURTLE = new URIImpl("http://www.w3.org/ns/formats/Turtle");
    public static final URI TURTLE_RDR = new URIImpl("http://www.bigdata.com/ns/formats/Turtle-RDR");
    public static final URI N3 = new URIImpl("http://www.w3.org/ns/formats/N3");
    public static final URI TRIG = new URIImpl("http://www.wiwiss.fu-berlin.de/suhl/bizer/TriG/Spec/");
    public static final URI NQUADS = new URIImpl("http://sw.deri.org/2008/07/n-quads/#n-quads");
    public static final URI NTRIPLES_RDR = new URIImpl("http://www.bigdata.com/ns/formats/N-Triples-RDR");
    public static final URI SPARQL_RESULTS_XML = new URIImpl("http://www.w3.org/ns/formats/SPARQL_Results_XML");
    public static final URI SPARQL_RESULTS_JSON = new URIImpl("http://www.w3.org/ns/formats/SPARQL_Results_JSON");
    public static final URI SPARQL_RESULTS_CSV = new URIImpl("http://www.w3.org/ns/formats/SPARQL_Results_CSV");
    public static final URI SPARQL_RESULTS_TSV = new URIImpl("http://www.w3.org/ns/formats/SPARQL_Results_TSV");
    protected final Graph g;
    protected final AbstractTripleStore tripleStore;
    protected final String[] serviceURI;
    protected final ValueFactory f;
    protected final BNode aService;
    protected final BNode aDefaultDataset;

    public SD(Graph g, AbstractTripleStore tripleStore, String ... serviceURI) {
        if (g == null) {
            throw new IllegalArgumentException();
        }
        if (tripleStore == null) {
            throw new IllegalArgumentException();
        }
        if (serviceURI == null) {
            throw new IllegalArgumentException();
        }
        if (serviceURI.length == 0) {
            throw new IllegalArgumentException();
        }
        for (String s : serviceURI) {
            if (s != null) continue;
            throw new IllegalArgumentException();
        }
        this.g = g;
        this.tripleStore = tripleStore;
        this.serviceURI = serviceURI;
        this.f = g.getValueFactory();
        this.aService = this.f.createBNode("service");
        this.aDefaultDataset = this.f.createBNode("defaultDataset");
    }

    public void describeService(boolean describeStatistics, boolean describeNamedGraphs) {
        this.g.add((Resource)this.aService, RDF.TYPE, (Value)Service, new Resource[0]);
        this.describeServiceEndpoints();
        this.describeLanguages();
        this.describeOtherFeatures();
        this.describeInputFormats();
        this.describeResultFormats();
        this.describeEntailmentRegime();
        this.g.add((Resource)this.aService, defaultDataset, (Value)this.aDefaultDataset, new Resource[0]);
        this.g.add((Resource)this.aDefaultDataset, RDF.TYPE, (Value)Dataset, new Resource[0]);
        VoID v = new VoID(this.g, this.tripleStore, this.serviceURI, (Resource)this.aDefaultDataset);
        v.describeDataSet(describeStatistics, describeNamedGraphs);
    }

    protected void describeServiceEndpoints() {
        for (String uri : this.serviceURI) {
            this.g.add((Resource)this.aService, endpoint, (Value)this.g.getValueFactory().createURI(uri), new Resource[0]);
        }
    }

    protected void describeLanguages() {
        this.g.add((Resource)this.aService, supportedLanguage, (Value)SPARQL10Query, new Resource[0]);
        this.g.add((Resource)this.aService, supportedLanguage, (Value)SPARQL11Query, new Resource[0]);
        this.g.add((Resource)this.aService, supportedLanguage, (Value)SPARQL11Update, new Resource[0]);
    }

    protected void describeInputFormats() {
        this.g.add((Resource)this.aService, inputFormat, (Value)RDFXML, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)NTRIPLES, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)TURTLE, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)N3, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)TRIG, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)NQUADS, new Resource[0]);
        if (this.tripleStore.getStatementIdentifiers()) {
            this.g.add((Resource)this.aService, inputFormat, (Value)NTRIPLES_RDR, new Resource[0]);
            this.g.add((Resource)this.aService, inputFormat, (Value)TURTLE_RDR, new Resource[0]);
        }
        this.g.add((Resource)this.aService, inputFormat, (Value)SPARQL_RESULTS_XML, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)SPARQL_RESULTS_JSON, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)SPARQL_RESULTS_CSV, new Resource[0]);
        this.g.add((Resource)this.aService, inputFormat, (Value)SPARQL_RESULTS_TSV, new Resource[0]);
    }

    protected void describeResultFormats() {
        this.g.add((Resource)this.aService, resultFormat, (Value)RDFXML, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)NTRIPLES, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)TURTLE, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)N3, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)TRIG, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)SPARQL_RESULTS_XML, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)SPARQL_RESULTS_JSON, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)SPARQL_RESULTS_CSV, new Resource[0]);
        this.g.add((Resource)this.aService, resultFormat, (Value)SPARQL_RESULTS_TSV, new Resource[0]);
    }

    protected void describeOtherFeatures() {
        IIndexManager indexManager;
        Properties properties;
        this.g.add((Resource)this.aService, feature, (Value)BasicFederatedQuery, new Resource[0]);
        if (this.tripleStore.isQuads()) {
            this.g.add((Resource)this.aService, feature, (Value)UnionDefaultGraph, new Resource[0]);
            this.g.add((Resource)this.aService, feature, (Value)ModeQuads, new Resource[0]);
        } else if (this.tripleStore.isStatementIdentifiers()) {
            this.g.add((Resource)this.aService, feature, (Value)ModeSids, new Resource[0]);
        } else {
            this.g.add((Resource)this.aService, feature, (Value)ModeTriples, new Resource[0]);
        }
        if (this.tripleStore.getLexiconRelation().isTextIndex()) {
            this.g.add((Resource)this.aService, feature, (Value)TextIndexValueCentric, new Resource[0]);
        }
        if (this.tripleStore.getLexiconRelation().isSubjectCentricTextIndex()) {
            this.g.add((Resource)this.aService, feature, (Value)TextIndexSubjectCentric, new Resource[0]);
        }
        if (Boolean.valueOf((properties = this.tripleStore.getProperties()).getProperty(BigdataSail.Options.TRUTH_MAINTENANCE, "true")).booleanValue()) {
            this.g.add((Resource)this.aService, feature, (Value)TruthMaintenance, new Resource[0]);
        }
        if (Boolean.valueOf(properties.getProperty(BigdataSail.Options.ISOLATABLE_INDICES, "false")).booleanValue()) {
            this.g.add((Resource)this.aService, feature, (Value)IsolatableIndices, new Resource[0]);
        }
        if (this.isMapgraphCompatible()) {
            this.g.add((Resource)this.aService, feature, (Value)MapgraphCompatible, new Resource[0]);
            if (this.isMapgraphAccelerated()) {
                this.g.add((Resource)this.aService, feature, (Value)MapgraphAcceleration, new Resource[0]);
            }
        }
        if ((indexManager = this.tripleStore.getIndexManager()) instanceof IJournal) {
            IJournal jnl = (IJournal)indexManager;
            Quorum<HAGlue, QuorumService<HAGlue>> quorum = jnl.getQuorum();
            if (quorum != null) {
                int k = quorum.replicationFactor();
                this.g.add((Resource)this.aService, ReplicationFactor, (Value)this.tripleStore.getValueFactory().createLiteral(k), new Resource[0]);
                this.g.add((Resource)this.aService, feature, (Value)HighlyAvailable, new Resource[0]);
            }
        } else if (indexManager instanceof IBigdataFederation) {
            this.g.add((Resource)this.aService, feature, (Value)ScaleOut, new Resource[0]);
        }
    }

    protected void describeEntailmentRegime() {
        if (!this.tripleStore.isQuads()) {
            return;
        }
        Axioms axioms = this.tripleStore.getAxioms();
        Object entailmentRegime = axioms == null || axioms instanceof NoAxioms ? simpleEntailment : (axioms instanceof OwlAxioms ? rdfsEntailment : (axioms instanceof RdfsAxioms ? rdfsEntailment : null));
        if (entailmentRegime != null) {
            this.g.add((Resource)this.aService, SD.entailmentRegime, (Value)entailmentRegime, new Resource[0]);
        }
    }

    boolean isMapgraphCompatible() {
        IFeatureSupported obj = (IFeatureSupported)ClassPathUtil.classForName((String)"com.blazegraph.rdf.gpu.MapgraphCompatibleNamespace", null, IFeatureSupported.class, (ClassLoader)this.getClass().getClassLoader());
        if (obj == null) {
            return false;
        }
        return obj.isSupported(this.tripleStore);
    }

    boolean isMapgraphAccelerated() {
        IFeatureSupported obj = (IFeatureSupported)ClassPathUtil.classForName((String)"com.blazegraph.rdf.gpu.MapgraphAcceleratedNamespace", null, IFeatureSupported.class, (ClassLoader)this.getClass().getClassLoader());
        if (obj == null) {
            return false;
        }
        return obj.isSupported(this.tripleStore);
    }
}

