/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.sparql;

import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataValueFactory;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.repository.sail.helpers.SPARQLUpdateDataBlockParser;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;
import org.openrdf.rio.helpers.StatementCollector;

public class SPARQLStarUpdateDataBlockParser
extends SPARQLUpdateDataBlockParser {
    private String baseURI;
    private Map<String, String> namespaceTable;

    public SPARQLStarUpdateDataBlockParser(ValueFactory valueFactory) {
        super(valueFactory);
        this.namespaceTable = new HashMap<String, String>();
    }

    public SPARQLStarUpdateDataBlockParser(ValueFactory valueFactory, Map<String, String> namespaces) {
        super(valueFactory);
        this.namespaceTable = namespaces;
        for (Map.Entry<String, String> entry : this.namespaceTable.entrySet()) {
            super.setNamespace(entry.getKey(), entry.getValue());
        }
    }

    protected Value parseValue() throws IOException, RDFParseException {
        if (this.checkSparqlStarSyntax()) {
            return this.parseStmtValue();
        }
        return super.parseValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkSparqlStarSyntax() throws IOException {
        int c2;
        int c1 = this.read();
        try {
            c2 = this.read();
            this.unread(c2);
        }
        finally {
            this.unread(c1);
        }
        return c1 == 60 && c2 == 60;
    }

    private Value parseStmtValue() throws IOException, RDFParseException {
        StringBuilder stmtBuf = new StringBuilder(100);
        int c = this.read();
        this.verifyCharacterOrFail(c, "<");
        c = this.read();
        this.verifyCharacterOrFail(c, "<");
        int recursiveCounter = 1;
        while (true) {
            c = this.read();
            int c2 = this.peek();
            if (c == 60 && c2 == 60) {
                ++recursiveCounter;
            } else if (c == 62 && c2 == 62) {
                if (--recursiveCounter == 0) {
                    break;
                }
            } else if (c == -1) {
                this.throwEOFException();
            }
            stmtBuf.append((char)c);
            if (c != 92) continue;
            c = this.read();
            if (c == -1) {
                this.throwEOFException();
            }
            if (c != 117 && c != 85) {
                this.reportFatalError("IRI includes string escapes: '\\" + c + "'");
            }
            stmtBuf.append((char)c);
        }
        c = this.read();
        SPARQLStarUpdateDataBlockParser p = new SPARQLStarUpdateDataBlockParser(this.valueFactory, this.namespaceTable);
        LinkedList stmts = new LinkedList();
        StatementCollector sc = new StatementCollector(stmts);
        p.setRDFHandler((RDFHandler)sc);
        p.setParserConfig(this.getParserConfig());
        try {
            p.parse(new StringReader(stmtBuf.toString()), this.baseURI);
        }
        catch (RDFHandlerException e) {
            throw new RDFParseException("Error parsing SPARQL* value", (Throwable)e);
        }
        if (stmts.size() != 1) {
            throw new RDFParseException("Error parsing SPARQL* value, invalid number of statements");
        }
        if (this.valueFactory instanceof BigdataValueFactory && stmts.get(0) instanceof BigdataStatement) {
            return ((BigdataValueFactory)this.valueFactory).createBNode((BigdataStatement)stmts.get(0));
        }
        throw new RDFParseException("Error parsing SPARQL* value, incompatible valueFactory");
    }

    protected void setBaseURI(String uri) {
        this.baseURI = uri;
        super.setBaseURI(uri);
    }

    public void setNamespace(String prefix, String namespace) {
        this.namespaceTable.put(prefix, namespace);
        super.setNamespace(prefix, namespace);
    }
}

