/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.rules;

import com.bigdata.rdf.axioms.Axioms;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.model.StatementEnum;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOFilter;
import com.bigdata.rdf.vocab.Vocabulary;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;

public class DoNotAddFilter<E extends ISPO>
extends SPOFilter<E> {
    private static final long serialVersionUID = -7833182476134679170L;
    private final Axioms axioms;
    private final IV rdfType;
    private final IV rdfsResource;
    private final boolean forwardChainRdfTypeRdfsResource;

    public DoNotAddFilter(Vocabulary vocab, Axioms axioms, boolean forwardChainRdfTypeRdfsResource) {
        if (vocab == null) {
            throw new IllegalArgumentException();
        }
        if (axioms == null) {
            throw new IllegalArgumentException();
        }
        this.axioms = axioms;
        this.forwardChainRdfTypeRdfsResource = forwardChainRdfTypeRdfsResource;
        if (!forwardChainRdfTypeRdfsResource && axioms.isRdfSchema()) {
            this.rdfType = vocab.get((Value)RDF.TYPE);
            this.rdfsResource = vocab.get((Value)RDFS.RESOURCE);
        } else {
            this.rdfsResource = null;
            this.rdfType = null;
        }
    }

    public boolean isValid(Object o) {
        if (!this.canAccept(o)) {
            return true;
        }
        return this.accept((ISPO)o);
    }

    private boolean accept(ISPO o) {
        ISPO spo = o;
        if (spo.s().isLiteral()) {
            return false;
        }
        if (spo.getStatementType() == StatementEnum.Explicit) {
            return true;
        }
        if (this.axioms.isAxiom(spo.s(), spo.p(), spo.o())) {
            return false;
        }
        return this.forwardChainRdfTypeRdfsResource || !IVUtility.equals(spo.p(), this.rdfType) || !IVUtility.equals(spo.o(), this.rdfsResource);
    }
}

