/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.model;

import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataResource;
import com.bigdata.rdf.model.BigdataStatement;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.model.StatementEnum;
import java.util.Date;
import java.util.UUID;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class BNodeContextFactory
implements BigdataValueFactory {
    private final UUID contextUuid = UUID.randomUUID();
    private final BigdataValueFactory valueFactory;
    private int nextID;

    @Override
    public String getNamespace() {
        return this.valueFactory.getNamespace();
    }

    @Override
    public void remove() {
    }

    public BNodeContextFactory(BigdataValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    protected String nextID() {
        return "_" + this.contextUuid + this.nextID++;
    }

    @Override
    public BigdataBNode createBNode() {
        return this.valueFactory.createBNode(this.nextID());
    }

    @Override
    public BigdataValue asValue(Value v) {
        return this.valueFactory.asValue(v);
    }

    @Override
    public BigdataBNode createBNode(String id) {
        return this.valueFactory.createBNode(id);
    }

    @Override
    public BigdataBNode createBNode(BigdataStatement stmt) {
        return this.valueFactory.createBNode(stmt);
    }

    @Override
    public BigdataLiteral createLiteral(boolean arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(byte arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(double arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(float arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(int arg0, boolean unsigned) {
        return this.valueFactory.createLiteral(arg0, unsigned);
    }

    @Override
    public BigdataLiteral createLiteral(long arg0, boolean unsigned) {
        return this.valueFactory.createLiteral(arg0, unsigned);
    }

    @Override
    public BigdataLiteral createLiteral(short arg0, boolean unsigned) {
        return this.valueFactory.createLiteral(arg0, unsigned);
    }

    @Override
    public BigdataLiteral createLiteral(byte arg0, boolean unsigned) {
        return this.valueFactory.createLiteral(arg0, unsigned);
    }

    @Override
    public BigdataLiteral createLiteral(int arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(long arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(short arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(String label, String language) {
        return this.valueFactory.createLiteral(label, language);
    }

    @Override
    public BigdataLiteral createLiteral(String label, URI datatype) {
        return this.valueFactory.createLiteral(label, datatype);
    }

    @Override
    public BigdataLiteral createLiteral(String label, URI datatype, String language) {
        return this.valueFactory.createLiteral(label, datatype, language);
    }

    @Override
    public BigdataLiteral createLiteral(String label) {
        return this.valueFactory.createLiteral(label);
    }

    @Override
    public BigdataLiteral createLiteral(XMLGregorianCalendar arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataLiteral createLiteral(Date arg0) {
        return this.valueFactory.createLiteral(arg0);
    }

    @Override
    public BigdataStatement createStatement(Resource s, URI p, Value o) {
        return this.valueFactory.createStatement(s, p, o);
    }

    @Override
    public BigdataStatement createStatement(Resource s, URI p, Value o, Resource c) {
        return this.valueFactory.createStatement(s, p, o, c);
    }

    @Override
    public BigdataStatement createStatement(Resource s, URI p, Value o, Resource c, StatementEnum type) {
        return this.valueFactory.createStatement(s, p, o, c, type, false);
    }

    @Override
    public BigdataStatement createStatement(Resource s, URI p, Value o, Resource c, StatementEnum type, boolean userFlag) {
        return this.valueFactory.createStatement(s, p, o, c, type, userFlag);
    }

    @Override
    public BigdataURI createURI(String namespace, String localName) {
        return this.valueFactory.createURI(namespace, localName);
    }

    @Override
    public BigdataURI createURI(String uriString) {
        return this.valueFactory.createURI(uriString);
    }

    @Override
    public BigdataValueSerializer<BigdataValue> getValueSerializer() {
        return this.valueFactory.getValueSerializer();
    }

    @Override
    public BigdataValueFactory newBNodeContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigdataResource asValue(Resource v) {
        return this.valueFactory.asValue(v);
    }

    @Override
    public BigdataURI asValue(URI v) {
        return this.valueFactory.asValue(v);
    }

    @Override
    public BigdataLiteral asValue(Literal v) {
        return this.valueFactory.asValue(v);
    }

    @Override
    public BigdataBNode asValue(BNode v) {
        return this.valueFactory.asValue(v);
    }

    @Override
    public BigdataLiteral createXSDDateTime(long timestamp) {
        return this.valueFactory.createXSDDateTime(timestamp);
    }
}

