/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.filter.PrefixFilter;
import com.bigdata.btree.filter.TupleFilter;
import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.btree.keys.KVO;
import com.bigdata.cache.ConcurrentWeakValueCacheWithBatchedUpdates;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IJournal;
import com.bigdata.journal.IResourceLock;
import com.bigdata.journal.NoSuchIndexException;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtensionFactory;
import com.bigdata.rdf.internal.IInlineURIFactory;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.IVUtility;
import com.bigdata.rdf.internal.LexiconConfiguration;
import com.bigdata.rdf.internal.NoExtensionFactory;
import com.bigdata.rdf.internal.NoInlineURIFactory;
import com.bigdata.rdf.internal.NoSuchVocabularyItem;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.impl.BlobIV;
import com.bigdata.rdf.internal.impl.TermId;
import com.bigdata.rdf.internal.impl.bnode.SidIV;
import com.bigdata.rdf.lexicon.BatchResolveBlobIVsTask;
import com.bigdata.rdf.lexicon.BatchResolveTermIVsTask;
import com.bigdata.rdf.lexicon.BlobsIndexHelper;
import com.bigdata.rdf.lexicon.BlobsIndexSplitHandler;
import com.bigdata.rdf.lexicon.BlobsTupleSerializer;
import com.bigdata.rdf.lexicon.BlobsWriteTask;
import com.bigdata.rdf.lexicon.CacheValueFilter;
import com.bigdata.rdf.lexicon.FullTextIndexWriterTask;
import com.bigdata.rdf.lexicon.ISubjectCentricTextIndexer;
import com.bigdata.rdf.lexicon.ITermCache;
import com.bigdata.rdf.lexicon.IValueCentricTextIndexer;
import com.bigdata.rdf.lexicon.Id2TermTupleSerializer;
import com.bigdata.rdf.lexicon.KVOTermIdComparator;
import com.bigdata.rdf.lexicon.LexAccessPatternEnum;
import com.bigdata.rdf.lexicon.LexiconKeyBuilder;
import com.bigdata.rdf.lexicon.LexiconKeyOrder;
import com.bigdata.rdf.lexicon.ReverseIndexWriterTask;
import com.bigdata.rdf.lexicon.Term2IdTupleSerializer;
import com.bigdata.rdf.lexicon.Term2IdWriteTask;
import com.bigdata.rdf.lexicon.TermCache;
import com.bigdata.rdf.lexicon.WriteTaskStats;
import com.bigdata.rdf.model.BigdataBNode;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.model.BigdataValueFactory;
import com.bigdata.rdf.model.BigdataValueSerializer;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.rdf.vocab.NoVocabulary;
import com.bigdata.rdf.vocab.Vocabulary;
import com.bigdata.relation.AbstractRelation;
import com.bigdata.relation.RelationSchema;
import com.bigdata.relation.accesspath.AccessPath;
import com.bigdata.relation.accesspath.ArrayAccessPath;
import com.bigdata.relation.accesspath.EmptyAccessPath;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.locator.ILocatableResource;
import com.bigdata.search.FullTextIndex;
import com.bigdata.service.IBigdataFederation;
import com.bigdata.service.geospatial.GeoSpatialConfig;
import com.bigdata.sparse.SparseRowStore;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.NT;
import com.bigdata.util.concurrent.CanonicalFactory;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.IStriterator;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

public class LexiconRelation
extends AbstractRelation<BigdataValue>
implements IDatatypeURIResolver {
    private static final Logger log = Logger.getLogger(LexiconRelation.class);
    private final Set<String> indexNames;
    private final List<IKeyOrder<BigdataValue>> keyOrders;
    private final AtomicReference<IValueCentricTextIndexer<?>> viewRef = new AtomicReference();
    private final AtomicReference<ISubjectCentricTextIndexer<?>> viewRef2 = new AtomicReference();
    private final BlobsIndexHelper h = new BlobsIndexHelper();
    private final BigdataValueFactory valueFactory;
    private volatile IIndex term2id;
    private volatile IIndex id2term;
    private volatile IIndex blobs;
    private boolean textIndex = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.TEXT_INDEX, "true"));
    @Deprecated
    private final boolean subjectCentricTextIndex;
    private final boolean storeBlankNodes;
    private final int termIdBitsToReverse;
    private final boolean inlineLiterals;
    private final boolean inlineTextLiterals;
    private final int maxInlineTextLength;
    private final boolean inlineBNodes;
    private final boolean inlineDateTimes;
    private final boolean rejectInvalidXSDValues;
    private final TimeZone inlineDateTimesTimeZone;
    private final ITermCache<IV<?, ?>, BigdataValue> termCache;
    private static CanonicalFactory<NT, ITermCache<IV<?, ?>, BigdataValue>, Integer> termCacheFactory = new CanonicalFactory<NT, ITermCache<IV<?, ?>, BigdataValue>, Integer>(1){

        @Override
        protected ITermCache<IV<?, ?>, BigdataValue> newInstance(NT key, Integer termCacheCapacity) {
            return new TermCache(new ConcurrentWeakValueCacheWithBatchedUpdates(termCacheCapacity.intValue(), 0.75f, 16));
        }
    };
    private final Vocabulary vocab;
    private final ILexiconConfiguration<BigdataValue> lexiconConfiguration;
    public static final transient String NAME_LEXICON_RELATION = "lex";

    protected Class<BigdataValueFactory> determineValueFactoryClass() {
        Class<BigdataValueFactory> cls;
        String className = this.getProperty(AbstractTripleStore.Options.VALUE_FACTORY_CLASS, AbstractTripleStore.Options.DEFAULT_VALUE_FACTORY_CLASS);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + AbstractTripleStore.Options.VALUE_FACTORY_CLASS, e);
        }
        if (!BigdataValueFactory.class.isAssignableFrom(cls)) {
            throw new RuntimeException(AbstractTripleStore.Options.VALUE_FACTORY_CLASS + ": Must implement: " + BigdataValueFactory.class.getName());
        }
        return cls;
    }

    protected Class<IValueCentricTextIndexer> determineTextIndexerClass() {
        Class<IValueCentricTextIndexer> cls;
        String className = this.getProperty(AbstractTripleStore.Options.TEXT_INDEXER_CLASS, AbstractTripleStore.Options.DEFAULT_TEXT_INDEXER_CLASS);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + AbstractTripleStore.Options.TEXT_INDEXER_CLASS, e);
        }
        if (!IValueCentricTextIndexer.class.isAssignableFrom(cls)) {
            throw new RuntimeException(AbstractTripleStore.Options.TEXT_INDEXER_CLASS + ": Must implement: " + IValueCentricTextIndexer.class.getName());
        }
        return cls;
    }

    protected Class<ISubjectCentricTextIndexer> determineSubjectCentricTextIndexerClass() {
        Class<ISubjectCentricTextIndexer> cls;
        String className = this.getProperty(AbstractTripleStore.Options.SUBJECT_CENTRIC_TEXT_INDEXER_CLASS, AbstractTripleStore.Options.DEFAULT_SUBJECT_CENTRIC_TEXT_INDEXER_CLASS);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + AbstractTripleStore.Options.SUBJECT_CENTRIC_TEXT_INDEXER_CLASS, e);
        }
        if (!ISubjectCentricTextIndexer.class.isAssignableFrom(cls)) {
            throw new RuntimeException(AbstractTripleStore.Options.SUBJECT_CENTRIC_TEXT_INDEXER_CLASS + ": Must implement: " + ISubjectCentricTextIndexer.class.getName());
        }
        return cls;
    }

    protected Class<IExtensionFactory> determineExtensionFactoryClass() {
        Class<IExtensionFactory> cls;
        String defaultClassName = this.vocab == null || this.vocab.getClass() == NoVocabulary.class ? NoExtensionFactory.class.getName() : AbstractTripleStore.Options.DEFAULT_EXTENSION_FACTORY_CLASS;
        String className = this.getProperty(AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS, defaultClassName);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS, e);
        }
        if (!IExtensionFactory.class.isAssignableFrom(cls)) {
            throw new RuntimeException(AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS + ": Must implement: " + IExtensionFactory.class.getName());
        }
        return cls;
    }

    protected Class<IInlineURIFactory> determineInlineURIFactoryClass() {
        Class<IInlineURIFactory> cls;
        String defaultClassName = this.vocab == null || this.vocab.get((Value)XSD.IPV4) == null ? NoInlineURIFactory.class.getName() : AbstractTripleStore.Options.DEFAULT_INLINE_URI_FACTORY_CLASS;
        String className = this.getProperty(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, defaultClassName);
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Bad option: " + AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, e);
        }
        if (!IInlineURIFactory.class.isAssignableFrom(cls)) {
            throw new RuntimeException(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS + ": Must implement: " + IInlineURIFactory.class.getName());
        }
        return cls;
    }

    public LexiconRelation(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        this(null, indexManager, namespace, timestamp, properties);
    }

    public LexiconRelation(AbstractTripleStore container, IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(container, indexManager, namespace, timestamp, properties);
        IInlineURIFactory uriFactory;
        IExtensionFactory xFactory;
        if (this.textIndex) {
            properties.setProperty(FullTextIndex.Options.OVERWRITE, "false");
        }
        this.subjectCentricTextIndex = this.textIndex;
        this.storeBlankNodes = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.STORE_BLANK_NODES, "false"));
        int blobsThreshold = Integer.parseInt(this.getProperty(AbstractTripleStore.Options.BLOBS_THRESHOLD, "256"));
        if (blobsThreshold < 0 || (long)blobsThreshold > 4096L && blobsThreshold != Integer.MAX_VALUE) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.BLOBS_THRESHOLD + "=" + blobsThreshold);
        }
        if (indexManager instanceof IBigdataFederation && ((IBigdataFederation)indexManager).isScaleOut()) {
            String defaultValue = "6";
            this.termIdBitsToReverse = Integer.parseInt(this.getProperty(AbstractTripleStore.Options.TERMID_BITS_TO_REVERSE, "6"));
            if (this.termIdBitsToReverse < 0 || this.termIdBitsToReverse > 31) {
                throw new IllegalArgumentException(AbstractTripleStore.Options.TERMID_BITS_TO_REVERSE + "=" + this.termIdBitsToReverse);
            }
        } else {
            this.termIdBitsToReverse = 0;
        }
        HashSet<String> set = new HashSet<String>();
        set.add(this.getFQN(LexiconKeyOrder.TERM2ID));
        set.add(this.getFQN(LexiconKeyOrder.ID2TERM));
        set.add(this.getFQN(LexiconKeyOrder.BLOBS));
        if (this.textIndex) {
            set.add(this.getNamespace() + "." + "search");
        }
        this.indexNames = Collections.unmodifiableSet(set);
        this.keyOrders = Arrays.asList(LexiconKeyOrder.TERM2ID, LexiconKeyOrder.ID2TERM, LexiconKeyOrder.BLOBS);
        try {
            Class<BigdataValueFactory> vfc = this.determineValueFactoryClass();
            Method gi = vfc.getMethod("getInstance", String.class);
            this.valueFactory = (BigdataValueFactory)gi.invoke(null, namespace);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.VALUE_FACTORY_CLASS, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.VALUE_FACTORY_CLASS, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.VALUE_FACTORY_CLASS, e);
        }
        int termCacheCapacity = Integer.parseInt(this.getProperty(AbstractTripleStore.Options.TERM_CACHE_CAPACITY, "10000"));
        Long commitTime = this.getCommitTime();
        this.termCache = commitTime != null && TimestampUtility.isReadOnly(timestamp) ? termCacheFactory.getInstance(new NT(namespace, commitTime.longValue()), termCacheCapacity * 2) : new TermCache(new ConcurrentWeakValueCacheWithBatchedUpdates(termCacheCapacity, 0.75f, 16));
        this.inlineLiterals = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.INLINE_XSD_DATATYPE_LITERALS, "true"));
        this.inlineTextLiterals = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.INLINE_TEXT_LITERALS, "false"));
        this.maxInlineTextLength = Integer.parseInt(this.getProperty(AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH, "0"));
        this.inlineBNodes = this.storeBlankNodes && Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.INLINE_BNODES, "true"));
        this.inlineDateTimes = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.INLINE_DATE_TIMES, "true"));
        this.inlineDateTimesTimeZone = TimeZone.getTimeZone(this.getProperty(AbstractTripleStore.Options.INLINE_DATE_TIMES_TIMEZONE, "GMT"));
        this.rejectInvalidXSDValues = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.REJECT_INVALID_XSD_VALUES, "false"));
        this.vocab = this.getContainer().getVocabulary();
        Boolean geoSpatial = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.GEO_SPATIAL, "false"));
        GeoSpatialConfig geoSpatialConfig = geoSpatial != null && geoSpatial != false ? this.getContainer().getGeoSpatialConfig() : null;
        try {
            Class<IExtensionFactory> xfc = this.determineExtensionFactoryClass();
            xFactory = xfc.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.EXTENSION_FACTORY_CLASS, e);
        }
        try {
            Class<IInlineURIFactory> urifc = this.determineInlineURIFactoryClass();
            uriFactory = urifc.newInstance();
            uriFactory.init(this.vocab);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(AbstractTripleStore.Options.INLINE_URI_FACTORY_CLASS, e);
        }
        this.lexiconConfiguration = new LexiconConfiguration<BigdataValue>(blobsThreshold, this.inlineLiterals, this.inlineTextLiterals, this.maxInlineTextLength, this.inlineBNodes, this.inlineDateTimes, this.inlineDateTimesTimeZone, this.rejectInvalidXSDValues, xFactory, this.vocab, this.valueFactory, uriFactory, geoSpatial, geoSpatialConfig);
    }

    public BigdataValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Override
    public AbstractTripleStore getContainer() {
        return (AbstractTripleStore)super.getContainer();
    }

    public boolean exists() {
        for (String name : this.getIndexNames()) {
            if (this.getIndex(name) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public LexiconRelation init() {
        super.init();
        this.lexiconConfiguration.initExtensions(this);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() {
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            super.create();
            if (this.textIndex && this.inlineTextLiterals && this.maxInlineTextLength > 4096) {
                log.error((Object)("Configuration will duplicate large literals within the full text index: " + AbstractTripleStore.Options.TEXT_INDEX + "=" + this.textIndex + ", " + AbstractTripleStore.Options.INLINE_TEXT_LITERALS + "=" + this.inlineTextLiterals + ", " + AbstractTripleStore.Options.MAX_INLINE_TEXT_LENGTH + "=" + this.maxInlineTextLength));
            }
            IIndexManager indexManager = this.getIndexManager();
            indexManager.registerIndex(this.getTerm2IdIndexMetadata(this.getFQN(LexiconKeyOrder.TERM2ID)));
            indexManager.registerIndex(this.getId2TermIndexMetadata(this.getFQN(LexiconKeyOrder.ID2TERM)));
            if (this.getLexiconConfiguration().getBlobsThreshold() != Integer.MAX_VALUE) {
                indexManager.registerIndex(this.getBlobsIndexMetadata(this.getFQN(LexiconKeyOrder.BLOBS)));
            }
            if (this.textIndex) {
                IValueCentricTextIndexer<?> tmp = this.getSearchEngine();
                tmp.create();
            }
            this.lexiconConfiguration.initExtensions(this);
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        IResourceLock resourceLock = this.acquireExclusiveLock();
        try {
            IIndexManager indexManager = this.getIndexManager();
            indexManager.dropIndex(this.getFQN(LexiconKeyOrder.TERM2ID));
            indexManager.dropIndex(this.getFQN(LexiconKeyOrder.ID2TERM));
            if (this.getLexiconConfiguration().getBlobsThreshold() != Integer.MAX_VALUE) {
                indexManager.dropIndex(this.getFQN(LexiconKeyOrder.BLOBS));
            }
            this.term2id = null;
            this.id2term = null;
            this.blobs = null;
            if (this.textIndex) {
                this.getSearchEngine().destroy();
                this.viewRef.set(null);
            }
            this.valueFactory.remove();
            this.termCache.clear();
            super.destroy();
        }
        finally {
            this.unlock(resourceLock);
        }
    }

    public final boolean isInlineLiterals() {
        return this.inlineLiterals;
    }

    public final int getMaxInlineStringLength() {
        return this.maxInlineTextLength;
    }

    public final boolean isInlineDateTimes() {
        return this.inlineDateTimes;
    }

    public final TimeZone getInlineDateTimesTimeZone() {
        return this.inlineDateTimesTimeZone;
    }

    public final int getTermIdBitsToReverse() {
        return this.termIdBitsToReverse;
    }

    public final boolean isStoreBlankNodes() {
        return this.storeBlankNodes;
    }

    public final boolean isTextIndex() {
        return this.textIndex;
    }

    @Deprecated
    public final boolean isSubjectCentricTextIndex() {
        return this.subjectCentricTextIndex;
    }

    @Override
    public IIndex getIndex(IKeyOrder<? extends BigdataValue> keyOrder) {
        if (keyOrder == LexiconKeyOrder.ID2TERM) {
            return this.getId2TermIndex();
        }
        if (keyOrder == LexiconKeyOrder.TERM2ID) {
            return this.getTerm2IdIndex();
        }
        if (keyOrder == LexiconKeyOrder.BLOBS) {
            return this.getBlobsIndex();
        }
        throw new AssertionError((Object)("keyOrder=" + keyOrder));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IIndex getTerm2IdIndex() {
        if (this.term2id == null) {
            LexiconRelation lexiconRelation = this;
            synchronized (lexiconRelation) {
                if (this.term2id == null) {
                    long timestamp = this.getTimestamp();
                    this.term2id = TimestampUtility.isReadWriteTx(timestamp) ? AbstractRelation.getIndex(this.getIndexManager(), this.getFQN(LexiconKeyOrder.TERM2ID), 0L) : super.getIndex(LexiconKeyOrder.TERM2ID);
                    if (this.term2id == null) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        return this.term2id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IIndex getId2TermIndex() {
        if (this.id2term == null) {
            LexiconRelation lexiconRelation = this;
            synchronized (lexiconRelation) {
                if (this.id2term == null) {
                    long timestamp = this.getTimestamp();
                    this.id2term = TimestampUtility.isReadWriteTx(timestamp) ? AbstractRelation.getIndex(this.getIndexManager(), this.getFQN(LexiconKeyOrder.ID2TERM), 0L) : super.getIndex(LexiconKeyOrder.ID2TERM);
                    if (this.id2term == null) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        return this.id2term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IIndex getBlobsIndex() {
        if (this.blobs == null) {
            LexiconRelation lexiconRelation = this;
            synchronized (lexiconRelation) {
                if (this.blobs == null) {
                    long timestamp = this.getTimestamp();
                    this.blobs = TimestampUtility.isReadWriteTx(timestamp) ? AbstractRelation.getIndex(this.getIndexManager(), this.getFQN(LexiconKeyOrder.BLOBS), 0L) : super.getIndex(LexiconKeyOrder.BLOBS);
                    if (this.blobs == null) {
                        throw new IllegalStateException();
                    }
                }
            }
        }
        return this.blobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IValueCentricTextIndexer<?> getSearchEngine() {
        if (!this.textIndex) {
            return null;
        }
        if (this.viewRef.get() == null) {
            AtomicReference<IValueCentricTextIndexer<?>> atomicReference = this.viewRef;
            synchronized (atomicReference) {
                if (this.viewRef.get() == null) {
                    try {
                        Class<IValueCentricTextIndexer> vfc = this.determineTextIndexerClass();
                        Method gi = vfc.getMethod("getInstance", IIndexManager.class, String.class, Long.class, Properties.class);
                        IValueCentricTextIndexer tmp = (IValueCentricTextIndexer)gi.invoke(null, this.getIndexManager(), this.getNamespace(), this.getTimestamp(), this.getProperties());
                        if (tmp instanceof ILocatableResource) {
                            ((ILocatableResource)((Object)tmp)).init();
                        }
                        this.viewRef.set(tmp);
                    }
                    catch (Throwable e) {
                        throw new IllegalArgumentException(AbstractTripleStore.Options.TEXT_INDEXER_CLASS, e);
                    }
                }
            }
        }
        return this.viewRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ISubjectCentricTextIndexer<?> getSubjectCentricSearchEngine() {
        if (!this.subjectCentricTextIndex) {
            return null;
        }
        if (this.viewRef2.get() == null) {
            AtomicReference<ISubjectCentricTextIndexer<?>> atomicReference = this.viewRef2;
            synchronized (atomicReference) {
                if (this.viewRef2.get() == null) {
                    try {
                        Class<ISubjectCentricTextIndexer> vfc = this.determineSubjectCentricTextIndexerClass();
                        Method gi = vfc.getMethod("getInstance", IIndexManager.class, String.class, Long.class, Properties.class);
                        ISubjectCentricTextIndexer tmp = (ISubjectCentricTextIndexer)gi.invoke(null, this.getIndexManager(), this.getNamespace(), this.getTimestamp(), this.getProperties());
                        if (tmp instanceof ILocatableResource) {
                            ((ILocatableResource)((Object)tmp)).init();
                        }
                        this.viewRef2.set(tmp);
                    }
                    catch (Throwable e) {
                        throw new IllegalArgumentException(AbstractTripleStore.Options.SUBJECT_CENTRIC_TEXT_INDEXER_CLASS, e);
                    }
                }
            }
        }
        return this.viewRef2.get();
    }

    protected IndexMetadata getTerm2IdIndexMetadata(String name) {
        IndexMetadata metadata = this.newIndexMetadata(name);
        metadata.setTupleSerializer(new Term2IdTupleSerializer(this.getProperties()));
        return metadata;
    }

    protected IndexMetadata getId2TermIndexMetadata(String name) {
        IndexMetadata metadata = this.newIndexMetadata(name);
        metadata.setTupleSerializer(new Id2TermTupleSerializer(this.getNamespace(), this.getValueFactory()));
        metadata.setRawRecords(true);
        metadata.setMaxRecLen(16);
        return metadata;
    }

    protected IndexMetadata getBlobsIndexMetadata(String name) {
        IndexMetadata metadata = new IndexMetadata(this.getIndexManager(), this.getProperties(), name, UUID.randomUUID(), IndexTypeEnum.BTree);
        metadata.setTupleSerializer(new BlobsTupleSerializer(this.getNamespace(), this.valueFactory));
        metadata.setRawRecords(true);
        metadata.setMaxRecLen(0);
        if (this.getIndexManager() instanceof IBigdataFederation && ((IBigdataFederation)this.getIndexManager()).isScaleOut()) {
            metadata.setSplitHandler(new BlobsIndexSplitHandler());
        }
        return metadata;
    }

    @Override
    public Set<String> getIndexNames() {
        return this.indexNames;
    }

    @Override
    public Iterator<IKeyOrder<BigdataValue>> getKeyOrders() {
        return this.keyOrders.iterator();
    }

    public LexiconKeyOrder getPrimaryKeyOrder() {
        return LexiconKeyOrder.BLOBS;
    }

    @Override
    public BigdataValue newElement(List<BOp> a, IBindingSet bindingSet) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<BigdataValue> getElementClass() {
        return BigdataValue.class;
    }

    @Override
    public long delete(IChunkedOrderedIterator<BigdataValue> itr) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long insert(IChunkedOrderedIterator<BigdataValue> itr) {
        throw new UnsupportedOperationException();
    }

    public Iterator<IV> prefixScan(Literal lit) {
        if (lit == null) {
            throw new IllegalArgumentException();
        }
        return this.prefixScan(new Literal[]{lit});
    }

    public Iterator<IV> prefixScan(Literal[] lits) {
        if (lits == null || lits.length == 0) {
            throw new IllegalArgumentException();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("#lits=" + lits.length));
        }
        LexiconKeyBuilder keyBuilder = ((Term2IdTupleSerializer)this.getTerm2IdIndex().getIndexMetadata().getTupleSerializer()).getLexiconPrimaryKeyBuilder();
        byte[][] keys = new byte[lits.length][];
        for (int i = 0; i < lits.length; ++i) {
            Literal lit = lits[i];
            if (lit == null) {
                throw new IllegalArgumentException();
            }
            keys[i] = keyBuilder.value2Key((Value)lit);
        }
        IIndex ndx = this.getTerm2IdIndex();
        IStriterator termIdIterator = new Striterator((Iterator)ndx.rangeIterator(null, null, 0, 35, new PrefixFilter(keys))).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object arg0) {
                byte[] bytes = ((ITuple)arg0).getValue();
                return IVUtility.decode(bytes);
            }
        });
        return termIdIterator;
    }

    @Override
    public BigdataURI resolve(URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        BigdataURI value = this.valueFactory.asValue(uri);
        IV iv = this.vocab.get(value);
        if (iv == null) {
            throw new NoSuchVocabularyItem("uri=" + uri + ", vocab=" + this.vocab);
        }
        value.setIV(iv);
        return value;
    }

    public boolean isBlob(Value v) {
        int blobsThreshold = this.lexiconConfiguration.getBlobsThreshold();
        if (blobsThreshold == 0) {
            return true;
        }
        long strlen = BigdataValueSerializer.getStringLength(v);
        if (strlen >= (long)blobsThreshold) {
            if (this.lexiconConfiguration.isBlobsDisabled()) {
                throw new IllegalArgumentException("Large literal but BLOBS index is disabled: strlen=" + strlen);
            }
            return true;
        }
        return false;
    }

    public long addTerms(BigdataValue[] values, int numTerms, boolean readOnly) {
        BigdataValue[] a;
        if (log.isDebugEnabled()) {
            log.debug((Object)("numTerms=" + numTerms + ", readOnly=" + readOnly));
        }
        BigdataValueFactory vf = this.getValueFactory();
        for (int i = 0; i < numTerms; ++i) {
            BigdataValue tmp = vf.asValue(values[i]);
            if (tmp != values[i]) {
                throw new RuntimeException("Value does not belong to this namespace: value=" + values[i]);
            }
            values[i] = tmp;
        }
        LinkedHashMap<BigdataValue, BigdataValue> terms = new LinkedHashMap<BigdataValue, BigdataValue>(numTerms);
        LinkedHashMap<BigdataValue, BigdataValue> blobs = new LinkedHashMap<BigdataValue, BigdataValue>();
        LinkedList<BigdataValue> dups = new LinkedList<BigdataValue>();
        LinkedHashSet<BigdataValue> textIndex = new LinkedHashSet<BigdataValue>();
        int nunknown = 0;
        int nblobs = 0;
        int nterms = 0;
        for (int i = 0; i < numTerms; ++i) {
            BigdataValue v = values[i];
            if (this.getInlineIV(v) == null) {
                if (this.isBlob(v)) {
                    if (blobs.get(v) != null) {
                        dups.add(v);
                    } else {
                        if (blobs.put(v, v) != null) {
                            throw new AssertionError();
                        }
                        ++nblobs;
                    }
                } else if (terms.get(v) != null) {
                    dups.add(v);
                } else {
                    if (terms.put(v, v) != null) {
                        throw new AssertionError();
                    }
                    ++nterms;
                }
                ++nunknown;
                continue;
            }
            if (readOnly || !this.textIndex || !(v instanceof BigdataLiteral)) continue;
            BigdataURI dt = ((BigdataLiteral)v).getDatatype();
            if (dt == null || dt.equals(XSD.STRING)) {
                textIndex.add(v);
                continue;
            }
            if (!this.lexiconConfiguration.isInlineDatatypeToTextIndex(dt)) continue;
            textIndex.add(v);
        }
        if (nunknown == 0 && textIndex.isEmpty()) {
            return 0L;
        }
        WriteTaskStats stats = new WriteTaskStats();
        if (nblobs > 0) {
            a = blobs.keySet().toArray(new BigdataValue[nblobs]);
            this.addBlobs(a, a.length, readOnly, stats);
        }
        if (nterms > 0) {
            a = terms.keySet().toArray(new BigdataValue[nterms]);
            this.addTerms(a, a.length, readOnly, stats);
        }
        if (this.textIndex && textIndex.size() > 0) {
            try {
                stats.fullTextIndexTime.addAndGet(new FullTextIndexWriterTask(this.getSearchEngine(), textIndex.size(), textIndex.iterator()).call());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (!dups.isEmpty()) {
            for (BigdataValue dup : dups) {
                IV iv;
                BigdataValue resolved = (BigdataValue)blobs.get(dup);
                if (resolved == null) {
                    resolved = (BigdataValue)terms.get(dup);
                }
                if (resolved == null || (iv = resolved.getIV()) == null) continue;
                dup.setIV(iv);
            }
        }
        if (log.isInfoEnabled() && readOnly && stats.nunknown.get() > 0) {
            log.info((Object)("There are " + stats.nunknown + " unknown terms out of " + numTerms + " given"));
        }
        return stats.ndistinct.get();
    }

    private void addBlobs(BigdataValue[] terms, int numTerms, boolean readOnly, WriteTaskStats stats) {
        KVO<BigdataValue>[] a;
        try {
            a = new BlobsWriteTask(this.getBlobsIndex(), this.valueFactory, readOnly, this.storeBlankNodes, numTerms, terms, stats).call();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int ndistinct = a.length;
        if (ndistinct == 0) {
            return;
        }
        if (!readOnly && this.textIndex) {
            long _begin = System.currentTimeMillis();
            try {
                IStriterator itr = new Striterator(new ChunkedArrayIterator<KVO<BigdataValue>>(ndistinct, a, null)).addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object obj) {
                        return ((KVO)obj).obj;
                    }
                });
                stats.fullTextIndexTime.addAndGet(new FullTextIndexWriterTask(this.getSearchEngine(), ndistinct, (Iterator<BigdataValue>)itr).call());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            stats.indexTime.addAndGet(System.currentTimeMillis() - _begin);
        }
    }

    private void addTerms(BigdataValue[] terms, int numTerms, boolean readOnly, WriteTaskStats stats) {
        KVO<BigdataValue>[] a;
        try {
            a = new Term2IdWriteTask(this.getTerm2IdIndex(), readOnly, this.storeBlankNodes, this.termIdBitsToReverse, numTerms, terms, stats).call();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        int ndistinct = a.length;
        if (ndistinct == 0) {
            return;
        }
        if (!readOnly) {
            long _begin = System.currentTimeMillis();
            Arrays.sort(a, 0, ndistinct, KVOTermIdComparator.INSTANCE);
            stats.keySortTime.add(System.currentTimeMillis() - _begin);
            _begin = System.currentTimeMillis();
            LinkedList<Callable<Long>> tasks = new LinkedList<Callable<Long>>();
            tasks.add(new ReverseIndexWriterTask(this.getId2TermIndex(), this.valueFactory, a, ndistinct, this.storeBlankNodes));
            if (this.textIndex) {
                IStriterator itr = new Striterator(new ChunkedArrayIterator<KVO<BigdataValue>>(ndistinct, a, null)).addFilter((IFilter)new Resolver(){
                    private static final long serialVersionUID = 1L;

                    protected Object resolve(Object obj) {
                        return ((KVO)obj).obj;
                    }
                });
                tasks.add(new FullTextIndexWriterTask(this.getSearchEngine(), ndistinct, (Iterator<BigdataValue>)itr));
            }
            try {
                List futures = this.getExecutorService().invokeAll(tasks);
                stats.reverseIndexTime = (Long)futures.get(0).get();
                if (this.textIndex) {
                    stats.fullTextIndexTime.addAndGet((Long)futures.get(1).get());
                }
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            stats.indexTime.addAndGet(System.currentTimeMillis() - _begin);
        }
    }

    public void rebuildTextIndex(boolean forceCreate) {
        IValueCentricTextIndexer<?> textIndexer;
        if (this.getTimestamp() != 0L) {
            throw new UnsupportedOperationException("Unisolated connection required to rebuild full text index");
        }
        if (this.textIndex) {
            IValueCentricTextIndexer<?> oldTextIndexer = this.getSearchEngine();
            oldTextIndexer.destroy();
            this.viewRef.set(null);
            textIndexer = this.getSearchEngine();
        } else if (forceCreate) {
            this.textIndex = true;
            textIndexer = this.getSearchEngine();
            SparseRowStore global = this.indexManager.getGlobalRowStore();
            this.updateTextIndexConfiguration(global, this.getContainerNamespace());
            this.updateTextIndexConfiguration(global, this.getNamespace());
        } else {
            throw new UnsupportedOperationException("Could not rebuild full text index, because it is not enabled");
        }
        textIndexer.create();
        IIndex terms = this.getId2TermIndex();
        final ITupleSerializer tupSer = terms.getIndexMetadata().getTupleSerializer();
        IStriterator itr = new Striterator((Iterator)terms.rangeIterator(null, null, 0, 3, new TupleFilter<BigdataValue>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isValid(ITuple<BigdataValue> obj) {
                IV iv = (IV)tupSer.deserializeKey(obj);
                return iv != null && iv.isLiteral();
            }
        })).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object obj) {
                BigdataLiteral lit = (BigdataLiteral)tupSer.deserialize((ITuple)obj);
                return lit;
            }
        });
        int capacity = 10000;
        textIndexer.index(10000, (Iterator<BigdataValue>)itr);
        terms = this.getBlobsIndex();
        tupSer = terms.getIndexMetadata().getTupleSerializer();
        itr = new Striterator((Iterator)terms.rangeIterator(null, null, 0, 3, new TupleFilter<BigdataValue>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isValid(ITuple<BigdataValue> obj) {
                IV iv = (IV)tupSer.deserializeKey(obj);
                return iv != null && iv.isLiteral();
            }
        })).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object obj) {
                BigdataLiteral lit = (BigdataLiteral)tupSer.deserialize((ITuple)obj);
                return lit;
            }
        });
        capacity = 10000;
        while (itr.hasNext()) {
            textIndexer.index(10000, (Iterator<BigdataValue>)itr);
        }
        if (this.indexManager instanceof IJournal) {
            ((IJournal)this.indexManager).commit();
        }
    }

    private void updateTextIndexConfiguration(SparseRowStore global, String namespace) {
        Map<String, Object> map = global.read(RelationSchema.INSTANCE, namespace);
        map.put(AbstractTripleStore.Options.TEXT_INDEX, "true");
        map.put(FullTextIndex.Options.FIELDS_ENABLED, "false");
        if (this.getNamespace().equals(namespace)) {
            map.put(FullTextIndex.Options.OVERWRITE, "false");
        }
        global.write(RelationSchema.INSTANCE, map);
    }

    public final Map<IV<?, ?>, BigdataValue> getTerms(Collection<IV<?, ?>> ivs) {
        return this.getTerms(ivs, 4000, 4000);
    }

    @Deprecated
    public void buildSubjectCentricTextIndex() {
        ISubjectCentricTextIndexer<?> textIndexer;
        block10: {
            if (this.getTimestamp() != 0L) {
                throw new UnsupportedOperationException();
            }
            if (!this.subjectCentricTextIndex) {
                throw new UnsupportedOperationException();
            }
            textIndexer = this.getSubjectCentricSearchEngine();
            try {
                textIndexer.destroy();
            }
            catch (NoSuchIndexException ex) {
                if (!log.isInfoEnabled()) break block10;
                log.info((Object)"could not destroy subject-centric full text index, does not currently exist");
            }
        }
        textIndexer.create();
        IIndex spoNdx = this.getContainer().getSPORelation().getPrimaryIndex();
        final ITupleSerializer tupSer = spoNdx.getIndexMetadata().getTupleSerializer();
        IStriterator itr = new Striterator((Iterator)spoNdx.rangeIterator(null, null, 0, 3, new TupleFilter<ISPO>(){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean isValid(ITuple<ISPO> obj) {
                ISPO spo = (ISPO)tupSer.deserializeKey(obj);
                return spo.o().isLiteral();
            }
        })).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object obj) {
                ISPO spo = (ISPO)tupSer.deserializeKey((ITuple)obj);
                return spo;
            }
        });
        IV s = null;
        LinkedList literals = new LinkedList();
        long subjectCount = 0L;
        long statementCount = 0L;
        boolean l = log.isInfoEnabled();
        while (itr.hasNext()) {
            ISPO spo = (ISPO)itr.next();
            if (!spo.s().equals(s)) {
                if (s != null) {
                    textIndexer.index(s, this.getTerms(literals).values().iterator());
                    statementCount += (long)literals.size();
                    if (l && ++subjectCount % 1000L == 0L) {
                        log.info((Object)("indexed " + subjectCount + " subjects, " + statementCount + " statements"));
                    }
                }
                s = spo.s();
                literals.clear();
            }
            literals.add(spo.o());
        }
        if (s != null) {
            textIndexer.index(s, this.getTerms(literals).values().iterator());
            ++subjectCount;
            statementCount += (long)literals.size();
            if (log.isInfoEnabled()) {
                log.info((Object)("indexed " + subjectCount + " subjects, " + statementCount + " statements"));
            }
        }
    }

    public final Map<IV<?, ?>, BigdataValue> getTerms(Collection<IV<?, ?>> ivs, int termsChunksSize, int blobsChunkSize) {
        if (ivs == null) {
            throw new IllegalArgumentException();
        }
        int n = ivs.size();
        if (n == 0) {
            return Collections.emptyMap();
        }
        long begin = System.currentTimeMillis();
        ConcurrentHashMap ret = new ConcurrentHashMap(n);
        LinkedList termIVs = new LinkedList();
        LinkedList blobIVs = new LinkedList();
        LinkedHashSet unrequestedSidTerms = new LinkedHashSet();
        for (IV<Object, Object> iv : ivs) {
            if (!(iv instanceof SidIV)) continue;
            this.handleSid((SidIV)iv, ivs, unrequestedSidTerms);
        }
        for (IV<Object, Object> iv : unrequestedSidTerms) {
            ivs.add(iv);
        }
        int numNotFound = 0;
        boolean isDebugEnabled = log.isDebugEnabled();
        for (IV<Object, Object> iv : ivs) {
            if (iv == null) {
                throw new AssertionError();
            }
            if (iv.hasValue()) {
                if (isDebugEnabled) {
                    log.debug((Object)("already materialized: " + iv.getValue()));
                }
                ret.put(iv, (BigdataValue)iv.getValue());
                continue;
            }
            if (iv instanceof SidIV) continue;
            if (iv.isInline()) {
                ret.put(iv, (BigdataValue)iv.asValue(this));
                continue;
            }
            BigdataValue value = this._getTermId(iv);
            if (value != null) {
                assert (value.getValueFactory() == this.valueFactory);
                ret.put(iv, value);
                continue;
            }
            ++numNotFound;
            if (iv instanceof TermId) {
                termIVs.add((TermId)iv);
                continue;
            }
            if (iv instanceof BlobIV) {
                blobIVs.add((BlobIV)iv);
                continue;
            }
            throw new AssertionError((Object)("class=" + iv.getClass().getName()));
        }
        if (numNotFound > 0) {
            ExecutorService service = this.getExecutorService();
            LinkedList<Callable<Void>> tasks = new LinkedList<Callable<Void>>();
            if (!termIVs.isEmpty()) {
                tasks.add(new BatchResolveTermIVsTask(service, this.getId2TermIndex(), termIVs, ret, this.termCache, this.valueFactory, termsChunksSize));
            }
            if (!blobIVs.isEmpty()) {
                tasks.add(new BatchResolveBlobIVsTask(service, this.getBlobsIndex(), blobIVs, ret, this.termCache, this.valueFactory, blobsChunkSize));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("nterms=" + n + ", numNotFound=" + numNotFound + ", cacheSize=" + this.termCache.size()));
            }
            try {
                if (tasks.size() == 1) {
                    ((Callable)tasks.get(0)).call();
                } else {
                    List futures = this.getExecutorService().invokeAll(tasks);
                    for (Future f : futures) {
                        f.get();
                    }
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        for (IV<Object, Object> iv : ivs) {
            if (!(iv instanceof SidIV)) continue;
            this.cacheTerms((SidIV)iv, ret);
            ret.put(iv, (BigdataValue)iv.asValue(this));
        }
        for (IV<Object, Object> iv : unrequestedSidTerms) {
            ivs.remove(iv);
            ret.remove(iv);
        }
        long elapsed = System.currentTimeMillis() - begin;
        if (log.isInfoEnabled()) {
            log.info((Object)("resolved " + numNotFound + " terms: #TermIVs=" + termIVs.size() + ", #BlobIVs=" + blobIVs.size() + " in " + elapsed + "ms"));
        }
        return ret;
    }

    private final void handleSid(SidIV sid, Collection<IV<?, ?>> ivs, Set<IV<?, ?>> unrequested) {
        ISPO spo = sid.getInlineValue();
        this.handleTerm(spo.s(), ivs, unrequested);
        this.handleTerm(spo.p(), ivs, unrequested);
        this.handleTerm(spo.o(), ivs, unrequested);
        if (spo.c() != null) {
            this.handleTerm(spo.c(), ivs, unrequested);
        }
    }

    private final void handleTerm(IV<?, ?> iv, Collection<IV<?, ?>> ivs, Set<IV<?, ?>> unrequested) {
        if (iv instanceof SidIV) {
            this.handleSid((SidIV)iv, ivs, unrequested);
        } else if (!ivs.contains(iv)) {
            unrequested.add(iv);
        }
    }

    private final void cacheTerms(SidIV sid, Map<IV<?, ?>, BigdataValue> terms) {
        ISPO spo = sid.getInlineValue();
        this.cacheTerm(spo.s(), terms);
        this.cacheTerm(spo.p(), terms);
        this.cacheTerm(spo.o(), terms);
        if (spo.c() != null) {
            this.cacheTerm(spo.c(), terms);
        }
    }

    private final void cacheTerm(IV iv, Map<IV<?, ?>, BigdataValue> terms) {
        if (iv instanceof SidIV) {
            this.cacheTerms((SidIV)iv, terms);
        } else {
            iv.setValue(terms.get(iv));
        }
    }

    public static void clearTermCacheFactory(String namespace) {
        Iterator<Map.Entry<NT, WeakReference<ITermCache<IV<?, ?>, BigdataValue>>>> it = termCacheFactory.entryIterator();
        while (it.hasNext()) {
            NT nt = it.next().getKey();
            if (!nt.getName().equals(namespace)) continue;
            it.remove();
        }
    }

    private BigdataValue _getTermId(IV<?, ?> iv) {
        if (iv == null) {
            throw new IllegalArgumentException();
        }
        if (iv.isNullIV()) {
            throw new IllegalArgumentException();
        }
        if (iv.isInline()) {
            throw new IllegalArgumentException();
        }
        if (!this.storeBlankNodes && iv.isBNode()) {
            String id = 't' + ((BNode)iv).getID();
            BigdataBNode bnode = this.valueFactory.createBNode(id);
            bnode.setIV(iv);
            return bnode;
        }
        return this.termCache.get(iv);
    }

    public final BigdataValue getTerm(IV iv) {
        return this.getValue(iv, true);
    }

    private final BigdataValue getValue(IV iv, boolean readFromIndex) {
        if (iv.isInline()) {
            return iv.asValue(this);
        }
        BigdataValue value = this._getTermId(iv);
        if (value != null || !readFromIndex) {
            return value;
        }
        if (iv instanceof BlobIV) {
            return this.__getBlob((BlobIV)iv);
        }
        return this.__getTerm((TermId)iv);
    }

    private BigdataValue __getTerm(TermId<?> iv) {
        Id2TermTupleSerializer tupleSer;
        byte[] key;
        IIndex ndx = this.getId2TermIndex();
        byte[] data = ndx.lookup(key = (tupleSer = (Id2TermTupleSerializer)ndx.getIndexMetadata().getTupleSerializer()).id2key(iv));
        if (data == null) {
            return null;
        }
        BigdataValue value = this.valueFactory.getValueSerializer().deserialize(data);
        value.setIV(iv);
        BigdataValue tmp = this.termCache.putIfAbsent(iv, value);
        if (tmp != null) {
            value = tmp;
        }
        return value;
    }

    private BigdataValue __getBlob(BlobIV<?> iv) {
        BlobsTupleSerializer tupleSer;
        byte[] key;
        IIndex ndx = this.getBlobsIndex();
        byte[] data = ndx.lookup(key = (tupleSer = (BlobsTupleSerializer)ndx.getIndexMetadata().getTupleSerializer()).serializeKey(iv));
        if (data == null) {
            return null;
        }
        BigdataValue value = this.valueFactory.getValueSerializer().deserialize(data);
        value.setIV(iv);
        BigdataValue tmp = this.termCache.putIfAbsent(iv, value);
        if (tmp != null) {
            value = tmp;
        }
        return value;
    }

    public final IV getIV(Value value) {
        IV iv;
        if (value == null) {
            return null;
        }
        if (value instanceof BigdataValue && (iv = ((BigdataValue)value).getIV()) != null) {
            return iv;
        }
        iv = this.getInlineIV(value);
        if (iv != null) {
            return iv;
        }
        iv = this.getTermId(value);
        return iv;
    }

    public final IV getInlineIV(Value value) {
        return this.getLexiconConfiguration().createInlineIV(value);
    }

    private IV<?, ?> getTermId(Value value) {
        if (this.isBlob(value)) {
            return this.getBlobIV(value);
        }
        return this.getTermIV(value);
    }

    private TermId<?> getTermIV(Value value) {
        Term2IdTupleSerializer tupleSer;
        byte[] key;
        IIndex ndx = this.getTerm2IdIndex();
        byte[] tmp = ndx.lookup(key = (tupleSer = (Term2IdTupleSerializer)ndx.getIndexMetadata().getTupleSerializer()).getLexiconKeyBuilder().value2Key(value));
        if (tmp == null) {
            return null;
        }
        TermId iv = (TermId)IVUtility.decode(tmp);
        if (value instanceof BigdataValue) {
            BigdataValue impl = (BigdataValue)value;
            impl.setIV(iv);
            if (impl.getValueFactory() == this.valueFactory && (this.storeBlankNodes || !iv.isBNode())) {
                this.termCache.putIfAbsent(iv, impl);
            }
        }
        return iv;
    }

    private BlobIV<?> getBlobIV(Value value) {
        IKeyBuilder keyBuilder = this.h.newKeyBuilder();
        BigdataValue asValue = this.valueFactory.asValue(value);
        byte[] baseKey = this.h.makePrefixKey(keyBuilder.reset(), asValue);
        byte[] val = this.valueFactory.getValueSerializer().serialize(asValue);
        int counter = this.h.resolveOrAddValue(this.getBlobsIndex(), true, keyBuilder, baseKey, val, null, null);
        if (counter == Integer.MIN_VALUE) {
            return null;
        }
        BlobIV iv = new BlobIV(VTE.valueOf(asValue), asValue.hashCode(), (short)counter);
        if (value instanceof BigdataValue) {
            BigdataValue impl = (BigdataValue)value;
            impl.setIV(iv);
            if (impl.getValueFactory() == this.valueFactory && (this.storeBlankNodes || !iv.isBNode())) {
                this.termCache.putIfAbsent(iv, impl);
            }
        }
        return iv;
    }

    public Iterator<Value> blobsIterator() {
        IIndex ndx = this.getBlobsIndex();
        return new Striterator((Iterator)ndx.rangeIterator(null, null, 0, 2, null)).addFilter((IFilter)new Resolver(){
            private static final long serialVersionUID = 1L;

            protected Object resolve(Object val) {
                return ((ITuple)val).getObject();
            }
        });
    }

    public ILexiconConfiguration<BigdataValue> getLexiconConfiguration() {
        return this.lexiconConfiguration;
    }

    @Override
    public IKeyOrder<BigdataValue> getKeyOrder(IPredicate<BigdataValue> p) {
        IVariableOrConstant t = p.get(1);
        if (t != null) {
            IV iv = (IV)t.get();
            if (iv instanceof TermId) {
                return LexiconKeyOrder.ID2TERM;
            }
            if (iv instanceof BlobIV) {
                return LexiconKeyOrder.BLOBS;
            }
            throw new UnsupportedOperationException(p.toString());
        }
        IVariableOrConstant v = p.get(0);
        if (v != null) {
            BigdataValue value = (BigdataValue)v.get();
            if (this.isBlob(value)) {
                return LexiconKeyOrder.BLOBS;
            }
            return LexiconKeyOrder.TERM2ID;
        }
        throw new UnsupportedOperationException(p.toString());
    }

    @Override
    public IAccessPath<BigdataValue> newAccessPath(IIndexManager localIndexManager, IPredicate<BigdataValue> predicate, IKeyOrder<BigdataValue> keyOrder) {
        LexAccessPatternEnum accessPattern = LexAccessPatternEnum.valueOf(predicate);
        switch (accessPattern) {
            case FullyBound: {
                BigdataValue val = (BigdataValue)predicate.get(0).get();
                IV iv = (IV)predicate.get(1).get();
                if (VTE.valueOf(val) != iv.getVTE()) {
                    return new EmptyAccessPath<BigdataValue>();
                }
                if (val.hashCode() != iv.hashCode()) {
                    return new EmptyAccessPath<BigdataValue>();
                }
            }
            case IVBound: {
                IV iv = (IV)predicate.get(1).get();
                BigdataValue val = this.getValue(iv, false);
                if (val != null) {
                    val.setIV(iv);
                    iv.setValue(val);
                    return new ArrayAccessPath<BigdataValue>(new BigdataValue[]{val}, predicate, keyOrder);
                }
                if (!this.storeBlankNodes && iv.isBNode()) {
                    return new EmptyAccessPath<BigdataValue>();
                }
                CacheValueFilter filter = CacheValueFilter.newInstance();
                IPredicate tmp = (IPredicate)predicate.setProperty(Predicate.Annotations.ACCESS_PATH_FILTER, filter);
                AccessPath<BigdataValue> ap = new AccessPath<BigdataValue>(this, localIndexManager, tmp, keyOrder).init();
                return ap;
            }
            case ValueBound: {
                BigdataValue val = (BigdataValue)predicate.get(0).get();
                IV iv = val.getIV();
                if (iv == null) {
                    iv = this.getInlineIV(val);
                }
                if (iv != null) {
                    val.setIV(iv);
                    iv.setValue(val);
                    return new ArrayAccessPath<BigdataValue>(new BigdataValue[]{val}, predicate, keyOrder);
                }
                CacheValueFilter filter = CacheValueFilter.newInstance();
                IPredicate tmp = (IPredicate)predicate.setProperty(Predicate.Annotations.ACCESS_PATH_FILTER, filter);
                AccessPath<BigdataValue> ap = new AccessPath<BigdataValue>(this, localIndexManager, tmp, keyOrder);
                return ap;
            }
        }
        throw new UnsupportedOperationException("" + (Object)((Object)accessPattern));
    }
}

