/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.literal;

import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataLiteral;
import org.openrdf.model.Literal;

public class XSDBooleanIV<V extends BigdataLiteral>
extends AbstractLiteralIV<V, Boolean>
implements Literal {
    private static final long serialVersionUID = 1L;
    private static final transient XSDBooleanIV<BigdataLiteral> TRUE = new XSDBooleanIV(true);
    private static final transient XSDBooleanIV<BigdataLiteral> FALSE = new XSDBooleanIV(false);
    private final boolean value;

    public static final XSDBooleanIV<BigdataLiteral> valueOf(boolean b) {
        return (XSDBooleanIV)(b ? TRUE : FALSE).clone(true);
    }

    @Override
    public String toString() {
        return super.toString() + " " + (this.hasValue() ? ((BigdataLiteral)this.getValue()).getValueFactory() : "");
    }

    @Override
    public IV<V, Boolean> clone(boolean clearCache) {
        XSDBooleanIV tmp = new XSDBooleanIV(this.value);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public XSDBooleanIV(boolean value) {
        super(DTE.XSDBoolean);
        this.value = value;
    }

    @Override
    public final Boolean getInlineValue() {
        return this.value ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public V asValue(LexiconRelation lex) {
        BigdataLiteral v = (BigdataLiteral)this.getValueCache();
        if (v == null) {
            v = lex.getValueFactory().createLiteral(this.value);
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XSDBooleanIV) {
            return this.value == ((XSDBooleanIV)o).value;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    @Override
    public int byteLength() {
        return 2;
    }

    @Override
    public int _compareTo(IV o) {
        boolean v = ((XSDBooleanIV)o).value;
        return v == this.value ? 0 : (this.value ? 1 : -1);
    }
}

