/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl;

import com.bigdata.btree.keys.IKeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractIV;
import com.bigdata.rdf.internal.impl.AbstractNonInlineExtensionIV;
import com.bigdata.rdf.model.BigdataValue;

public class BlobIV<V extends BigdataValue>
extends AbstractNonInlineExtensionIV<V, Void> {
    private static final long serialVersionUID = 2L;
    private final int hash;
    private final short counter;

    public static final byte toFlags(VTE vte) {
        return AbstractIV.toFlags(vte, false, true, DTE.XSDBoolean);
    }

    @Override
    public IV<V, Void> clone(boolean clearCache) {
        BlobIV tmp = new BlobIV(this.flags, this.hash, this.counter);
        if (!clearCache) {
            tmp.setValue(this.getValueCache());
        }
        return tmp;
    }

    public BlobIV(VTE vte, int hash, short counter) {
        this(BlobIV.toFlags(vte), hash, counter);
    }

    public BlobIV(byte flags, int hash, short counter) {
        super(flags);
        this.hash = hash;
        this.counter = counter;
    }

    public String toString() {
        return "BlobIV(" + this.hashCode() + ":" + this.counter() + ":" + this.getVTE().getCharCode() + ")";
    }

    public static BlobIV<?> fromString(String s) {
        char type = s.charAt(s.length() - 2);
        VTE vte = VTE.valueOf(type);
        String t = s.substring(7, s.length() - 3);
        int pos = t.indexOf(58);
        if (pos == -1) {
            throw new RuntimeException("Not a BlobIV: [" + s + "]");
        }
        String hstr = t.substring(0, pos);
        String cstr = t.substring(pos + 1);
        int hashCode = Integer.valueOf(hstr);
        int counter = Integer.valueOf(cstr);
        BlobIV tmp = new BlobIV(vte, hashCode, (short)counter);
        return tmp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BlobIV) {
            BlobIV t = (BlobIV)o;
            if (this.hash != t.hash) {
                return false;
            }
            if (this.counter != t.counter) {
                return false;
            }
            return this.flags() == t.flags();
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.hash;
    }

    public final int counter() {
        return this.counter;
    }

    @Override
    public final int byteLength() {
        return 8;
    }

    @Override
    public int _compareTo(IV o) {
        BlobIV t = (BlobIV)o;
        if (this.flags < t.flags) {
            return -1;
        }
        if (this.flags > t.flags) {
            return 1;
        }
        if (this.hash < t.hash) {
            return -1;
        }
        if (this.hash > t.hash) {
            return 1;
        }
        if (this.counter < t.counter) {
            return -1;
        }
        if (this.counter > t.counter) {
            return 1;
        }
        return 0;
    }

    @Override
    public final IKeyBuilder encode(IKeyBuilder keyBuilder) {
        keyBuilder.appendSigned(this.flags);
        keyBuilder.appendSigned((byte)0);
        keyBuilder.append(this.hash);
        keyBuilder.append(this.counter);
        return keyBuilder;
    }

    @Override
    public String getID() {
        if (!this.isBNode()) {
            throw new ClassCastException();
        }
        long id = (long)this.flags() << 56 | (long)this.hash << 16 | (long)this.counter;
        String idStr = Long.toString(id);
        return idStr;
    }

    @Override
    public final byte getExtensionByte() {
        return 0;
    }

    @Override
    public IV getExtensionIV() {
        return null;
    }
}

