/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IPrefixedURIHandler;
import com.bigdata.rdf.internal.ISuffixedURIHandler;
import com.bigdata.rdf.internal.InlineLocalNameIntegerURIHandler;
import com.bigdata.rdf.internal.impl.literal.AbstractLiteralIV;
import com.bigdata.rdf.model.BigdataLiteral;

public class InlinePrefixedSuffixedIntegerURIHandler
extends InlineLocalNameIntegerURIHandler
implements IPrefixedURIHandler,
ISuffixedURIHandler {
    private String prefix = null;
    private String suffix = null;

    public InlinePrefixedSuffixedIntegerURIHandler(String namespace, String prefix, String suffix) {
        super(namespace);
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public InlinePrefixedSuffixedIntegerURIHandler(String namespace, String prefix, String suffix, int id) {
        super(namespace);
        this.prefix = prefix;
        this.suffix = suffix;
        this.packedId = id;
    }

    @Override
    protected AbstractLiteralIV createInlineIV(String localName) {
        if (!localName.startsWith(this.prefix) || !localName.endsWith(this.suffix)) {
            return null;
        }
        String intValue = localName.substring(this.prefix.length(), localName.length() - this.suffix.length());
        return super.createInlineIV(this.getPackedValueString(intValue));
    }

    @Override
    public String getLocalNameFromDelegate(AbstractLiteralIV<BigdataLiteral, ?> delegate) {
        return this.prefix + this.getUnpackedValueFromString(super.getLocalNameFromDelegate(delegate)) + this.suffix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }
}

