/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.mdi;

import com.bigdata.io.LongPacker;
import com.bigdata.io.ShortPacker;
import com.bigdata.mdi.IPartitionMetadata;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.IndexPartitionCause;
import com.bigdata.mdi.JournalMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.util.BytesUtil;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.UUID;

public class LocalPartitionMetadata
implements IPartitionMetadata,
Externalizable {
    private static final long serialVersionUID = -1511361004851335936L;
    protected static final transient int MAX_HISTORY_LENGTH = 0;
    private int partitionId;
    private int sourcePartitionId;
    private byte[] leftSeparatorKey;
    private byte[] rightSeparatorKey;
    private IResourceMetadata[] resources;
    private IndexPartitionCause cause;
    private static final transient short VERSION0 = 0;
    private static final transient short VERSION1 = 1;
    private static final transient short VERSION2 = 2;
    private static final transient short VERSION = 2;

    public LocalPartitionMetadata() {
    }

    public LocalPartitionMetadata(int partitionId, int sourcePartitionId, byte[] leftSeparatorKey, byte[] rightSeparatorKey, IResourceMetadata[] resources, IndexPartitionCause cause) {
        int cmp;
        this.partitionId = partitionId;
        this.sourcePartitionId = sourcePartitionId;
        this.leftSeparatorKey = leftSeparatorKey;
        this.rightSeparatorKey = rightSeparatorKey;
        this.resources = resources;
        this.cause = cause;
        if (leftSeparatorKey == null) {
            throw new IllegalArgumentException("leftSeparatorKey");
        }
        if (rightSeparatorKey != null && (cmp = BytesUtil.compareBytes((byte[])leftSeparatorKey, (byte[])rightSeparatorKey)) >= 0) {
            throw new IllegalArgumentException("Separator keys are " + (cmp == 0 ? "equal" : "out of order") + " : " + this);
        }
        if (resources != null) {
            if (resources.length == 0) {
                throw new IllegalArgumentException("Empty resources array.");
            }
            for (IResourceMetadata t : resources) {
                if (t != null) continue;
                throw new IllegalArgumentException("null value in resources[]");
            }
            if (!resources[0].isJournal()) {
                throw new RuntimeException("Expecting a journal as the first resource: " + this);
            }
            boolean checkCreateTimes = false;
        }
    }

    @Override
    public final int getPartitionId() {
        return this.partitionId;
    }

    public final int getSourcePartitionId() {
        return this.sourcePartitionId;
    }

    @Override
    public final byte[] getLeftSeparatorKey() {
        return this.leftSeparatorKey;
    }

    @Override
    public final byte[] getRightSeparatorKey() {
        return this.rightSeparatorKey;
    }

    public final IResourceMetadata[] getResources() {
        return this.resources;
    }

    public final IndexPartitionCause getIndexPartitionCause() {
        return this.cause;
    }

    @Override
    public final int hashCode() {
        return this.partitionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        LocalPartitionMetadata o2 = (LocalPartitionMetadata)o;
        if (this.partitionId != o2.partitionId) {
            return false;
        }
        if (!BytesUtil.bytesEqual((byte[])this.leftSeparatorKey, (byte[])o2.leftSeparatorKey)) {
            return false;
        }
        if (this.rightSeparatorKey == null ? o2.rightSeparatorKey != null : !BytesUtil.bytesEqual((byte[])this.rightSeparatorKey, (byte[])o2.rightSeparatorKey)) {
            return false;
        }
        if (this.resources.length != o2.resources.length) {
            return false;
        }
        for (int i = 0; i < this.resources.length; ++i) {
            if (this.resources[i].equals(o2.resources[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "{ partitionId=" + this.partitionId + (this.sourcePartitionId != -1 ? ", sourcePartitionId=" + this.sourcePartitionId : "") + ", leftSeparator=" + BytesUtil.toString((byte[])this.leftSeparatorKey) + ", rightSeparator=" + BytesUtil.toString((byte[])this.rightSeparatorKey) + ", resourceMetadata=" + Arrays.toString(this.resources) + ", cause=" + this.cause + "}";
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = ShortPacker.unpackShort(in);
        switch (version) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IOException("Unknown version: " + version);
            }
        }
        this.partitionId = version < 2 ? (int)LongPacker.unpackLong(in) : in.readInt();
        this.sourcePartitionId = in.readInt();
        int nresources = ShortPacker.unpackShort(in);
        int leftLen = (int)LongPacker.unpackLong(in);
        int rightLen = (int)LongPacker.unpackLong(in);
        this.leftSeparatorKey = new byte[leftLen];
        in.readFully(this.leftSeparatorKey);
        if (rightLen != 0) {
            this.rightSeparatorKey = new byte[rightLen];
            in.readFully(this.rightSeparatorKey);
        } else {
            this.rightSeparatorKey = null;
        }
        this.cause = (IndexPartitionCause)in.readObject();
        if (version < 2) {
            in.readUTF();
        }
        this.resources = nresources > 0 ? new IResourceMetadata[nresources] : null;
        for (int j = 0; j < nresources; ++j) {
            boolean isIndexSegment = in.readBoolean();
            String filename = in.readUTF();
            UUID uuid = new UUID(in.readLong(), in.readLong());
            long createTime = in.readLong();
            long commitTime = 0L;
            if (version >= 1 && !isIndexSegment) {
                commitTime = in.readLong();
            }
            this.resources[j] = isIndexSegment ? new SegmentMetadata(filename, uuid, createTime) : new JournalMetadata(filename, uuid, createTime, commitTime);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int nresources;
        ShortPacker.packShort(out, (short)2);
        out.writeInt(this.partitionId);
        out.writeInt(this.sourcePartitionId);
        int n = nresources = this.resources == null ? 0 : this.resources.length;
        assert (nresources < Short.MAX_VALUE);
        ShortPacker.packShort(out, (short)nresources);
        LongPacker.packLong(out, (long)this.leftSeparatorKey.length);
        LongPacker.packLong(out, this.rightSeparatorKey == null ? 0L : (long)this.rightSeparatorKey.length);
        out.write(this.leftSeparatorKey);
        if (this.rightSeparatorKey != null) {
            out.write(this.rightSeparatorKey);
        }
        out.writeObject(this.cause);
        for (int j = 0; j < nresources; ++j) {
            IResourceMetadata rmd = this.resources[j];
            boolean isSegment = rmd.isIndexSegment();
            out.writeBoolean(isSegment);
            out.writeUTF(rmd.getFile());
            UUID resourceUUID = rmd.getUUID();
            out.writeLong(resourceUUID.getMostSignificantBits());
            out.writeLong(resourceUUID.getLeastSignificantBits());
            out.writeLong(rmd.getCreateTime());
            if (isSegment) continue;
            out.writeLong(rmd.getCommitTime());
        }
    }
}

