/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io.writecache;

import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.Instrument;
import com.bigdata.counters.OneShotInstrument;
import com.bigdata.io.writecache.IWriteCacheServiceCounters;
import com.bigdata.io.writecache.WriteCacheCounters;
import java.util.concurrent.TimeUnit;

public class WriteCacheServiceCounters
extends WriteCacheCounters
implements IWriteCacheServiceCounters {
    public final int nbuffers;
    public final int dirtyListThreshold;
    public final int compactingThreshold;
    public volatile int ndirty;
    public volatile int nclean;
    public volatile int maxdirty;
    public volatile long nreset;
    public volatile long nsend;
    public volatile long nbufferEvictedToChannel;
    public volatile long elapsedBufferEvictedToChannelNanos;
    public volatile long nrecordsEvictedToChannel;
    public volatile long ncompact;
    public volatile long ncacheWrites;
    public volatile long elapsedCacheWriteNanos;
    public volatile long nclearAddrRequests;
    public volatile long nclearAddrCleared;
    public final CAT nreadNotInstalled = new CAT();
    public final CAT memoCacheSize = new CAT();

    public WriteCacheServiceCounters(int nbuffers, int dirtyListThreshold, int compactingThreshold) {
        this.nbuffers = nbuffers;
        this.dirtyListThreshold = dirtyListThreshold;
        this.compactingThreshold = compactingThreshold;
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = super.getCounters();
        root.addCounter("nbuffers", new OneShotInstrument<Integer>(this.nbuffers));
        root.addCounter("dirtyListThreshold", new OneShotInstrument<Integer>(this.dirtyListThreshold));
        root.addCounter("compactingThreshold", new OneShotInstrument<Integer>(this.compactingThreshold));
        root.addCounter("ndirty", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.ndirty);
            }
        });
        root.addCounter("maxDirty", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.maxdirty);
            }
        });
        root.addCounter("nclean", new Instrument<Integer>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nclean);
            }
        });
        root.addCounter("nreset", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nreset);
            }
        });
        root.addCounter("nsend", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nsend);
            }
        });
        root.addCounter("nbufferEvictToChannel", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nbufferEvictedToChannel);
            }
        });
        root.addCounter("elapsedBufferEvictToChannelNanos", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.elapsedBufferEvictedToChannelNanos);
            }
        });
        root.addCounter("averageBufferEvictToChannelNanos", new Instrument<Double>(){

            @Override
            public void sample() {
                if (WriteCacheServiceCounters.this.nbufferEvictedToChannel > 0L) {
                    double d = WriteCacheServiceCounters.this.elapsedBufferEvictedToChannelNanos / WriteCacheServiceCounters.this.nbufferEvictedToChannel;
                    this.setValue((double)((long)(d * 100.0)) / 100.0);
                }
            }
        });
        root.addCounter("nrecordsEvictedToChannel", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nrecordsEvictedToChannel);
            }
        });
        root.addCounter("averageRecordEvictedToChannelNanos", new Instrument<Double>(){

            @Override
            public void sample() {
                if (WriteCacheServiceCounters.this.nrecordsEvictedToChannel > 0L) {
                    double d = WriteCacheServiceCounters.this.elapsedBufferEvictedToChannelNanos / WriteCacheServiceCounters.this.nrecordsEvictedToChannel;
                    this.setValue((double)((long)(d * 100.0)) / 100.0);
                }
            }
        });
        root.addCounter("averageRandomWritesToChannelPerSecond", new Instrument<Double>(){

            @Override
            public void sample() {
                if (WriteCacheServiceCounters.this.nrecordsEvictedToChannel > 0L) {
                    double d = (double)TimeUnit.NANOSECONDS.toSeconds(WriteCacheServiceCounters.this.elapsedBufferEvictedToChannelNanos) / (double)WriteCacheServiceCounters.this.nrecordsEvictedToChannel;
                    double v = (double)((long)(d * 100.0)) / 100.0;
                    this.setValue(v);
                }
            }
        });
        root.addCounter("ncompact", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.ncompact);
            }
        });
        root.addCounter("ncacheWrites", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.ncacheWrites);
            }
        });
        root.addCounter("elapsedCacheWriteNanos", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.elapsedCacheWriteNanos);
            }
        });
        root.addCounter("averageCacheWriteNanos", new Instrument<Double>(){

            @Override
            public void sample() {
                if (WriteCacheServiceCounters.this.ncacheWrites > 0L) {
                    double d = WriteCacheServiceCounters.this.elapsedCacheWriteNanos / WriteCacheServiceCounters.this.ncacheWrites;
                    this.setValue((double)((long)(d * 100.0)) / 100.0);
                }
            }
        });
        root.addCounter("nclearAddrRequests", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nclearAddrRequests);
            }
        });
        root.addCounter("nclear", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nclearAddrCleared);
            }
        });
        root.addCounter("mbPerSec", new Instrument<Double>(){

            @Override
            public void sample() {
                double mbPerSec = (double)WriteCacheServiceCounters.this.bytesWritten / 1048576.0 / (double)TimeUnit.NANOSECONDS.toSeconds(WriteCacheServiceCounters.this.elapsedWriteNanos);
                this.setValue((double)((long)(mbPerSec * 100.0)) / 100.0);
            }
        });
        root.addCounter("nreadNotInstalled", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.nreadNotInstalled.get());
            }
        });
        root.addCounter("memoCacheSize", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(WriteCacheServiceCounters.this.memoCacheSize.get());
            }
        });
        return root;
    }
}

