/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.IHistoryEntry;
import com.bigdata.counters.query.HistoryTable;
import com.bigdata.counters.query.QueryUtil;
import com.bigdata.counters.render.HistoryTableRenderer;
import com.bigdata.counters.render.ValueFormatter;
import com.bigdata.counters.render.XHTMLRenderer;
import java.io.IOException;
import java.io.Writer;
import java.util.regex.Pattern;

public class HTMLHistoryTableRenderer
extends HistoryTableRenderer {
    public HTMLHistoryTableRenderer(HistoryTable tbl, Pattern pattern, ValueFormatter formatter) {
        super(tbl, pattern, formatter);
    }

    @Override
    public void render(Writer w) throws IOException {
        String summary = "Showing samples: period=" + this.t.units;
        w.write("<table border=\"1\" summary=\"" + this.attrib(summary) + "\"\n>");
        w.write(" <tr\n>");
        w.write("  <th></th\n>");
        w.write("  <th>From: " + this.cdata(this.formatter.date(this.t.firstTimestamp)) + "</th\n>");
        w.write("  <th colspan=\"*\">To: " + this.cdata(this.formatter.date(this.t.lastTimestamp)) + "</th\n>");
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th></th\n>");
        for (ICounter counter : this.t.a) {
            w.write("  <th colspan=\"*\">");
            this.formatter.writeFullPath(w, counter.getPath());
            w.write("  </th\n>");
        }
        w.write(" </tr\n>");
        w.write(" <tr\n>");
        w.write("  <th>Timestamp</th>\n");
        for (ICounter counter : this.t.a) {
            String label;
            String[] groups = QueryUtil.getCapturedGroups(this.pattern, counter);
            if (groups != null) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < groups.length; ++i) {
                    String s = groups[i];
                    if (i > 0) {
                        sb.append(":");
                    }
                    sb.append(s);
                }
                label = sb.toString();
            } else {
                label = counter.getName();
            }
            w.write("  <th>" + this.cdata(label) + "</th\n>");
        }
        w.write(" </tr\n>");
        for (int row = 0; row < this.t.nrows; ++row) {
            String[] valStr = new String[this.t.a.length];
            for (int col = 0; col < this.t.ncols; ++col) {
                ICounter c = this.t.a[col];
                IHistoryEntry e = this.t.data[row][col];
                valStr[col] = this.formatter.value(c, e == null ? "" : e.getValue());
            }
            long timestamp = this.t.getTimestamp(row);
            w.write(" <tr\n>");
            w.write("  <td>" + this.cdata(this.formatter.date(timestamp)) + "</td\n>");
            for (String s : valStr) {
                w.write("  <td>" + s + "</td\n>");
            }
            w.write(" </tr\n>");
        }
        w.write("</table\n>");
    }

    protected String cdata(String s) {
        return XHTMLRenderer.cdata(s);
    }

    protected String attrib(String s) {
        return XHTMLRenderer.attrib(s);
    }
}

