/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.DefaultInstrumentFactory;
import com.bigdata.counters.store.CounterSetBTree;
import com.bigdata.journal.Journal;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class CounterSetLoader {
    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        Properties properties = new Properties();
        properties.setProperty(Journal.Options.FILE, "counters.jnl");
        Journal store = new Journal(properties);
        CounterSetBTree btree = (CounterSetBTree)store.getIndex("counters");
        if (btree == null) {
            btree = CounterSetBTree.create(store);
            store.registerIndex("counters", btree);
            store.commit();
        }
        for (String s : args) {
            File file = new File(s);
            CounterSetLoader.loadFile(btree, file);
        }
        System.err.println("There are " + btree.rangeCount() + " counter values covering " + new Date(btree.getFirstTimestamp()) + " to " + new Date(btree.getLastTimestamp()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFile(CounterSetBTree btree, File file) throws IOException, ParserConfigurationException, SAXException {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (!f.isFile()) continue;
                CounterSetLoader.loadFile(btree, f);
            }
            return;
        }
        CounterSet counterSet = new CounterSet();
        System.out.println("reading file: " + file);
        try (InputStream is = null;){
            is = new BufferedInputStream(new FileInputStream(file));
            counterSet.readXML(is, DefaultInstrumentFactory.NO_OVERWRITE_60M, null);
        }
        System.out.println("Writing counters on store.");
        btree.writeHistory(counterSet.getCounters(null));
        ((Journal)btree.getStore()).commit();
    }
}

