/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.osx;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.PIDUtil;
import com.bigdata.counters.osx.IOStatCollector;
import com.bigdata.counters.osx.VMStatCollector;

public class StatisticsCollectorForOSX
extends AbstractStatisticsCollector {
    protected static int pid = PIDUtil.getLinuxPIDWithBash();
    private IOStatCollector iostat;
    private VMStatCollector vmstat;

    @Override
    public void start() {
        if (log.isInfoEnabled()) {
            log.info((Object)"starting collectors");
        }
        super.start();
        if (this.iostat != null) {
            try {
                this.iostat.start();
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
        if (this.vmstat != null) {
            try {
                this.vmstat.start();
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
    }

    @Override
    public void stop() {
        if (log.isInfoEnabled()) {
            log.info((Object)"stopping collectors");
        }
        super.stop();
        if (this.iostat != null) {
            try {
                this.iostat.stop();
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
        if (this.vmstat != null) {
            try {
                this.vmstat.stop();
            }
            catch (Throwable t) {
                log.error((Object)t, t);
            }
        }
    }

    @Override
    public CounterSet getCounters() {
        CounterSet root = super.getCounters();
        if (this.iostat != null) {
            root.makePath(fullyQualifiedHostName).attach(this.iostat.getCounters());
        }
        if (this.vmstat != null) {
            root.makePath(fullyQualifiedHostName).attach(this.vmstat.getCounters());
        }
        return root;
    }

    public StatisticsCollectorForOSX(int interval, String processName) {
        super(interval, processName);
        this.iostat = new IOStatCollector(interval, true);
        this.vmstat = new VMStatCollector(interval);
    }
}

