/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph.rto;

import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.joinGraph.rto.EdgeSample;
import com.bigdata.bop.joinGraph.rto.EstimateEnum;
import com.bigdata.bop.joinGraph.rto.JoinGraph;
import com.bigdata.bop.joinGraph.rto.SampleBase;
import com.bigdata.bop.joinGraph.rto.Vertex;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpRTO;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Path {
    final Vertex[] vertices;
    private final IPredicate<?>[] preds;
    EdgeSample edgeSample;
    public final long sumEstCard;
    public final long sumEstRead;
    public final long sumEstCost;

    public int getNewLimit(int limitIn) {
        if (this.edgeSample.estimateEnum == EstimateEnum.Underflow) {
            return this.edgeSample.limit * 2;
        }
        return this.edgeSample.limit + limitIn;
    }

    private static long getCost(long sumEstRead, long sumEstCard) {
        long total = sumEstCard;
        return total;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Path{[");
        boolean first = true;
        for (Vertex v : this.vertices) {
            if (!first) {
                sb.append(",");
            }
            sb.append(v.pred.getId());
            first = false;
        }
        sb.append("]");
        sb.append(",sumEstRead=" + this.sumEstRead);
        sb.append(",sumEstCard=" + this.sumEstCard);
        sb.append(",sumEstCost=" + this.sumEstCost);
        sb.append(",sample=" + this.edgeSample);
        sb.append("}");
        return sb.toString();
    }

    public Path(Vertex v0, Vertex v1, EdgeSample edgeSample) {
        if (v0 == null) {
            throw new IllegalArgumentException();
        }
        if (v1 == null) {
            throw new IllegalArgumentException();
        }
        if (v0.sample == null) {
            throw new IllegalArgumentException();
        }
        if (edgeSample == null) {
            throw new IllegalArgumentException();
        }
        if (edgeSample.getSample() == null) {
            throw new IllegalArgumentException();
        }
        this.vertices = new Vertex[]{v0, v1};
        this.preds = Path.getPredicates(this.vertices);
        this.edgeSample = edgeSample;
        this.sumEstRead = v0.sample.estCard + edgeSample.estRead;
        this.sumEstCard = edgeSample.estCard;
        this.sumEstCost = Path.getCost(this.sumEstRead, this.sumEstCard);
    }

    private Path(Vertex[] vertices, IPredicate<?>[] preds, EdgeSample edgeSample, long sumEstCard, long sumEstRead) {
        if (vertices == null) {
            throw new IllegalArgumentException();
        }
        if (preds == null) {
            throw new IllegalArgumentException();
        }
        if (vertices.length != preds.length) {
            throw new IllegalArgumentException();
        }
        if (sumEstCard < 0L) {
            throw new IllegalArgumentException();
        }
        if (edgeSample == null) {
            throw new IllegalArgumentException();
        }
        if (edgeSample.getSample() == null) {
            throw new IllegalArgumentException();
        }
        this.vertices = vertices;
        this.preds = preds;
        this.edgeSample = edgeSample;
        this.sumEstCard = sumEstCard;
        this.sumEstRead = sumEstRead;
        this.sumEstCost = Path.getCost(this.sumEstRead, this.sumEstCard);
    }

    public int getVertexCount() {
        return this.vertices.length;
    }

    public boolean contains(Vertex v) {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        for (Vertex x : this.vertices) {
            if (v != x) continue;
            return true;
        }
        return false;
    }

    public boolean isUnorderedVariant(Path p) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        if (this.vertices.length != p.vertices.length) {
            return false;
        }
        Vertex[] v1 = this.vertices;
        Vertex[] v2 = p.vertices;
        if (v1.length != v2.length) {
            return false;
        }
        for (int i = 0; i < v2.length; ++i) {
            Vertex tmp = v2[i];
            boolean found = false;
            for (int j = 0; j < v1.length; ++j) {
                if (v1[j] != tmp) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public List<Vertex> getVertices() {
        return Collections.unmodifiableList(Arrays.asList(this.vertices));
    }

    public IPredicate<?>[] getPredicates() {
        return this.preds;
    }

    public int[] getVertexIds() {
        return BOpUtility.getPredIds(this.preds);
    }

    private static IPredicate<?>[] getPredicates(Vertex[] vertices) {
        IPredicate[] preds = new IPredicate[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            preds[i] = vertices[i].pred;
        }
        return preds;
    }

    public boolean beginsWith(Path p) {
        if (p == null) {
            throw new IllegalArgumentException();
        }
        if (this.vertices.length < p.vertices.length) {
            return false;
        }
        for (int i = 0; i < p.vertices.length; ++i) {
            Vertex vSelf = this.vertices[i];
            Vertex vOther = p.vertices[i];
            if (vSelf == vOther) continue;
            return false;
        }
        return true;
    }

    public boolean beginsWith(int[] ids) {
        if (ids == null) {
            throw new IllegalArgumentException();
        }
        if (this.vertices.length < ids.length) {
            return false;
        }
        for (int i = 0; i < ids.length; ++i) {
            int idOther;
            int idSelf = this.vertices[i].pred.getId();
            if (idSelf == (idOther = ids[i])) continue;
            return false;
        }
        return true;
    }

    public IPredicate<?>[] getPathSegment(int length) {
        if (length > this.preds.length) {
            throw new IllegalArgumentException();
        }
        IPredicate[] preds2 = new IPredicate[length];
        System.arraycopy(this.preds, 0, preds2, 0, length);
        return preds2;
    }

    public Path addEdge(QueryEngine queryEngine, JoinGraph joinGraph, int limit, Vertex vnew, IConstraint[] constraints, boolean pathIsComplete) throws Exception {
        if (vnew == null) {
            throw new IllegalArgumentException();
        }
        if (this.contains(vnew)) {
            throw new IllegalArgumentException("Vertex already present in path: vnew=" + vnew + ", path=" + this);
        }
        if (this.edgeSample == null) {
            throw new IllegalStateException();
        }
        Vertex targetVertex = vnew;
        IPredicate[] preds2 = new IPredicate[this.preds.length + 1];
        Vertex[] vertices2 = new Vertex[this.preds.length + 1];
        System.arraycopy(this.preds, 0, preds2, 0, this.preds.length);
        System.arraycopy(this.vertices, 0, vertices2, 0, this.preds.length);
        preds2[this.preds.length] = targetVertex.pred;
        vertices2[this.preds.length] = targetVertex;
        EdgeSample edgeSample2 = AST2BOpRTO.cutoffJoin(queryEngine, joinGraph, limit, preds2, constraints, pathIsComplete, this.edgeSample);
        Path tmp = new Path(vertices2, preds2, edgeSample2, this.sumEstCard + edgeSample2.estCard, this.sumEstRead + edgeSample2.estRead);
        return tmp;
    }

    public static EdgeSample cutoffJoin(QueryEngine queryEngine, JoinGraph joinGraph, int limit, IPredicate<?>[] path, IConstraint[] constraints, boolean pathIsComplete, SampleBase sourceSample) throws Exception {
        return AST2BOpRTO.cutoffJoin(queryEngine, joinGraph, limit, path, constraints, pathIsComplete, sourceSample);
    }
}

