/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.join;

import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.Constant;
import com.bigdata.bop.HashMapAnnotations;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.controller.INamedSolutionSetRef;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.join.HashIndexOp;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.IHashJoinUtility;
import com.bigdata.bop.join.IHashJoinUtilityFactory;
import com.bigdata.bop.join.JVMHashIndex;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.bop.join.UnconstrainedJoinException;
import com.bigdata.counters.CAT;
import com.bigdata.rdf.internal.impl.literal.XSDBooleanIV;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.relation.accesspath.BufferClosedException;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.util.InnerCause;
import cutthecrap.utils.striterators.Expander;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Resolver;
import cutthecrap.utils.striterators.Striterator;
import cutthecrap.utils.striterators.Visitor;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class JVMHashJoinUtility
implements IHashJoinUtility {
    private static final Logger log = Logger.getLogger(JVMHashJoinUtility.class);
    public static final IHashJoinUtilityFactory factory = new IHashJoinUtilityFactory(){
        private static final long serialVersionUID = 1L;

        @Override
        public IHashJoinUtility create(BOpContext<IBindingSet> context, INamedSolutionSetRef namedSetRef, PipelineOp op, JoinTypeEnum joinType) {
            return new JVMHashJoinUtility(op, joinType);
        }
    };
    protected final AtomicBoolean open = new AtomicBoolean(true);
    protected final JoinTypeEnum joinType;
    protected final IVariable<?> askVar;
    protected final IVariable<?>[] joinVars;
    protected final IVariable<?>[] selectVars;
    protected boolean outputDistinctJVs = false;
    protected final IConstraint[] constraints;
    protected final AtomicReference<JVMHashIndex> rightSolutionsRef = new AtomicReference();
    protected final CAT rightSolutionCount = new CAT();
    private final long noJoinVarsLimit = Long.MAX_VALUE;
    protected final CAT nleftConsidered = new CAT();
    protected final CAT nrightConsidered = new CAT();
    protected final CAT nJoinsConsidered = new CAT();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{open=" + this.open);
        sb.append(",joinType=" + (Object)((Object)this.joinType));
        if (this.askVar != null) {
            sb.append(",askVar=" + this.askVar);
        }
        sb.append(",joinVars=" + Arrays.toString(this.joinVars));
        sb.append(",outputDistinctJVs=" + this.outputDistinctJVs);
        if (this.selectVars != null) {
            sb.append(",selectVars=" + Arrays.toString(this.selectVars));
        }
        if (this.constraints != null) {
            sb.append(",constraints=" + Arrays.toString(this.constraints));
        }
        sb.append(",size=" + this.getRightSolutionCount());
        sb.append(",considered(left=" + this.nleftConsidered + ",right=" + this.nrightConsidered + ",joins=" + this.nJoinsConsidered + ")");
        sb.append("}");
        return sb.toString();
    }

    public JVMHashJoinUtility(PipelineOp op, JoinTypeEnum joinType) {
        boolean indexSolutionsHavingUnboundJoinVars;
        if (op == null) {
            throw new IllegalArgumentException();
        }
        if (joinType == null) {
            throw new IllegalArgumentException();
        }
        this.joinType = joinType;
        boolean filter = joinType == JoinTypeEnum.Filter;
        switch (joinType) {
            case Normal: 
            case Exists: {
                indexSolutionsHavingUnboundJoinVars = false;
                break;
            }
            case Optional: 
            case NotExists: 
            case Filter: {
                indexSolutionsHavingUnboundJoinVars = true;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.askVar = (IVariable)op.getProperty(HashJoinAnnotations.ASK_VAR);
        this.joinVars = (IVariable[])op.getRequiredProperty(HashJoinAnnotations.JOIN_VARS);
        this.selectVars = filter ? this.joinVars : (IVariable[])op.getProperty(JoinAnnotations.SELECT);
        this.outputDistinctJVs = op.getProperty(HashIndexOp.Annotations.OUTPUT_DISTINCT_JVs, false);
        this.constraints = (IConstraint[])op.getProperty(JoinAnnotations.CONSTRAINTS);
        IVariable<?>[] keyVars = filter ? (IVariable[])op.getProperty(JoinAnnotations.SELECT) : this.joinVars;
        this.rightSolutionsRef.set(new JVMHashIndex(keyVars, indexSolutionsHavingUnboundJoinVars, new LinkedHashMap<JVMHashIndex.Key, JVMHashIndex.Bucket>(op.getProperty(HashMapAnnotations.INITIAL_CAPACITY, 16), op.getProperty(HashMapAnnotations.LOAD_FACTOR, Float.valueOf(0.75f)).floatValue())));
    }

    @Override
    public JoinTypeEnum getJoinType() {
        return this.joinType;
    }

    @Override
    public IVariable<?> getAskVar() {
        return this.askVar;
    }

    @Override
    public IVariable<?>[] getJoinVars() {
        return this.joinVars;
    }

    @Override
    public IVariable<?>[] getSelectVars() {
        return this.selectVars;
    }

    @Override
    public boolean isOutputDistinctJoinVars() {
        return this.outputDistinctJVs;
    }

    @Override
    public IConstraint[] getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean isEmpty() {
        return this.getRightSolutionCount() == 0L;
    }

    protected long getNoJoinVarsLimit() {
        return Long.MAX_VALUE;
    }

    protected JVMHashIndex getRightSolutions() {
        return this.rightSolutionsRef.get();
    }

    @Override
    public long getRightSolutionCount() {
        return this.rightSolutionCount.get();
    }

    @Override
    public void release() {
        if (this.open.compareAndSet(true, false)) {
            return;
        }
        this.rightSolutionsRef.set(null);
    }

    @Override
    public long acceptSolutions(ICloseableIterator<IBindingSet[]> itr, BOpStats stats) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        try {
            JVMHashIndex index = this.getRightSolutions();
            IBindingSet[] all = BOpUtility.toArray(itr, stats);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Materialized: " + all.length + " source solutions."));
            }
            long naccepted = 0L;
            for (IBindingSet bset : all) {
                if (index.add(bset) == null) continue;
                ++naccepted;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("There are " + index.bucketCount() + " hash buckets, joinVars=" + Arrays.toString(this.joinVars)));
            }
            this.rightSolutionCount.add(naccepted);
            return naccepted;
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public long filterSolutions(ICloseableIterator<IBindingSet[]> itr, BOpStats stats, IBuffer<IBindingSet> sink) {
        try {
            JVMHashIndex index = this.getRightSolutions();
            IBindingSet[] all = BOpUtility.toArray(itr, stats);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Materialized: " + all.length + " source solutions."));
            }
            for (IBindingSet bset : all) {
                if (!index.addDistinct(bset = bset.copy(this.joinVars))) continue;
                sink.add(bset);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("There are " + index.bucketCount() + " hash buckets, joinVars=" + Arrays.toString(this.joinVars)));
            }
            long naccepted = all.length;
            this.rightSolutionCount.add(naccepted);
            return naccepted;
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public void hashJoin(ICloseableIterator<IBindingSet[]> leftItr, BOpStats stats, IBuffer<IBindingSet> outputBuffer) {
        this.hashJoin2(leftItr, stats, outputBuffer, this.constraints);
    }

    @Override
    public void hashJoin2(ICloseableIterator<IBindingSet[]> leftItr, BOpStats stats, IBuffer<IBindingSet> outputBuffer, IConstraint[] constraints) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        JVMHashIndex rightSolutions = this.getRightSolutions();
        if (log.isInfoEnabled()) {
            log.info((Object)("rightSolutions: #buckets=" + rightSolutions.bucketCount() + ",#solutions=" + this.getRightSolutionCount()));
        }
        boolean noJoinVars = this.joinVars.length == 0;
        try {
            while (leftItr.hasNext()) {
                IBindingSet[] leftChunk = (IBindingSet[])leftItr.next();
                if (stats != null) {
                    stats.chunksIn.increment();
                    stats.unitsIn.add(leftChunk.length);
                }
                for (IBindingSet left : leftChunk) {
                    JVMHashIndex.Bucket bucket;
                    this.nleftConsidered.increment();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Considering " + left));
                    }
                    if ((bucket = rightSolutions.getBucket(left)) == null) continue;
                    block13: for (JVMHashIndex.SolutionHit right : bucket) {
                        this.nrightConsidered.increment();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Join with " + right));
                        }
                        this.nJoinsConsidered.increment();
                        if (noJoinVars && this.nJoinsConsidered.get() == Long.MAX_VALUE && this.nleftConsidered.get() > 1L && this.nrightConsidered.get() > 1L) {
                            throw new UnconstrainedJoinException();
                        }
                        IBindingSet outSolution = BOpContext.bind(right.solution, left, constraints, this.selectVars);
                        switch (this.joinType) {
                            case Normal: {
                                if (outSolution == null) continue block13;
                                this.outputSolution(outputBuffer, outSolution);
                                continue block13;
                            }
                            case Optional: {
                                if (outSolution == null) continue block13;
                                this.outputSolution(outputBuffer, outSolution);
                                right.nhits.increment();
                                continue block13;
                            }
                            case Exists: {
                                if (outSolution == null) continue block13;
                                right.nhits.increment();
                                continue block13;
                            }
                            case NotExists: {
                                if (outSolution == null) continue block13;
                                right.nhits.increment();
                                continue block13;
                            }
                        }
                        throw new AssertionError();
                    }
                }
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
        finally {
            leftItr.close();
        }
    }

    @Override
    public void saveSolutionSet() {
    }

    protected void outputSolution(IBuffer<IBindingSet> outputBuffer, IBindingSet outSolution) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Output solution: " + outSolution));
        }
        outputBuffer.add(outSolution);
    }

    @Override
    public void outputOptionals(IBuffer<IBindingSet> outputBuffer) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        try {
            Constant<XSDBooleanIV<BigdataLiteral>> f = this.askVar == null ? null : new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.valueOf(false));
            JVMHashIndex rightSolutions = this.getRightSolutions();
            IVariable<?>[] selected = this.getSelectVars();
            if (log.isInfoEnabled()) {
                log.info((Object)("rightSolutions: #buckets=" + rightSolutions.bucketCount()));
            }
            Iterator<JVMHashIndex.Bucket> bitr = rightSolutions.buckets();
            while (bitr.hasNext()) {
                JVMHashIndex.Bucket b = bitr.next();
                for (JVMHashIndex.SolutionHit hit : b) {
                    if (hit.nhits.get() > 0L) continue;
                    IBindingSet bs = hit.solution;
                    if (selected != null) {
                        bs = bs.copy(selected);
                    }
                    if (f != null) {
                        if (bs == hit.solution) {
                            bs = bs.clone();
                        }
                        bs.set(this.askVar, f);
                    }
                    outputBuffer.add(bs);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Optional solution: " + bs));
                }
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public ICloseableIterator<IBindingSet> indexScan() {
        try {
            JVMHashIndex rightSolutions = this.getRightSolutions();
            if (log.isInfoEnabled()) {
                log.info((Object)("rightSolutions: #buckets=" + rightSolutions.bucketCount()));
            }
            Striterator itr = new Striterator(rightSolutions.buckets());
            itr = itr.addFilter((IFilter)new Expander(){
                private static final long serialVersionUID = 1L;

                protected Iterator expand(Object obj) {
                    JVMHashIndex.Bucket b = (JVMHashIndex.Bucket)obj;
                    return b.iterator();
                }
            });
            itr = itr.addFilter((IFilter)new Resolver(){
                private static final long serialVersionUID = 1L;

                protected Object resolve(Object obj) {
                    IBindingSet bs = ((JVMHashIndex.SolutionHit)obj).solution;
                    return bs;
                }
            });
            return (ICloseableIterator)itr;
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public void outputSolutions(IBuffer<IBindingSet> out) {
        if (!this.open.get()) {
            throw new IllegalStateException();
        }
        try {
            JVMHashIndex rightSolutions = this.getRightSolutions();
            IVariable<?>[] selected = this.getSelectVars();
            if (log.isInfoEnabled()) {
                log.info((Object)("rightSolutions: #buckets=" + rightSolutions.bucketCount()));
            }
            Iterator<JVMHashIndex.Bucket> bucketIterator = rightSolutions.buckets();
            while (bucketIterator.hasNext()) {
                JVMHashIndex.Bucket bucket = bucketIterator.next();
                HashSet<IBindingSet> distinctSet = this.outputDistinctJVs ? new HashSet<IBindingSet>() : null;
                for (JVMHashIndex.SolutionHit solutionHit : bucket) {
                    IBindingSet bs = solutionHit.solution;
                    if (this.outputDistinctJVs) {
                        if (!distinctSet.add(bs = bs.copy(this.joinVars))) {
                            continue;
                        }
                    } else if (selected != null) {
                        bs = bs.copy(selected);
                    }
                    out.add(bs);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Output solution: " + bs));
                }
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    @Override
    public void outputJoinSet(IBuffer<IBindingSet> outputBuffer) {
        try {
            Constant<XSDBooleanIV<BigdataLiteral>> t = this.askVar == null ? null : new Constant<XSDBooleanIV<BigdataLiteral>>(XSDBooleanIV.valueOf(true));
            JVMHashIndex rightSolutions = this.getRightSolutions();
            IVariable<?>[] selected = this.getSelectVars();
            if (log.isInfoEnabled()) {
                log.info((Object)("rightSolutions: #buckets=" + rightSolutions.bucketCount()));
            }
            Iterator<JVMHashIndex.Bucket> bitr = rightSolutions.buckets();
            while (bitr.hasNext()) {
                JVMHashIndex.Bucket b = bitr.next();
                for (JVMHashIndex.SolutionHit hit : b) {
                    if (hit.nhits.get() == 0L) continue;
                    IBindingSet bs = hit.solution;
                    if (selected != null) {
                        bs = bs.copy(selected);
                    }
                    if (t != null) {
                        if (bs == hit.solution) {
                            bs = bs.clone();
                        }
                        bs.set(this.askVar, t);
                    }
                    outputBuffer.add(bs);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Output solution: " + bs));
                }
            }
        }
        catch (Throwable t) {
            throw this.launderThrowable(t);
        }
    }

    static IConstraint[] combineConstraints(IConstraint[] constraints, IHashJoinUtility[] all) {
        LinkedList<IConstraint> list = new LinkedList<IConstraint>();
        for (int i = 0; i < all.length; ++i) {
            IHashJoinUtility tmp = all[i];
            if (tmp.getConstraints() == null) continue;
            list.addAll(Arrays.asList(tmp.getConstraints()));
        }
        if (constraints != null) {
            list.addAll(Arrays.asList(constraints));
        }
        return list.isEmpty() ? null : list.toArray(new IConstraint[list.size()]);
    }

    private static boolean advanceOtherSources(JVMHashIndex.Bucket[][] sortedSourceBuckets, int[] sourceIndex, JVMHashIndex.Bucket[] currentBucket, boolean optional) {
        JVMHashIndex.Bucket firstBucket = sortedSourceBuckets[0][sourceIndex[0]];
        int hashCode = firstBucket.hashCode();
        currentBucket[0] = firstBucket;
        block0: for (int i = 1; i < sourceIndex.length; ++i) {
            JVMHashIndex.Bucket otherBucket;
            while (true) {
                int j;
                if ((j = sourceIndex[i]) >= sortedSourceBuckets[i].length) {
                    if (!optional) {
                        return false;
                    }
                    otherBucket = null;
                } else {
                    otherBucket = sortedSourceBuckets[i][j];
                }
                if (otherBucket == null) {
                    assert (optional);
                    currentBucket[i] = null;
                    continue block0;
                }
                if (otherBucket.hashCode() >= hashCode) break;
                int n = i;
                sourceIndex[n] = sourceIndex[n] + 1;
            }
            if (otherBucket.hashCode() > hashCode) {
                if (!optional) {
                    return false;
                }
                currentBucket[i] = null;
                continue;
            }
            currentBucket[i] = otherBucket;
        }
        return true;
    }

    @Override
    public void mergeJoin(IHashJoinUtility[] others, IBuffer<IBindingSet> outputBuffer, IConstraint[] constraints, boolean optional) {
        if (others == null) {
            throw new IllegalArgumentException();
        }
        if (others.length == 0) {
            throw new IllegalArgumentException();
        }
        if (outputBuffer == null) {
            throw new IllegalArgumentException();
        }
        IHashJoinUtility[] all = new JVMHashJoinUtility[others.length + 1];
        all[0] = this;
        for (int i = 0; i < others.length; ++i) {
            JVMHashJoinUtility o = (JVMHashJoinUtility)others[i];
            if (o == null) {
                throw new IllegalArgumentException();
            }
            if (!Arrays.equals(this.joinVars, o.joinVars)) {
                throw new IllegalArgumentException();
            }
            all[i + 1] = o;
        }
        if (this.isEmpty()) {
            return;
        }
        IConstraint[] c = JVMHashJoinUtility.combineConstraints(constraints, all);
        JVMHashIndex.Bucket[][] sortedSourceBuckets = new JVMHashIndex.Bucket[all.length][];
        for (int i = 0; i < all.length; ++i) {
            Object[] t = ((JVMHashJoinUtility)all[i]).getRightSolutions().toArray();
            Arrays.sort(t);
            sortedSourceBuckets[i] = t;
        }
        int[] sourceIndex = new int[all.length];
        JVMHashIndex.Bucket[] currentBucket = new JVMHashIndex.Bucket[all.length];
        while (sourceIndex[0] < sortedSourceBuckets[0].length) {
            if (!optional) {
                for (int i = 1; i < sourceIndex.length; ++i) {
                    if (sourceIndex[i] < sortedSourceBuckets[i].length) continue;
                    return;
                }
            }
            if (JVMHashJoinUtility.advanceOtherSources(sortedSourceBuckets, sourceIndex, currentBucket, optional)) {
                JVMHashJoinUtility.mergeJoin(currentBucket, c, optional, outputBuffer);
            }
            sourceIndex[0] = sourceIndex[0] + 1;
        }
    }

    private static void mergeJoin(JVMHashIndex.Bucket[] currentBucket, IConstraint[] constraints, boolean optional, IBuffer<IBindingSet> outputBuffer) {
        int nsources = currentBucket.length;
        JVMHashIndex.Bucket firstBucket = currentBucket[0];
        assert (firstBucket != null);
        for (int i = 1; i < nsources; ++i) {
            JVMHashIndex.Bucket otherBucket = currentBucket[i];
            if (otherBucket == null ? !$assertionsDisabled && !optional : !$assertionsDisabled && firstBucket.hashCode() != otherBucket.hashCode()) {
                throw new AssertionError();
            }
        }
        final JVMHashIndex.SolutionHit[] set = new JVMHashIndex.SolutionHit[nsources];
        Striterator sols1 = new Striterator(firstBucket.iterator());
        sols1.addFilter((IFilter)new Visitor(){
            private static final long serialVersionUID = 1L;

            protected void visit(Object obj) {
                set[0] = (JVMHashIndex.SolutionHit)obj;
            }
        });
        for (int i = 1; i < nsources; ++i) {
            final int slot = i;
            final JVMHashIndex.Bucket otherBucket = currentBucket[i];
            if (optional && (otherBucket == null || otherBucket.isEmpty())) continue;
            sols1.addFilter((IFilter)new Expander(){
                private static final long serialVersionUID = 1L;

                protected Iterator<?> expand(Object obj) {
                    return otherBucket.iterator();
                }
            });
            sols1.addFilter((IFilter)new Visitor(){
                private static final long serialVersionUID = 1L;

                protected void visit(Object obj) {
                    set[slot] = (JVMHashIndex.SolutionHit)obj;
                }
            });
        }
        while (sols1.hasNext()) {
            sols1.next();
            IBindingSet in = set[0].solution;
            for (int i = 1; i < set.length; ++i) {
                if (set[i] != null) {
                    in = BOpContext.bind(in, set[i].solution, constraints, null);
                }
                if (in == null) break;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Output solution: " + in));
            }
            if (in == null) continue;
            outputBuffer.add(in);
        }
    }

    private RuntimeException launderThrowable(Throwable t) {
        String msg = "cause=" + t + ", state=" + this.toString();
        if (!InnerCause.isInnerCause((Throwable)t, InterruptedException.class) && !InnerCause.isInnerCause((Throwable)t, BufferClosedException.class)) {
            log.error((Object)msg, t);
        }
        return new RuntimeException(msg, t);
    }
}

