/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop;

import com.bigdata.bop.BOp;
import com.bigdata.bop.CoreBaseBOp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ModifiableBOpBase
extends CoreBaseBOp {
    private static final long serialVersionUID = 1L;
    private final ArrayList<BOp> args;
    private final Map<String, Object> annotations;

    public ModifiableBOpBase(ModifiableBOpBase op) {
        this.args = new ArrayList<BOp>(op.args);
        this.annotations = new LinkedHashMap<String, Object>(op.annotations);
    }

    public ModifiableBOpBase(BOp[] args, Map<String, Object> annotations) {
        if (args == null) {
            throw new IllegalArgumentException();
        }
        this.checkArgs(args);
        this.args = new ArrayList(args.length);
        for (BOp t : args) {
            this.args.add(t);
        }
        this.annotations = annotations == null ? new LinkedHashMap(2) : annotations;
    }

    public final Map<String, Object> annotations() {
        return this.annotations;
    }

    @Override
    protected boolean annotationsEqual(BOp o) {
        if (o instanceof ModifiableBOpBase) {
            return ModifiableBOpBase.annotationsEqual(this.annotations, ((ModifiableBOpBase)o).annotations);
        }
        return CoreBaseBOp.annotationsEqual(this.annotations, o.annotations());
    }

    public BOp get(int index) {
        return this.args.get(index);
    }

    public int indexOf(BOp bop) {
        return this.args.indexOf(bop);
    }

    public ModifiableBOpBase setArgs(BOp[] args) {
        if (args == null) {
            throw new IllegalArgumentException();
        }
        this.args.clear();
        for (BOp arg : args) {
            this.addArg(arg);
        }
        this.mutation();
        return this;
    }

    public ModifiableBOpBase setArg(int index, BOp newArg) {
        if (newArg == null) {
            throw new IllegalArgumentException();
        }
        if (newArg == this) {
            throw new IllegalArgumentException();
        }
        this.args.set(index, newArg);
        this.mutation();
        return this;
    }

    public void addArg(BOp newArg) {
        if (newArg == null) {
            throw new IllegalArgumentException();
        }
        if (newArg == this) {
            throw new IllegalArgumentException();
        }
        this.args.add(newArg);
        this.mutation();
    }

    public void addArg(int index, BOp newArg) {
        if (newArg == null) {
            throw new IllegalArgumentException();
        }
        if (newArg == this) {
            throw new IllegalArgumentException();
        }
        this.args.add(index, newArg);
        this.mutation();
    }

    public void addArgIfAbsent(BOp arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        if (arg == this) {
            throw new IllegalArgumentException();
        }
        if (!this.args.contains(arg)) {
            this.addArg(arg);
        }
    }

    public boolean removeArg(BOp arg) {
        if (arg == null) {
            throw new IllegalArgumentException();
        }
        if (arg == this) {
            throw new IllegalArgumentException();
        }
        if (this.args.remove(arg)) {
            this.mutation();
            return true;
        }
        return false;
    }

    public int replaceWith(BOp oldChild, BOp newChild) {
        ModifiableBOpBase p = this;
        int arity = p.arity();
        int nmods = 0;
        for (int i = 0; i < arity; ++i) {
            BOp child = p.get(i);
            if (child != oldChild) continue;
            p.setArg(i, newChild);
            ++nmods;
        }
        return nmods;
    }

    public int arity() {
        return this.args.size();
    }

    public final List<BOp> args() {
        return new NotifyingList<BOp>(this);
    }

    public final Iterator<BOp> argIterator() {
        return new NotifyingList<BOp>(this, this.args).iterator();
    }

    public BOp[] toArray() {
        return this.args.toArray(new BOp[this.args.size()]);
    }

    public <T> T[] toArray(T[] a) {
        return this.args.toArray(a);
    }

    public Object getProperty(String name) {
        return this.annotations.get(name);
    }

    public ModifiableBOpBase copyAll(Map<String, Object> anns) {
        this.annotations.putAll(anns);
        return this;
    }

    public ModifiableBOpBase setProperty(String name, Object value) {
        if (value == null) {
            if (this.annotations.remove(name) != null) {
                this.mutation();
            }
        } else {
            this.annotations.put(name, value);
            this.mutation();
        }
        return this;
    }

    public ModifiableBOpBase setUnboundProperty(String name, Object value) {
        Object oldValue = this.getProperty(name);
        if (oldValue != null) {
            throw new IllegalStateException("Already set: name=" + name + ", value=" + oldValue);
        }
        this.setProperty(name, value);
        return this;
    }

    public ModifiableBOpBase clearProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.annotations.remove(name) != null) {
            this.mutation();
        }
        return this;
    }

    public void setId(int id) {
        this.setProperty(BOp.Annotations.BOP_ID, id);
    }

    private static class NotifyingListIterator<T>
    implements ListIterator<T> {
        private final ModifiableBOpBase bop;
        private final ListIterator<T> delegate;

        NotifyingListIterator(ModifiableBOpBase bop, ListIterator<T> listIterator) {
            this.bop = bop;
            this.delegate = listIterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public T next() {
            return this.delegate.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public T previous() {
            return this.delegate.previous();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            this.delegate.remove();
            this.bop.mutation();
        }

        @Override
        public void set(T e) {
            this.delegate.set(e);
            this.bop.mutation();
        }

        @Override
        public void add(T e) {
            this.delegate.add(e);
            this.bop.mutation();
        }
    }

    private static class NotifyingList<T>
    implements List<T> {
        private final ModifiableBOpBase bop;
        private final List<T> delegate;

        NotifyingList(ModifiableBOpBase bop) {
            this(bop, bop.args);
        }

        NotifyingList(ModifiableBOpBase bop, List<T> subList) {
            this.bop = bop;
            this.delegate = subList;
        }

        private boolean mutation(boolean modified) {
            if (modified) {
                this.bop.mutation();
            }
            return modified;
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return new NotifyingListIterator<T>(this.bop, this.delegate.listIterator());
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T1> T1[] toArray(T1[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(T e) {
            return this.mutation(this.delegate.add(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.mutation(this.delegate.remove(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            return this.mutation(this.delegate.addAll(c));
        }

        @Override
        public boolean addAll(int index, Collection<? extends T> c) {
            return this.mutation(this.delegate.addAll(index, c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.mutation(this.delegate.removeAll(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.mutation(this.delegate.retainAll(c));
        }

        @Override
        public void clear() {
            this.delegate.clear();
            this.bop.mutation();
        }

        @Override
        public boolean equals(Object o) {
            return this.delegate.equals(o);
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public T get(int index) {
            return this.delegate.get(index);
        }

        @Override
        public T set(int index, T element) {
            T ret = this.delegate.set(index, element);
            this.bop.mutation();
            return ret;
        }

        @Override
        public void add(int index, T element) {
            this.delegate.add(index, element);
            this.bop.mutation();
        }

        @Override
        public T remove(int index) {
            T ret = this.delegate.remove(index);
            this.bop.mutation();
            return ret;
        }

        @Override
        public int indexOf(Object o) {
            return this.delegate.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.delegate.lastIndexOf(o);
        }

        @Override
        public ListIterator<T> listIterator() {
            return new NotifyingListIterator<T>(this.bop, this.delegate.listIterator());
        }

        @Override
        public ListIterator<T> listIterator(int index) {
            return new NotifyingListIterator<T>(this.bop, this.delegate.listIterator(index));
        }

        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            return new NotifyingList<T>(this.bop, this.delegate.subList(fromIndex, toIndex));
        }
    }
}

