/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Factory;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.BaseInfGraph;
import org.apache.jena.reasoner.Derivation;
import org.apache.jena.reasoner.FGraph;
import org.apache.jena.reasoner.Finder;
import org.apache.jena.reasoner.FinderUtil;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.ReasonerException;
import org.apache.jena.reasoner.TriplePattern;
import org.apache.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.Functor;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.impl.FRuleEngineI;
import org.apache.jena.reasoner.rulesys.impl.FRuleEngineIFactory;
import org.apache.jena.reasoner.rulesys.impl.SafeGraph;
import org.apache.jena.util.OneToManyMap;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;

public class BasicForwardRuleInfGraph
extends BaseInfGraph
implements ForwardRuleInfGraphI {
    protected OneToManyMap<Triple, Derivation> derivations;
    protected FGraph fdeductions;
    protected Graph safeDeductions;
    protected Graph schemaGraph;
    protected FRuleEngineI engine;
    private List<Rule> rules;
    public boolean filterFunctors = true;
    protected boolean traceOn = false;

    public BasicForwardRuleInfGraph(Reasoner reasoner, Graph schema) {
        super(null, reasoner);
        this.instantiateRuleEngine(null);
        this.schemaGraph = schema;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List<Rule> rules, Graph schema) {
        super(null, reasoner);
        this.instantiateRuleEngine(rules);
        this.rules = rules;
        this.schemaGraph = schema;
    }

    public BasicForwardRuleInfGraph(Reasoner reasoner, List<Rule> rules, Graph schema, Graph data) {
        this(reasoner, rules, schema);
        this.rebind(data);
    }

    protected void instantiateRuleEngine(List<Rule> rules) {
        this.engine = FRuleEngineIFactory.getInstance().createFRuleEngineI(this, rules, false);
    }

    public void setRuleStore(Object ruleStore) {
        this.engine.setRuleStore(ruleStore);
    }

    @Override
    public void rebind(Graph data) {
        this.fdata = new FGraph(data);
        this.rebind();
    }

    @Override
    public void rebind() {
        ++this.version;
        this.setPreparedState(false);
    }

    @Override
    public Graph getSchemaGraph() {
        return this.schemaGraph;
    }

    @Override
    public synchronized void prepare() {
        if (this.isPrepared()) {
            return;
        }
        this.setPreparedState(true);
        this.fdeductions = new FGraph(this.createDeductionsGraph());
        boolean rulesLoaded = false;
        if (this.schemaGraph != null) {
            rulesLoaded = this.preloadDeductions(this.schemaGraph);
        }
        if (rulesLoaded) {
            this.engine.fastInit(this.fdata);
        } else {
            this.engine.init(true, this.fdata);
        }
    }

    protected boolean preloadDeductions(Graph preloadIn) {
        Graph d = this.fdeductions.getGraph();
        BasicForwardRuleInfGraph preload = (BasicForwardRuleInfGraph)preloadIn;
        if (preload.rules == this.rules) {
            ExtendedIterator<Triple> i = preload.find(null, null, null);
            while (i.hasNext()) {
                d.add((Triple)i.next());
            }
            this.engine.setRuleStore(preload.engine.getRuleStore());
            return true;
        }
        return false;
    }

    @Override
    public void addDeduction(Triple t) {
        this.getDeductionsGraph().add(t);
    }

    @Override
    public void setFunctorFiltering(boolean param) {
        this.filterFunctors = param;
    }

    @Override
    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation) {
        return this.findWithContinuation(pattern, continuation, true);
    }

    private ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder continuation, boolean filter) {
        this.checkOpen();
        this.requirePrepared();
        ExtendedIterator<Triple> result = null;
        result = this.fdata == null ? this.fdeductions.findWithContinuation(pattern, continuation) : (continuation == null ? this.fdata.findWithContinuation(pattern, this.fdeductions) : this.fdata.findWithContinuation(pattern, FinderUtil.cascade(this.fdeductions, continuation)));
        if (filter && this.filterFunctors) {
            return result.filterDrop(Functor.acceptFilter);
        }
        return result;
    }

    @Override
    protected ExtendedIterator<Triple> graphBaseFind(Node subject, Node property, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, property, object), null);
    }

    @Override
    public ExtendedIterator<Triple> find(TriplePattern pattern) {
        return this.findWithContinuation(pattern, null);
    }

    @Override
    public synchronized void performAdd(Triple t) {
        ++this.version;
        this.fdata.getGraph().add(t);
        if (this.isPrepared()) {
            this.engine.add(t);
        }
    }

    @Override
    public int graphBaseSize() {
        this.checkOpen();
        this.requirePrepared();
        int baseSize = this.fdata.getGraph().size();
        int dedSize = this.fdeductions.getGraph().size();
        return baseSize + dedSize;
    }

    @Override
    public void performDelete(Triple t) {
        Graph data;
        ++this.version;
        if (this.fdata != null && (data = this.fdata.getGraph()) != null) {
            data.delete(t);
        }
        if (!this.isPrepared()) {
            this.fdeductions.getGraph().delete(t);
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.engine = null;
            this.fdeductions = null;
            this.rules = null;
            this.schemaGraph = null;
            super.close();
        }
    }

    @Override
    public void addBRule(Rule brule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + brule.toShortString());
    }

    @Override
    public void deleteBRule(Rule brule) {
        throw new ReasonerException("Forward reasoner does not support hybrid rules - " + brule.toShortString());
    }

    @Override
    public Graph getDeductionsGraph() {
        this.prepare();
        return this.safeDeductions;
    }

    protected Graph createDeductionsGraph() {
        Graph dg;
        if (this.fdeductions != null && (dg = this.fdeductions.getGraph()) != null) {
            this.safeDeductions.clear();
            return dg;
        }
        dg = Factory.createGraphMem();
        this.safeDeductions = new SafeGraph(dg);
        return dg;
    }

    @Override
    public Graph getCurrentDeductionsGraph() {
        return this.safeDeductions;
    }

    @Override
    public ExtendedIterator<Triple> findDataMatches(Node subject, Node predicate, Node object) {
        return this.findWithContinuation(new TriplePattern(subject, predicate, object), null, false);
    }

    @Override
    public void logDerivation(Triple t, Derivation derivation) {
        this.derivations.put(t, derivation);
    }

    @Override
    public void silentAdd(Triple t) {
        this.fdeductions.getGraph().add(t);
    }

    @Override
    public void setDerivationLogging(boolean recordDerivations) {
        this.recordDerivations = recordDerivations;
        this.engine.setDerivationLogging(recordDerivations);
        this.derivations = recordDerivations ? new OneToManyMap() : null;
    }

    @Override
    public boolean shouldLogDerivations() {
        return this.recordDerivations;
    }

    @Override
    public Iterator<Derivation> getDerivation(Triple t) {
        if (this.derivations == null) {
            return new NullIterator();
        }
        return this.derivations.getAll(t);
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    @Override
    public boolean shouldTrace() {
        return this.traceOn && this.engine.shouldTrace();
    }

    public long getNRulesFired() {
        return this.engine.getNRulesFired();
    }
}

