/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.Collection;
import java.util.HashSet;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.AbstractCollectorEx;

public class OWLObjectComponentCollector
extends AbstractCollectorEx<OWLObject> {
    public OWLObjectComponentCollector() {
        super(new HashSet());
    }

    public Collection<OWLObject> getComponents(OWLObject object) {
        return object.accept(this);
    }

    @Override
    public Collection<OWLObject> doDefault(Object object) {
        if (object instanceof OWLObject) {
            this.objects.add((OWLObject)object);
        }
        return super.doDefault(object);
    }

    @Override
    public Collection<OWLObject> visit(OWLOntology ontology) {
        ontology.axioms().forEach(a -> a.accept(this));
        return (Collection)super.visit(ontology);
    }

    @Override
    public Collection<OWLObject> visit(OWLLiteral l) {
        this.objects.add(l);
        l.getDatatype().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLObject> visit(OWLAnnotation l) {
        return this.objects;
    }

    @Override
    public Collection<OWLObject> visit(OWLAnnotationAssertionAxiom l) {
        this.objects.add(l);
        ((OWLAnnotationSubject)l.getSubject()).accept(this);
        l.getAnnotation().accept(this);
        return this.objects;
    }

    @Override
    public Collection<OWLObject> visit(SWRLVariable node) {
        this.objects.add(node);
        return this.objects;
    }

    @Override
    public Collection<OWLObject> visit(SWRLBuiltInAtom node) {
        this.objects.add(node);
        node.allArguments().forEach(a -> a.accept(this));
        return this.objects;
    }

    @Override
    public Collection<OWLObject> visit(OWLDataSomeValuesFrom ce) {
        this.objects.add(ce);
        return ce.getProperty().accept(this);
    }

    @Override
    public Collection<OWLObject> visit(OWLDataAllValuesFrom ce) {
        this.objects.add(ce);
        return ce.getProperty().accept(this);
    }

    @Override
    public Collection<OWLObject> visit(OWLDataHasValue ce) {
        this.objects.add(ce);
        return ce.getProperty().accept(this);
    }

    @Override
    public Collection<OWLObject> visit(OWLDataMinCardinality ce) {
        this.objects.add(ce);
        return ce.getProperty().accept(this);
    }

    @Override
    public Collection<OWLObject> visit(OWLDataMaxCardinality ce) {
        this.objects.add(ce);
        return ce.getProperty().accept(this);
    }

    @Override
    public Collection<OWLObject> visit(OWLDataExactCardinality ce) {
        this.objects.add(ce);
        return ce.getProperty().accept(this);
    }

    @Override
    public Collection<OWLObject> visit(OWLDataPropertyDomainAxiom ce) {
        this.objects.add(ce);
        return ((OWLDataPropertyExpression)ce.getProperty()).accept(this);
    }

    @Override
    public Collection<OWLObject> visit(SWRLDifferentIndividualsAtom node) {
        this.objects.add(node);
        node.allArguments().forEach(a -> a.accept(this));
        return this.objects;
    }

    @Override
    public Collection<OWLObject> visit(SWRLSameIndividualAtom node) {
        this.objects.add(node);
        node.allArguments().forEach(a -> a.accept(this));
        return this.objects;
    }
}

