/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.postgresql;

import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.sail.rdbms.algebra.SqlConcat;
import org.openrdf.sail.rdbms.algebra.SqlNull;
import org.openrdf.sail.rdbms.algebra.SqlRegex;
import org.openrdf.sail.rdbms.algebra.StringValue;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelVisitorBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;

public class PgSqlRegexFlagsInliner
extends RdbmsQueryModelVisitorBase<RuntimeException>
implements QueryOptimizer {
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit((QueryModelVisitor)this);
    }

    @Override
    public void meet(SqlRegex node) throws RuntimeException {
        super.meet(node);
        SqlExpr flags = node.getFlagsArg();
        if (!(flags instanceof SqlNull)) {
            SqlExpr pattern = node.getPatternArg();
            SqlExpr prefix = this.concat(this.str("(?"), flags, this.str(")"));
            pattern.replaceWith(this.concat(prefix, pattern.clone()));
            node.setFlagsArg(null);
        }
    }

    private SqlExpr str(String string) {
        return new StringValue(string);
    }

    private SqlExpr concat(SqlExpr ... exprs) {
        SqlExpr concat = null;
        for (SqlExpr expr : exprs) {
            concat = concat == null ? expr : new SqlConcat(concat, expr);
        }
        return concat;
    }
}

