/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.main.iterator;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.QueryExecException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.engine.main.QC;
import org.apache.jena.sparql.exec.http.Service;
import org.apache.jena.sparql.service.ServiceExecution;
import org.apache.jena.sparql.service.ServiceExecutorFactory;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.util.Context;

public class QueryIterService
extends QueryIterRepeatApply {
    protected OpService opService;

    public QueryIterService(QueryIterator input, OpService opService, ExecutionContext context2) {
        super(input, context2);
        if (context2.getContext().isFalse(Service.httpServiceAllowed)) {
            throw new QueryExecException("SERVICE not allowed");
        }
        if (context2.getContext().isFalse(Service.serviceAllowed)) {
            throw new QueryExecException("SERVICE not allowed");
        }
        this.opService = opService;
    }

    @Override
    protected QueryIterator nextStage(Binding outerBinding) {
        boolean silent = this.opService.getSilent();
        ExecutionContext execCxt = this.getExecContext();
        Context cxt = execCxt.getContext();
        ServiceExecutorRegistry registry = ServiceExecutorRegistry.get(cxt);
        ServiceExecution svcExec = null;
        OpService substitutedOp = (OpService)QC.substitute(this.opService, outerBinding);
        try {
            if (registry != null) {
                for (ServiceExecutorFactory factory : registry.getFactories()) {
                    if (factory == null) {
                        Log.warn((Object)this, (String)("SERVICE <" + this.opService.getService().toString() + ">: Null item in custom ServiceExecutionRegistry"));
                        continue;
                    }
                    svcExec = factory.createExecutor(substitutedOp, this.opService, outerBinding, execCxt);
                    if (svcExec == null) continue;
                    break;
                }
            }
            if (svcExec == null) {
                throw new QueryExecException("No SERVICE handler");
            }
            QueryIterator qIter = svcExec.exec();
            qIter = QueryIter.makeTracked(qIter, this.getExecContext());
            return new QueryIterCommonParent(qIter, outerBinding, this.getExecContext());
        }
        catch (RuntimeException ex) {
            if (silent) {
                Log.warn((Object)this, (String)("SERVICE " + NodeFmtLib.strTTL(substitutedOp.getService()) + " : " + ex.getMessage()));
                return QueryIterSingleton.create(outerBinding, this.getExecContext());
            }
            throw ex;
        }
    }
}

