/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.json;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.Keywords;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public final class JsonMapBuilder {
    private final Map<String, Object> map;

    private JsonMapBuilder(Map<String, Object> map) {
        this.map = map;
    }

    public JsonObject build() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : this.map.entrySet()) {
            if (entry.getValue() instanceof JsonValue) {
                builder.add(entry.getKey(), (JsonValue)entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof JsonArrayBuilder) {
                builder.add(entry.getKey(), (JsonValue)((JsonArrayBuilder)entry.getValue()).build());
                continue;
            }
            if (entry.getValue() instanceof JsonMapBuilder) {
                builder.add(entry.getKey(), (JsonValue)((JsonMapBuilder)entry.getValue()).build());
                continue;
            }
            throw new IllegalStateException();
        }
        return builder.build();
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public void put(String key, JsonValue item) {
        this.map.put(key, item);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public static JsonMapBuilder create(JsonObject object) {
        return new JsonMapBuilder(new LinkedHashMap<String, Object>((Map<String, Object>)object));
    }

    public static JsonMapBuilder create(Map<String, JsonValue> object) {
        return new JsonMapBuilder(new LinkedHashMap<String, JsonValue>(object));
    }

    public static JsonMapBuilder create() {
        return new JsonMapBuilder(new LinkedHashMap<String, Object>());
    }

    public Optional<JsonValue> get(String key) {
        Object item = this.map.get(key);
        if (item == null) {
            return Optional.empty();
        }
        if (item instanceof JsonValue) {
            return Optional.of((JsonValue)item);
        }
        if (item instanceof JsonArrayBuilder) {
            return Optional.of(((JsonArrayBuilder)item).build());
        }
        if (item instanceof JsonMapBuilder) {
            return Optional.of(((JsonMapBuilder)item).build());
        }
        throw new IllegalStateException();
    }

    public boolean isNotValueObject() {
        return !Keywords.allMatch(this.map.keySet(), "@type", "@value", "@direction", "@language", "@index", "@annotation");
    }

    public JsonArray valuesToArray() {
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (Object item : this.map.values()) {
            if (item instanceof JsonValue) {
                array.add((JsonValue)item);
                continue;
            }
            if (item instanceof JsonArrayBuilder) {
                array.add((JsonValue)((JsonArrayBuilder)item).build());
                continue;
            }
            if (item instanceof JsonMapBuilder) {
                array.add((JsonValue)((JsonMapBuilder)item).build());
                continue;
            }
            throw new IllegalStateException();
        }
        return array.build();
    }

    public void add(String key, JsonValue value) {
        this.add(key, value, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(String key, JsonValue value, boolean asArray) {
        if (asArray) {
            this.toArray(key);
        }
        if (JsonUtils.isArray(value)) {
            value.asJsonArray().forEach(v -> this.add(key, (JsonValue)v, asArray));
            return;
        } else {
            Object original = this.map.get(key);
            if (original != null) {
                if (original instanceof JsonValue) {
                    if (JsonUtils.isArray((JsonValue)original)) {
                        this.map.put(key, Json.createArrayBuilder((JsonArray)((JsonValue)original).asJsonArray()).add(value));
                        return;
                    } else {
                        this.map.put(key, Json.createArrayBuilder().add((JsonValue)original).add(value));
                    }
                    return;
                } else if (original instanceof JsonArrayBuilder) {
                    ((JsonArrayBuilder)original).add(value);
                    return;
                } else {
                    if (!(original instanceof JsonMapBuilder)) throw new IllegalStateException();
                    this.map.put(key, Json.createArrayBuilder().add((JsonValue)((JsonMapBuilder)original).build()));
                }
                return;
            } else {
                this.map.put(key, value);
            }
        }
    }

    public void add(String key, JsonObjectBuilder value) {
        this.add(key, (JsonValue)value.build());
    }

    private void toArray(String key) {
        if (this.map.containsKey(key)) {
            Object original = this.map.get(key);
            if (original instanceof JsonValue) {
                if (JsonUtils.isArray((JsonValue)original)) {
                    this.map.put(key, Json.createArrayBuilder((JsonArray)((JsonValue)original).asJsonArray()));
                } else {
                    this.map.put(key, Json.createArrayBuilder().add((JsonValue)original));
                }
                return;
            }
            if (original instanceof JsonArrayBuilder) {
                return;
            }
            if (original instanceof JsonMapBuilder) {
                this.map.put(key, Json.createArrayBuilder().add((JsonValue)((JsonMapBuilder)original).build()));
                return;
            }
            throw new IllegalStateException();
        }
        this.map.put(key, Json.createArrayBuilder());
    }

    public void put(String key, JsonMapBuilder value) {
        this.map.put(key, value);
    }

    public JsonMapBuilder getMapBuilder(String key) {
        Object value = this.map.get(key);
        if (value != null) {
            if (value instanceof JsonMapBuilder) {
                return (JsonMapBuilder)value;
            }
            if (value instanceof JsonValue) {
                return JsonMapBuilder.create(((JsonValue)value).asJsonObject());
            }
            throw new IllegalStateException();
        }
        JsonMapBuilder result = JsonMapBuilder.create();
        this.map.put(key, result);
        return result;
    }

    public void remove(String key) {
        this.map.remove(key);
    }

    public String toString() {
        return this.map.toString();
    }
}

