/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.slurm.job;

import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.ac.cam.cares.jps.base.slurm.job.Property;
import uk.ac.cam.cares.jps.base.slurm.job.SlurmJobException;
import uk.ac.cam.cares.jps.base.slurm.job.Status;
import uk.ac.cam.cares.jps.base.slurm.job.Utils;

public class Workspace {
    private Logger LOGGER = LogManager.getLogger(Workspace.class);
    public long previousTimeStamp = System.nanoTime();

    public static File getWorkspace(String workspaceParentPath, String agentClass) {
        File dir = new File(workspaceParentPath);
        for (File file : dir.listFiles()) {
            String[] tokens;
            if (!file.isDirectory() || !file.getName().toLowerCase().startsWith(agentClass.toLowerCase()) || (tokens = file.getName().split("_")).length < 2 || tokens[tokens.length - 1].length() <= 6 || !NumberUtils.isNumber(tokens[tokens.length - 1])) continue;
            return file;
        }
        return Workspace.createWorkspaceName(workspaceParentPath, agentClass);
    }

    private static File createWorkspaceName(String workspaceParentPath, String agentClass) {
        String workspaceName = agentClass.concat("_").concat("" + System.nanoTime());
        File workspace = new File(workspaceParentPath.concat(File.separator).concat(workspaceName));
        if (workspace.mkdir()) {
            return workspace;
        }
        return null;
    }

    private boolean isWorkspaceAvailable(String workspaceParentPath, String agentClass) {
        File dir = new File(workspaceParentPath);
        if (dir != null && dir.isDirectory()) {
            return this.isWorkspaceAvailable(dir, agentClass);
        }
        return false;
    }

    protected boolean isWorkspaceAvailable(File dir, String agentClass) {
        for (File file : dir.listFiles()) {
            if (!file.isDirectory() || !file.getName().toLowerCase().startsWith(agentClass.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public String createJSONInputFile(File workspaceFolder, String jsonInputFilePath, String jsonString) throws IOException {
        BufferedWriter jsonInputFile = Utils.openBufferedWriter(jsonInputFilePath);
        if (jsonInputFile == null) {
            return null;
        }
        jsonInputFile.write(jsonString);
        jsonInputFile.close();
        return Status.JOB_SETUP_SUCCESS_MSG.getName();
    }

    public String getInputFilePath(File jobFolder, String hpcAddress, String inputFileExtension) {
        return jobFolder.getAbsolutePath().concat(File.separator).concat(hpcAddress).concat("_").concat(this.getTimeStampPart(jobFolder.getName())).concat(inputFileExtension);
    }

    public String getInputFileExtension(File input) throws SlurmJobException {
        if (input.isFile()) {
            return input.getAbsolutePath().substring(input.getAbsolutePath().lastIndexOf("."));
        }
        this.LOGGER.error("SlurmJobAPI: The provided input file is not a file.");
        throw new SlurmJobException("SlurmJobAPI: The provided input file is not a file.");
    }

    public File createJobFolder(String workspacePath, String hpcAddress, long timeStamp) {
        String jobFolder = hpcAddress.concat("_").concat("" + timeStamp);
        File workspace = new File(workspacePath.concat(File.separator).concat(jobFolder));
        if (workspace.mkdir()) {
            return workspace;
        }
        return null;
    }

    public String createInputFile(String inputFileDestinationPath, File input) throws IOException {
        this.copyFile(input, new File(inputFileDestinationPath));
        return Status.JOB_SETUP_SUCCESS_MSG.getName();
    }

    public String createStatusFile(File workspaceFolder, String statusFilePath, String hpcAddress) throws IOException {
        BufferedWriter statusFile = Utils.openBufferedWriter(statusFilePath);
        if (statusFile == null) {
            return null;
        }
        statusFile.write(Status.ATTRIBUTE_JOB_STATUS.getName().concat(" "));
        statusFile.write(Status.STATUS_JOB_NOT_STARTED.getName().concat("\n"));
        statusFile.write(Status.ATTRIBUTE_JOB_ID.getName().concat("\n"));
        statusFile.write(Status.ATTRIBUTE_AGENT_ID.getName().concat(" "));
        statusFile.write(workspaceFolder.getName().concat("\n"));
        statusFile.write(Status.ATTRIBUTE_HPC_ADDRESS.getName().concat(" "));
        statusFile.write(hpcAddress.concat("\n"));
        statusFile.write(Status.ATTRIBUTE_JOB_OUTPUT.getName().concat("\n"));
        statusFile.close();
        return Status.JOB_SETUP_SUCCESS_MSG.getName();
    }

    public String copyFile(String source, String destination) throws IOException {
        try {
            this.copyFile(new File(source), new File(destination));
            if (destination.endsWith(".sh")) {
                Utils.translateLineEndingIntoUnix(new File(destination));
            }
            return Status.JOB_SETUP_SUCCESS_MSG.getName();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getTimeStampPart(String folder) {
        String[] tokens;
        if (folder.contains("_") && (tokens = folder.split("_")).length == 2 && tokens[1] != null && StringUtils.isNumeric(tokens[1])) {
            return tokens[1];
        }
        return null;
    }

    public String getStatusFilePath(File jobFolder) {
        return jobFolder.getAbsolutePath().concat(File.separator).concat(Property.STATUS_FILE_NAME.getPropertyName());
    }

    public String getJSONInputFilePath(File jobFolder) {
        return jobFolder.getAbsolutePath().concat(File.separator).concat(Property.JSON_INPUT_FILE_NAME.getPropertyName());
    }

    public String copyScriptFile(String source, String destination, String slurmScriptFileName) throws IOException {
        try {
            this.copyFile(new File(source), new File(destination.concat(File.separator).concat(slurmScriptFileName)));
            Utils.translateLineEndingIntoUnix(new File(destination.concat(File.separator).concat(slurmScriptFileName)));
            return Status.JOB_SETUP_SUCCESS_MSG.getName();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void copyFile(File from, File to) throws IOException {
        Files.copy(from, to);
    }
}

