/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import uk.ac.cam.cares.jps.base.interfaces.CacheInterface;

public class LRUCache<K, V>
implements CacheInterface<K, V> {
    private final V DEFAULT_VALUE = null;
    private final int capacity;
    private Map<K, V> cache;

    public LRUCache(int size) {
        this.capacity = size;
        this.cache = Collections.synchronizedMap(new LinkedHashMap<K, V>(size, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > LRUCache.this.capacity;
            }
        });
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put(key, value);
    }

    @Override
    public V get(K key) {
        return this.cache.getOrDefault(key, this.DEFAULT_VALUE);
    }

    @Override
    public boolean contains(K key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.size() == 0;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public int capacity() {
        return this.capacity;
    }
}

