/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata;

import com.bigdata.Banner;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class BigdataStatics {
    public static final boolean debug = Boolean.getBoolean("com.bigdata.debug");
    public static final String HOSTNAME = "com.bigdata.hostname";
    public static int echoProcessStartupLineCount = 30;
    public static final boolean threadLocalBuffers = Boolean.getBoolean("com.bigdata.threadLocalBuffers");
    public static final boolean runKnownBadTests = Boolean.getBoolean("com.bigdata.runKnownBadTests");

    public static final String getContextPath() {
        return "/bigdata";
    }

    public static void threadDump(Appendable w) {
        try {
            DateFormat df = DateFormat.getDateTimeInstance();
            Date date = new Date(System.currentTimeMillis());
            w.append(Banner.getBanner());
            w.append("Thread dump. Date:" + df.format(date));
            w.append("\n\n");
            TreeMap<Thread, StackTraceElement[]> dump = new TreeMap<Thread, StackTraceElement[]>(new Comparator<Thread>(){

                @Override
                public int compare(Thread o1, Thread o2) {
                    return Long.compare(o1.getId(), o2.getId());
                }
            });
            dump.putAll(Thread.getAllStackTraces());
            for (Map.Entry threadEntry : dump.entrySet()) {
                Thread thread = (Thread)threadEntry.getKey();
                w.append("THREAD#" + thread.getId() + ", name=" + thread.getName() + ", state=" + (Object)((Object)thread.getState()) + ", priority=" + thread.getPriority() + ", daemon=" + thread.isDaemon() + "\n");
                for (StackTraceElement elem : (StackTraceElement[])threadEntry.getValue()) {
                    w.append("\t" + elem.toString() + "\n");
                }
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

