import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manage a repository in GitHub.
 *
 * @schema CfnRepositoryProps
 */
export interface CfnRepositoryProps {
    /**
     * The organization name. The name is not case sensitive. If not specified, then the managed repository will be within the currently logged-in user account.
     *
     * @schema CfnRepositoryProps#Organization
     */
    readonly organization?: string;
    /**
     * The name of the repository.
     *
     * @schema CfnRepositoryProps#Name
     */
    readonly name: string;
    /**
     * A short description of the repository.
     *
     * @schema CfnRepositoryProps#Description
     */
    readonly description?: string;
    /**
     * A URL with more information about the repository.
     *
     * @schema CfnRepositoryProps#Homepage
     */
    readonly homepage?: string;
    /**
     * Whether the repository is private.
     *
     * @schema CfnRepositoryProps#Private
     */
    readonly private?: boolean;
    /**
     * Can be public or private. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be internal. Note: For GitHub Enterprise Server and GitHub AE, this endpoint will only list repositories available to all users on the enterprise. For more information, see "Creating an internal repository" (https://docs.github.com/en/repositories/creating-and-managing-repositories/about-repositories#about-internal-repositories) in the GitHub Help documentation.
     *
     * @schema CfnRepositoryProps#Visibility
     */
    readonly visibility?: CfnRepositoryPropsVisibility;
    /**
     * Either true to enable issues for this repository or false to disable them.
     *
     * @schema CfnRepositoryProps#HasIssues
     */
    readonly hasIssues?: boolean;
    /**
     * Either true to enable projects for this repository or false to disable them. Note: If you're creating a repository in an organization that has disabled repository projects, the default is false, and if you pass true, the API returns an error.
     *
     * @schema CfnRepositoryProps#HasProjects
     */
    readonly hasProjects?: boolean;
    /**
     * Either true to enable the wiki for this repository or false to disable it.
     *
     * @schema CfnRepositoryProps#HasWiki
     */
    readonly hasWiki?: boolean;
    /**
     * Either true to make this repo available as a template repository or false to prevent it.
     *
     * @schema CfnRepositoryProps#IsTemplate
     */
    readonly isTemplate?: boolean;
    /**
     * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
     *
     * @schema CfnRepositoryProps#TeamId
     */
    readonly teamId?: number;
    /**
     * Pass true to create an initial commit with empty README.
     *
     * @schema CfnRepositoryProps#AutoInit
     */
    readonly autoInit?: boolean;
    /**
     * Desired language or platform .gitignore template to apply. Use the name of the template without the extension (https://github.com/github/gitignore). For example, "Haskell".
     *
     * @schema CfnRepositoryProps#GitIgnoreTemplate
     */
    readonly gitIgnoreTemplate?: string;
    /**
     * Choose an open source license template (https://choosealicense.com/) that best suits your needs, and then use the license keyword (https://docs.github.com/en/repositories/managing-your-repositorys-settings-and-features/customizing-your-repository/licensing-a-repository#searching-github-by-license-type) as the license_template string. For example, "mit" or "mpl-2.0".
     *
     * @schema CfnRepositoryProps#LicenseTemplate
     */
    readonly licenseTemplate?: string;
    /**
     * Either true to allow squash-merging pull requests, or false to prevent squash-merging.
     *
     * @schema CfnRepositoryProps#AllowSquashMerge
     */
    readonly allowSquashMerge?: boolean;
    /**
     * Either true to allow merging pull requests with a merge commit, or false to prevent merging pull requests with merge commits.
     *
     * @schema CfnRepositoryProps#AllowMergeCommit
     */
    readonly allowMergeCommit?: boolean;
    /**
     * Either true to allow rebase-merging pull requests, or false to prevent rebase-merging.
     *
     * @schema CfnRepositoryProps#AllowRebaseMerge
     */
    readonly allowRebaseMerge?: boolean;
    /**
     * Either true to allow auto-merge on pull requests, or false to disallow auto-merge.
     *
     * @schema CfnRepositoryProps#AllowAutoMerge
     */
    readonly allowAutoMerge?: boolean;
    /**
     * Either true to allow automatically deleting head branches when pull requests are merged, or false to prevent automatic deletion.
     *
     * @schema CfnRepositoryProps#DeleteBranchOnMerge
     */
    readonly deleteBranchOnMerge?: boolean;
    /**
     * Either true to allow private forks, or false to prevent private forks.
     *
     * @schema CfnRepositoryProps#AllowForking
     */
    readonly allowForking?: boolean;
    /**
     * true to archive this repository. Note: You cannot unarchive repositories through the API.
     *
     * @schema CfnRepositoryProps#Archived
     */
    readonly archived?: boolean;
    /**
     * @schema CfnRepositoryProps#SecurityAndAnalysis
     */
    readonly securityAndAnalysis?: SecurityAndAnalysis;
}
/**
 * Converts an object of type 'CfnRepositoryProps' to JSON representation.
 */
export declare function toJson_CfnRepositoryProps(obj: CfnRepositoryProps | undefined): Record<string, any> | undefined;
/**
 * Can be public or private. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, visibility can also be internal. Note: For GitHub Enterprise Server and GitHub AE, this endpoint will only list repositories available to all users on the enterprise. For more information, see "Creating an internal repository" (https://docs.github.com/en/repositories/creating-and-managing-repositories/about-repositories#about-internal-repositories) in the GitHub Help documentation.
 *
 * @schema CfnRepositoryPropsVisibility
 */
export declare enum CfnRepositoryPropsVisibility {
    /** public */
    PUBLIC = "public",
    /** private */
    PRIVATE = "private",
    /** internal */
    INTERNAL = "internal"
}
/**
 * Specify which security and analysis features to enable or disable. For example, to enable GitHub Advanced Security, use this data in the body of the PATCH request: {"security_and_analysis": {"advanced_security": {"status": "enabled"}}}. If you have admin permissions for a private repository covered by an Advanced Security license, you can check which security and analysis features are currently enabled by using a GET /repos/{owner}/{repo} request.
 *
 * @schema SecurityAndAnalysis
 */
export interface SecurityAndAnalysis {
    /**
     * @schema SecurityAndAnalysis#AdvanceSecurity
     */
    readonly advanceSecurity?: AdvanceSecurity;
    /**
     * @schema SecurityAndAnalysis#SecretScanning
     */
    readonly secretScanning?: SecretScanning;
    /**
     * @schema SecurityAndAnalysis#SecretScanningPushProtection
     */
    readonly secretScanningPushProtection?: SecretScanningPushProtection;
}
/**
 * Converts an object of type 'SecurityAndAnalysis' to JSON representation.
 */
export declare function toJson_SecurityAndAnalysis(obj: SecurityAndAnalysis | undefined): Record<string, any> | undefined;
/**
 * Use the status property to enable or disable GitHub Advanced Security for this repository. For more information, see "About GitHub Advanced Security." (https://docs.github.com/github/getting-started-with-github/learning-about-github/about-github-advanced-security)
 *
 * @schema AdvanceSecurity
 */
export interface AdvanceSecurity {
    /**
     * Can be enabled or disabled.
     *
     * @schema AdvanceSecurity#Status
     */
    readonly status: AdvanceSecurityStatus;
}
/**
 * Converts an object of type 'AdvanceSecurity' to JSON representation.
 */
export declare function toJson_AdvanceSecurity(obj: AdvanceSecurity | undefined): Record<string, any> | undefined;
/**
 * Use the status property to enable or disable secret scanning for this repository. For more information, see "About secret scanning." (https://docs.github.com/code-security/secret-security/about-secret-scanning)
 *
 * @schema SecretScanning
 */
export interface SecretScanning {
    /**
     * Can be enabled or disabled.
     *
     * @schema SecretScanning#Status
     */
    readonly status: SecretScanningStatus;
}
/**
 * Converts an object of type 'SecretScanning' to JSON representation.
 */
export declare function toJson_SecretScanning(obj: SecretScanning | undefined): Record<string, any> | undefined;
/**
 * Use the status property to enable or disable secret scanning push protection for this repository. For more information, see "Protecting pushes with secret scanning." (https://docs.github.com/code-security/secret-scanning/protecting-pushes-with-secret-scanning)
 *
 * @schema SecretScanningPushProtection
 */
export interface SecretScanningPushProtection {
    /**
     * Can be enabled or disabled.
     *
     * @schema SecretScanningPushProtection#Status
     */
    readonly status: SecretScanningPushProtectionStatus;
}
/**
 * Converts an object of type 'SecretScanningPushProtection' to JSON representation.
 */
export declare function toJson_SecretScanningPushProtection(obj: SecretScanningPushProtection | undefined): Record<string, any> | undefined;
/**
 * Can be enabled or disabled.
 *
 * @schema AdvanceSecurityStatus
 */
export declare enum AdvanceSecurityStatus {
    /** enabled */
    ENABLED = "enabled",
    /** disabled */
    DISABLED = "disabled"
}
/**
 * Can be enabled or disabled.
 *
 * @schema SecretScanningStatus
 */
export declare enum SecretScanningStatus {
    /** enabled */
    ENABLED = "enabled",
    /** disabled */
    DISABLED = "disabled"
}
/**
 * Can be enabled or disabled.
 *
 * @schema SecretScanningPushProtectionStatus
 */
export declare enum SecretScanningPushProtectionStatus {
    /** enabled */
    ENABLED = "enabled",
    /** disabled */
    DISABLED = "disabled"
}
/**
 * A CloudFormation `GitHub::Repositories::Repository`
 *
 * @cloudformationResource GitHub::Repositories::Repository
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
 */
export declare class CfnRepository extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitHub::Repositories::Repository";
    /**
     * Resource props.
     */
    readonly props: CfnRepositoryProps;
    /**
     * Attribute `GitHub::Repositories::Repository.Owner`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrOwner: string;
    /**
     * Attribute `GitHub::Repositories::Repository.HtmlUrl`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrHtmlUrl: string;
    /**
     * Attribute `GitHub::Repositories::Repository.GitUrl`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrGitUrl: string;
    /**
     * Attribute `GitHub::Repositories::Repository.DefaultBranch`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrDefaultBranch: string;
    /**
     * Attribute `GitHub::Repositories::Repository.Language`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrLanguage: string;
    /**
     * Attribute `GitHub::Repositories::Repository.ForksCount`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrForksCount: number;
    /**
     * Attribute `GitHub::Repositories::Repository.StarsCount`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrStarsCount: number;
    /**
     * Attribute `GitHub::Repositories::Repository.WatchersCount`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrWatchersCount: number;
    /**
     * Attribute `GitHub::Repositories::Repository.IssuesCount`
     * @link https://github.com/aws-ia/cloudformation-github-resource-providers.git
     */
    readonly attrIssuesCount: number;
    /**
     * Create a new `GitHub::Repositories::Repository`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnRepositoryProps);
}
