"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeConnectionField = void 0;
const definition_1 = require("./definition");
const ModelResourceIDs_1 = require("./ModelResourceIDs");
function makeConnectionField(fieldName, returnTypeName, args = []) {
    return definition_1.makeField(fieldName, [
        ...args,
        definition_1.makeInputValueDefinition('filter', definition_1.makeNamedType(ModelResourceIDs_1.ModelResourceIDs.ModelFilterInputTypeName(returnTypeName))),
        definition_1.makeInputValueDefinition('limit', definition_1.makeNamedType('Int')),
        definition_1.makeInputValueDefinition('nextToken', definition_1.makeNamedType('String')),
    ], definition_1.makeNamedType(ModelResourceIDs_1.ModelResourceIDs.ModelConnectionTypeName(returnTypeName)));
}
exports.makeConnectionField = makeConnectionField;
//# sourceMappingURL=connectionUtils.js.map