import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Creates a group in GitLab
 *
 * @schema CfnGroupProps
 */
export interface CfnGroupProps {
    /**
     * Name of the group to create
     *
     * @schema CfnGroupProps#Name
     */
    readonly name: string;
    /**
     * Path of the group to create
     *
     * @schema CfnGroupProps#Path
     */
    readonly path?: string;
    /**
     * ID of the group's parent
     *
     * @schema CfnGroupProps#ParentId
     */
    readonly parentId?: number;
}
/**
 * Converts an object of type 'CfnGroupProps' to JSON representation.
 */
export declare function toJson_CfnGroupProps(obj: CfnGroupProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `GitLab::Groups::Group`
 *
 * @cloudformationResource GitLab::Groups::Group
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
export declare class CfnGroup extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitLab::Groups::Group";
    /**
     * Resource props.
     */
    readonly props: CfnGroupProps;
    /**
     * Attribute `GitLab::Groups::Group.Id`
     * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
     */
    readonly attrId: number;
    /**
     * Create a new `GitLab::Groups::Group`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnGroupProps);
}
